/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.icons.AllIcons;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ui.PathEditor;
import com.intellij.openapi.projectRoots.ui.SdkPathEditor;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ui.OrderRootTypeUIFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.jrt.JrtFileSystem;
import com.intellij.ui.components.JBList;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;

public class ClassesOrderRootTypeUIFactory
implements OrderRootTypeUIFactory {
    public SdkPathEditor createPathEditor(Sdk sdk) {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, true, false, true, true);
        return new MySdkPathEditor(descriptor);
    }

    public Icon getIcon() {
        return AllIcons.Nodes.CompiledClassesFolder;
    }

    public String getNodeText() {
        return ProjectBundle.message((String)"library.classes.node", (Object[])new Object[0]);
    }

    private static boolean isJrtRoot(Object value) {
        return value instanceof VirtualFile && JrtFileSystem.isRoot((VirtualFile)value);
    }

    private static class MySdkPathEditor
    extends SdkPathEditor {
        public MySdkPathEditor(FileChooserDescriptor descriptor) {
            super(ProjectBundle.message((String)"sdk.configure.classpath.tab", (Object[])new Object[0]), OrderRootType.CLASSES, descriptor);
        }

        protected boolean isRemoveActionEnabled(Object[] values) {
            if (!super.isRemoveActionEnabled(values)) {
                return false;
            }
            for (Object value : values) {
                if (!ClassesOrderRootTypeUIFactory.isJrtRoot(value)) continue;
                return false;
            }
            return true;
        }

        protected ListCellRenderer createListCellRenderer(JBList list) {
            return new PathEditor.PathCellRenderer(){

                protected String getItemText(Object value) {
                    return ClassesOrderRootTypeUIFactory.isJrtRoot(value) ? LangBundle.message("jrt.node.long", new Object[0]) : super.getItemText(value);
                }

                protected Icon getItemIcon(Object value) {
                    return ClassesOrderRootTypeUIFactory.isJrtRoot(value) ? PlatformIcons.JAR_ICON : super.getItemIcon(value);
                }
            };
        }
    }
}

