/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraries.impl;

import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.ui.configuration.libraries.impl.LibraryPresentationManagerImpl;
import com.intellij.util.Processor;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LibraryUsageCollector
extends AbstractApplicationUsagesCollector {
    @NonNls
    private static final String GROUP_ID = "libraries";

    @Override
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryUsageCollector", "getProjectUsages"));
        }
        final HashSet usedKinds = new HashSet();
        Processor<Library> processor2 = new Processor<Library>(){

            public boolean process(Library library) {
                usedKinds.addAll(LibraryPresentationManagerImpl.getLibraryKinds(library, null));
                return true;
            }
        };
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            ModuleRootManager.getInstance((Module)module).orderEntries().librariesOnly().forEachLibrary((Processor)processor2);
        }
        HashSet<UsageDescriptor> usageDescriptors = new HashSet<UsageDescriptor>();
        for (LibraryKind kind : usedKinds) {
            usageDescriptors.add(new UsageDescriptor(kind.getKindId(), 1));
        }
        HashSet<UsageDescriptor> hashSet = usageDescriptors;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryUsageCollector", "getProjectUsages"));
        }
        return hashSet;
    }

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create(GROUP_ID);
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryUsageCollector", "getGroupId"));
        }
        return groupDescriptor;
    }
}

