/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries.ui;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryRootType;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DetectedLibraryRoot {
    private final VirtualFile myFile;
    private final List<LibraryRootType> myTypes;

    public DetectedLibraryRoot(@NotNull VirtualFile file2, @NotNull OrderRootType rootType, boolean jarDirectory) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/libraries/ui/DetectedLibraryRoot", "<init>"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/libraries/ui/DetectedLibraryRoot", "<init>"));
        }
        this(file2, Collections.singletonList(new LibraryRootType(rootType, jarDirectory)));
    }

    public DetectedLibraryRoot(@NotNull VirtualFile file2, @NotNull List<LibraryRootType> types) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/libraries/ui/DetectedLibraryRoot", "<init>"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/openapi/roots/libraries/ui/DetectedLibraryRoot", "<init>"));
        }
        this.myFile = file2;
        this.myTypes = types;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/libraries/ui/DetectedLibraryRoot", "getFile"));
        }
        return virtualFile;
    }

    @NotNull
    public List<LibraryRootType> getTypes() {
        List<LibraryRootType> list = this.myTypes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/libraries/ui/DetectedLibraryRoot", "getTypes"));
        }
        return list;
    }
}

