/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.ex;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.FileTypesBundle;
import com.intellij.openapi.fileTypes.NativeFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.fileTypes.impl.FileTypeRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTypeChooser
extends DialogWrapper {
    private JList myList;
    private JLabel myTitleLabel;
    private ComboBox myPattern;
    private JPanel myPanel;
    private JRadioButton myOpenInIdea;
    private JRadioButton myOpenAsNative;
    private final String myFileName;

    private FileTypeChooser(@NotNull List<String> patterns, @NotNull String fileName) {
        if (patterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "com/intellij/openapi/fileTypes/ex/FileTypeChooser", "<init>"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/fileTypes/ex/FileTypeChooser", "<init>"));
        }
        super(true);
        this.myFileName = fileName;
        this.$$$setupUI$$$();
        this.myOpenInIdea.setText("Open matching files in " + ApplicationNamesInfo.getInstance().getFullProductName() + ":");
        FileType[] fileTypes = FileTypeManager.getInstance().getRegisteredFileTypes();
        Arrays.sort(fileTypes, new Comparator<FileType>(){

            @Override
            public int compare(FileType fileType1, FileType fileType2) {
                if (fileType1 == null) {
                    return 1;
                }
                if (fileType2 == null) {
                    return -1;
                }
                return fileType1.getDescription().compareToIgnoreCase(fileType2.getDescription());
            }
        });
        DefaultListModel<FileType> model = new DefaultListModel<FileType>();
        for (FileType type : fileTypes) {
            if (type.isReadOnly() || type == FileTypes.UNKNOWN || type instanceof NativeFileType) continue;
            model.addElement(type);
        }
        this.myList.setModel(model);
        this.myPattern.setModel((ComboBoxModel)new CollectionComboBoxModel(ContainerUtil.map(patterns, (Function)FunctionUtil.id()), (Object)patterns.get(0)));
        this.setTitle(FileTypesBundle.message("filetype.chooser.title", new Object[0]));
        this.init();
    }

    protected JComponent createCenterPanel() {
        this.myTitleLabel.setText(FileTypesBundle.message("filetype.chooser.prompt", this.myFileName));
        this.myList.setSelectionMode(0);
        this.myList.setCellRenderer(new FileTypeRenderer());
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                FileTypeChooser.this.doOKAction();
                return true;
            }
        }.installOn((Component)this.myList);
        this.myList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FileTypeChooser.this.updateButtonsState();
            }
        });
        ScrollingUtil.selectItem((JList)this.myList, (Object)FileTypes.PLAIN_TEXT);
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }

    private void updateButtonsState() {
        this.setOKActionEnabled(this.myList.getSelectedIndex() != -1 || this.myOpenAsNative.isSelected());
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.fileTypes.FileTypeChooser";
    }

    public FileType getSelectedType() {
        return this.myOpenAsNative.isSelected() ? NativeFileType.INSTANCE : (FileType)this.myList.getSelectedValue();
    }

    @Nullable
    public static FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file2, @Nullable Project project) {
        FileType type;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/ex/FileTypeChooser", "getKnownFileTypeOrAssociate"));
        }
        if (project != null && !(file2 instanceof FakeVirtualFile)) {
            ((PsiManagerEx)PsiManager.getInstance((Project)project)).getFileManager().findFile(file2);
        }
        if ((type = file2.getFileType()) == FileTypes.UNKNOWN) {
            type = FileTypeChooser.getKnownFileTypeOrAssociate(file2.getName());
        }
        return type;
    }

    @Nullable
    public static FileType getKnownFileTypeOrAssociate(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/fileTypes/ex/FileTypeChooser", "getKnownFileTypeOrAssociate"));
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        FileType type = fileTypeManager.getFileTypeByFileName(fileName);
        if (type == FileTypes.UNKNOWN) {
            type = FileTypeChooser.associateFileType(fileName);
        }
        return type;
    }

    @Nullable
    public static FileType associateFileType(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/fileTypes/ex/FileTypeChooser", "associateFileType"));
        }
        final FileTypeChooser chooser = new FileTypeChooser(FileTypeChooser.suggestPatterns(fileName), fileName);
        if (!chooser.showAndGet()) {
            return null;
        }
        final FileType type = chooser.getSelectedType();
        if (type == FileTypes.UNKNOWN || type == null) {
            return null;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                FileTypeManagerEx.getInstanceEx().associatePattern(type, (String)chooser.myPattern.getSelectedItem());
            }
        });
        return type;
    }

    @NotNull
    static List<String> suggestPatterns(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/fileTypes/ex/FileTypeChooser", "suggestPatterns"));
        }
        LinkedList patterns = ContainerUtil.newLinkedList((Object[])new String[]{fileName});
        int i = -1;
        while ((i = fileName.indexOf(46, i + 1)) > 0) {
            String extension = fileName.substring(i);
            if (StringUtil.isEmpty((String)extension)) continue;
            patterns.add(0, "*" + extension);
        }
        LinkedList linkedList = patterns;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/ex/FileTypeChooser", "suggestPatterns"));
        }
        return linkedList;
    }

    protected String getHelpId() {
        return "reference.dialogs.register.association";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        ComboBox comboBox;
        JLabel jLabel;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTitleLabel = jLabel = new JLabel();
        jLabel.setText("Cannot associate _template_");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/FileTypesBundle").getString("filetype.chooser.file.pattern"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPattern = comboBox = new ComboBox();
        comboBox.setEditable(true);
        jPanel.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(3, 0, 1, 2, 0, 3, 7, 7, null, new Dimension(150, 200), null, 2));
        JBList jBList = new JBList();
        this.myList = jBList;
        jBScrollPane.setViewportView((Component)jBList);
        this.myOpenInIdea = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Open matching files in PRODUCTNAME as type:");
        jRadioButton2.setSelected(true);
        jPanel.add((Component)jRadioButton2, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myOpenAsNative = jRadioButton = new JRadioButton();
        jRadioButton.setText("Open matching files in associated application");
        jPanel.add((Component)jRadioButton, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        jLabel2.setLabelFor((Component)comboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

