/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.vcs;

import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListenerAdapter;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExternalSystemVcsRegistrar {
    public static void handle(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/vcs/ExternalSystemVcsRegistrar", "handle"));
        }
        for (ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
            AbstractExternalSystemSettings settings = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)project);
            settings.subscribe((ExternalSystemSettingsListener)new ExternalSystemSettingsListenerAdapter(){

                public void onProjectsLinked(@NotNull Collection linked) {
                    VcsDirectoryMapping newMapping;
                    String detectedDirPath;
                    VirtualFile detectedDir;
                    if (linked == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linked", "com/intellij/openapi/externalSystem/service/vcs/ExternalSystemVcsRegistrar$1", "onProjectsLinked"));
                    }
                    ArrayList newMappings = ContainerUtilRt.newArrayList();
                    LocalFileSystem fileSystem = LocalFileSystem.getInstance();
                    ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
                    for (Object o : linked) {
                        ExternalProjectSettings settings = (ExternalProjectSettings)o;
                        VirtualFile dir = fileSystem.refreshAndFindFileByPath(settings.getExternalProjectPath());
                        if (dir == null) continue;
                        if (!dir.isDirectory()) {
                            dir = dir.getParent();
                        }
                        newMappings.addAll(VcsUtil.findRoots((VirtualFile)dir, (Project)project));
                    }
                    List oldMappings = vcsManager.getDirectoryMappings();
                    if (oldMappings.size() == 1 && newMappings.size() == 1 && StringUtil.isEmpty((String)((VcsDirectoryMapping)oldMappings.get(0)).getVcs()) && (detectedDir = fileSystem.findFileByPath(detectedDirPath = (newMapping = (VcsDirectoryMapping)newMappings.iterator().next()).getDirectory())) != null && detectedDir.equals(project.getBaseDir())) {
                        newMappings.clear();
                        newMappings.add(new VcsDirectoryMapping("", newMapping.getVcs()));
                        vcsManager.setDirectoryMappings((List)newMappings);
                        return;
                    }
                    newMappings.addAll(oldMappings);
                    vcsManager.setDirectoryMappings((List)newMappings);
                }
            });
        }
    }
}

