/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import icons.ExternalSystemIcons;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultExternalSystemUiAware
implements ExternalSystemUiAware {
    @NotNull
    public static final DefaultExternalSystemUiAware INSTANCE = new DefaultExternalSystemUiAware();

    @NotNull
    public String getProjectRepresentationName(@NotNull String targetProjectPath, @Nullable String rootProjectPath) {
        if (targetProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetProjectPath", "com/intellij/openapi/externalSystem/service/ui/DefaultExternalSystemUiAware", "getProjectRepresentationName"));
        }
        String string = new File(targetProjectPath).getParentFile().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/ui/DefaultExternalSystemUiAware", "getProjectRepresentationName"));
        }
        return string;
    }

    @Nullable
    public FileChooserDescriptor getExternalProjectConfigDescriptor() {
        return null;
    }

    @NotNull
    public Icon getProjectIcon() {
        Icon icon = AllIcons.Nodes.IdeaProject;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/ui/DefaultExternalSystemUiAware", "getProjectIcon"));
        }
        return icon;
    }

    @NotNull
    public Icon getTaskIcon() {
        Icon icon = ExternalSystemIcons.Task;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/ui/DefaultExternalSystemUiAware", "getTaskIcon"));
        }
        return icon;
    }
}

