/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.importing;

import com.intellij.openapi.externalSystem.importing.ImportSpec;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportSpecBuilder {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private ProgressExecutionMode myProgressExecutionMode;
    private boolean myForceWhenUptodate;
    private boolean myWhenAutoImportEnabled;
    @Nullable
    private ExternalProjectRefreshCallback myCallback;

    public ImportSpecBuilder(@NotNull Project project, @NotNull ProjectSystemId id) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/importing/ImportSpecBuilder", "<init>"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/importing/ImportSpecBuilder", "<init>"));
        }
        this.myProject = project;
        this.myExternalSystemId = id;
        this.myProgressExecutionMode = ProgressExecutionMode.IN_BACKGROUND_ASYNC;
    }

    public ImportSpecBuilder whenAutoImportEnabled() {
        this.myWhenAutoImportEnabled = true;
        return this;
    }

    public ImportSpecBuilder use(@NotNull ProgressExecutionMode executionMode) {
        if (executionMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionMode", "com/intellij/openapi/externalSystem/importing/ImportSpecBuilder", "use"));
        }
        this.myProgressExecutionMode = executionMode;
        return this;
    }

    public ImportSpecBuilder forceWhenUptodate() {
        return this.forceWhenUptodate(true);
    }

    public ImportSpecBuilder forceWhenUptodate(boolean force) {
        this.myForceWhenUptodate = force;
        return this;
    }

    public ImportSpecBuilder callback(@Nullable ExternalProjectRefreshCallback callback) {
        this.myCallback = callback;
        return this;
    }

    public ImportSpec build() {
        ImportSpec mySpec = new ImportSpec(this.myProject, this.myExternalSystemId);
        mySpec.setWhenAutoImportEnabled(this.myWhenAutoImportEnabled);
        mySpec.setProgressExecutionMode(this.myProgressExecutionMode);
        mySpec.setForceWhenUptodate(this.myForceWhenUptodate);
        mySpec.setCallback(this.myCallback);
        return mySpec;
    }
}

