/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.IndentGuideDescriptor;
import com.intellij.openapi.editor.IndentsModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class IndentsModelImpl
implements IndentsModel {
    private final Map<IntPair, IndentGuideDescriptor> myIndentsByLines;
    private List<IndentGuideDescriptor> myIndents;
    @NotNull
    private final EditorImpl myEditor;

    public IndentsModelImpl(@NotNull EditorImpl editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/IndentsModelImpl", "<init>"));
        }
        this.myIndentsByLines = ContainerUtilRt.newHashMap();
        this.myIndents = ContainerUtilRt.newArrayList();
        this.myEditor = editor;
    }

    @NotNull
    public List<IndentGuideDescriptor> getIndents() {
        List<IndentGuideDescriptor> list = this.myIndents;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/IndentsModelImpl", "getIndents"));
        }
        return list;
    }

    public IndentGuideDescriptor getCaretIndentGuide() {
        LogicalPosition pos = this.myEditor.getCaretModel().getLogicalPosition();
        int column = pos.column;
        int line = pos.line;
        if (column > 0) {
            for (IndentGuideDescriptor indent : this.myIndents) {
                if (column != indent.indentLevel || line < indent.startLine || line >= indent.endLine) continue;
                return indent;
            }
        }
        return null;
    }

    public IndentGuideDescriptor getDescriptor(int startLine, int endLine) {
        return this.myIndentsByLines.get(new IntPair(startLine, endLine));
    }

    public void assumeIndents(@NotNull List<IndentGuideDescriptor> descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/openapi/editor/impl/IndentsModelImpl", "assumeIndents"));
        }
        this.myIndents = descriptors;
        this.myIndentsByLines.clear();
        for (IndentGuideDescriptor descriptor : this.myIndents) {
            this.myIndentsByLines.put(new IntPair(descriptor.startLine, descriptor.endLine), descriptor);
        }
    }

    private static class IntPair {
        private final int start;
        private final int end;

        IntPair(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int hashCode() {
            int result2 = this.start;
            return 31 * result2 + this.end;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IntPair that = (IntPair)o;
            return this.start == that.start && this.end == that.end;
        }

        public String toString() {
            return "start=" + this.start + ", end=" + this.end;
        }
    }
}

