/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.DefaultStateSerializer;
import com.intellij.openapi.components.impl.stores.StateStorageBaseKt;
import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"?\u0015\tA\"A\u0003\u0001\u000b\u0005A\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011\u0017)\u0001!B\u0001\r\u0003\u0015\tAaA\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0011\u0005)\u0011\u0001\"\u0002\u0006\u0003!9Q!\u0001C\u0007\tMa\u0001!\u0006\u0003\u0005\u0001!\u0005Q#\u0001\r\u00023\u0005A\u001a!)\u0002R\u0007\u0005A!!\n\u0003\u0005\u0005!-Q\"\u0001\r\u0004Kw!1\u0002\u0003\u0004\u000e\u00051\u0005AUB\t\u0005\t\u0003Ai!F\u0001\u0019\u0003e!\u0001bB\u0007\u0003\u0019\u0003Az!\u0007\u0004\t\u00115!\u0011BA\u0005\u0002I\u001bA\n\"\u0007\u0003\t\u00135\u0011A\u0012\u0001S\u0007#\u000e\t\u00012C\u0013\u0004\u0011)i\u0011\u0001'\u0006&\u0007!YQ\"\u0001M\u000bKg!1\u0003c\u0006\u000e\u00051\u0005\u0001tB\r\u0004\u00111i\u0011\u0001\b\u0001\u001a\t!eQB\u0001G\u00011\u0005I2\u0001C\u0007\u000e\u0003am\u0011\u0004\u0002\u0003\u0002\u00119i\u0011\u0001G\u0002R\u0007\u0005Ai\"*\u0013\t\u001f5\u0011A\u0012\u0001S\u0007#\u0011!\t\u0001#\u0004\u0016\u0003a\t\u0011\u0004\u0002E\r\u001b\ta\t\u0001G\u0001\u001a\u0007!iQ\"\u0001M\u000e3\u0019A\u0001\"\u0004\u0003\n\u0005%\tAU\u0002M\t3\u0011A\u0011\"\u0004\u0002\r\u0002\u00116\u0011d\u0001E\u0010\u001b\u0005A2!U\u0002\u0002\u0011A);\u0006C\b\u000e\u00051\u0005AUB\t\u0005\t\u0003Ai!F\u0001\u0019\u0003e!\u0001\u0012D\u0007\u0003\u0019\u0003A\u0012!G\u0002\t\u001b5\t\u00014D\r\u0007\u0011!iA!\u0003\u0002\n\u0003\u00116\u0001\u0014C\r\u0005\t\u0005Aa\"D\u0001\u0019\u0007e!A!\u0001E\u0010\u001b\u0005A2!G\u0003\u0005\u0003!IQB\u0001G\u0001I\u001b\t6!\u0001E\u0011K/!!\u0001C\t\u000e\u0003q\u0001\u0011\u0004\u0002\u0003\u0002\u0011?i\u0011\u0001G\u0002R\u0007\u0005A\u0019#*\b\u0005%!\u0011R\"\u0001\r\u00043\rAA\"D\u0001\u001d\u0001e\u0019\u0001\"D\u0007\u000217\t6!\u0001E\u0013K-A!#D\u0001\u0019\u0007e\u0019\u0001\"D\u0007\u000217I2\u0001C\n\u000e\u0003a\u0019QU\u0002\u0003\u0013\u0011Oi\u0011\u0001\b\u0001R\u0007\u0005AA#K\u0004\u0005\u0003rA)!D\u0001\u0019\u0007E\u001b\u0011!\u0002\u0001*\u001b\u0011\u0011\u0005\u0002c\u0002\u000e\t%\u0011\u0011\"\u0001\u000f\u00011\u0011\t6\u0001B\u0003\u0001\u001b\t!I\u0001C\u0003"}, strings={"Lcom/intellij/openapi/components/impl/stores/StateStorageBase;", "T", "", "Lcom/intellij/openapi/components/StateStorage;", "()V", "mySavingDisabled", "", "storageDataRef", "Ljava/util/concurrent/atomic/AtomicReference;", "getStorageDataRef", "()Ljava/util/concurrent/atomic/AtomicReference;", "checkIsSavingDisabled", "deserializeState", "S", "serializedState", "Lorg/jdom/Element;", "stateClass", "Ljava/lang/Class;", "mergeInto", "(Lorg/jdom/Element;Ljava/lang/Class;Ljava/lang/Object;)Ljava/lang/Object;", "disableSaving", "", "enableSaving", "getSerializedState", "storageData", "component", "componentName", "", "archive", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Z)Lorg/jdom/Element;", "getState", "reload", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Class;Ljava/lang/Object;Z)Ljava/lang/Object;", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Class;ZZLjava/lang/Object;)Ljava/lang/Object;", "getStorageData", "(Z)Ljava/lang/Object;", "hasState", "(Ljava/lang/Object;Ljava/lang/String;)Z", "reloadData", "loadData", "()Ljava/lang/Object;"}, moduleName="platform-impl")
public abstract class StateStorageBase<T>
implements StateStorage {
    private boolean mySavingDisabled;
    @NotNull
    private final AtomicReference<T> storageDataRef = new AtomicReference();

    @NotNull
    protected final AtomicReference<T> getStorageDataRef() {
        return this.storageDataRef;
    }

    @Nullable
    public final <S> S getState(@Nullable Object component, @NotNull String componentName, @NotNull Class<S> stateClass, @Nullable S mergeInto, boolean reload) {
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        Intrinsics.checkParameterIsNotNull(stateClass, (String)"stateClass");
        return this.getState(component, componentName, stateClass, true, reload, mergeInto);
    }

    @Nullable
    public final <S> S getState(@Nullable Object component, @NotNull String componentName, @NotNull Class<S> stateClass, boolean archive, boolean reload, @Nullable S mergeInto) {
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        Intrinsics.checkParameterIsNotNull(stateClass, (String)"stateClass");
        return this.deserializeState(this.getSerializedState(this.getStorageData(reload), component, componentName, archive), stateClass, mergeInto);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ Object getState$default(StateStorageBase stateStorageBase, Object object, String string, Class clazz, boolean bl, boolean bl2, Object object2, int n) {
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x20) != 0) {
            object2 = null;
        }
        return stateStorageBase.getState(object, string, clazz, bl, bl2, object2);
    }

    @Nullable
    public <S> S deserializeState(@Nullable Element serializedState, @NotNull Class<S> stateClass, @Nullable S mergeInto) {
        Intrinsics.checkParameterIsNotNull(stateClass, (String)"stateClass");
        return DefaultStateSerializer.deserializeState(serializedState, stateClass, mergeInto);
    }

    @Nullable
    public abstract Element getSerializedState(@NotNull T var1, @Nullable Object var2, @NotNull String var3, boolean var4);

    @Nullable
    public static /* bridge */ /* synthetic */ Element getSerializedState$default(StateStorageBase stateStorageBase, Object object, Object object2, String string, boolean bl, int n) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return stateStorageBase.getSerializedState(object, object2, string, bl);
    }

    protected abstract boolean hasState(@NotNull T var1, @NotNull String var2);

    public final boolean hasState(@NotNull String componentName, boolean reloadData) {
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        return this.hasState(this.getStorageData(reloadData), componentName);
    }

    @NotNull
    protected final T getStorageData(boolean reload) {
        T storageData = this.storageDataRef.get();
        if (storageData != null && !reload) {
            return storageData;
        }
        T newStorageData = this.loadData();
        if (this.storageDataRef.compareAndSet(storageData, newStorageData)) {
            return newStorageData;
        }
        return this.getStorageData(false);
    }

    @NotNull
    protected static /* bridge */ /* synthetic */ Object getStorageData$default(StateStorageBase stateStorageBase, boolean bl, int n) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return stateStorageBase.getStorageData(bl);
    }

    @NotNull
    protected abstract T loadData();

    public final void disableSaving() {
        Logger $receiver$iv = StateStorageBaseKt.access$getLOG$p();
        if ($receiver$iv.isDebugEnabled()) {
            Logger logger = $receiver$iv;
            String string = "Disabled saving for " + this.toString();
            logger.debug(string);
        }
        this.mySavingDisabled = true;
    }

    public final void enableSaving() {
        Logger $receiver$iv = StateStorageBaseKt.access$getLOG$p();
        if ($receiver$iv.isDebugEnabled()) {
            Logger logger = $receiver$iv;
            String string = "Enabled saving " + this.toString();
            logger.debug(string);
        }
        this.mySavingDisabled = false;
    }

    protected final boolean checkIsSavingDisabled() {
        Logger $receiver$iv = StateStorageBaseKt.access$getLOG$p();
        if ($receiver$iv.isDebugEnabled()) {
            Logger logger = $receiver$iv;
            String string = "Saving disabled for " + this.toString();
            logger.debug(string);
        }
        return this.mySavingDisabled;
    }
}

