/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.ui;

import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.ui.StripeTable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SystemNotifications;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class NotificationsConfigurablePanel
extends JPanel
implements Disposable {
    private static final String REMOVE_KEY = "REMOVE";
    private NotificationsTable myTable;
    private final JCheckBox myDisplayBalloons;
    private final JCheckBox mySystemNotifications;

    public NotificationsConfigurablePanel() {
        this.setLayout(new BorderLayout(5, 5));
        this.myTable = new NotificationsTable();
        this.myDisplayBalloons = new JCheckBox("Display balloon notifications");
        this.myDisplayBalloons.setMnemonic('b');
        this.myDisplayBalloons.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotificationsConfigurablePanel.this.myTable.repaint();
            }
        });
        this.mySystemNotifications = new JCheckBox("Enable system notifications");
        this.mySystemNotifications.setMnemonic('s');
        this.mySystemNotifications.setVisible(SystemNotifications.getInstance().isAvailable());
        JPanel boxes = new JPanel();
        boxes.setLayout(new BoxLayout(boxes, 1));
        boxes.add(this.myDisplayBalloons);
        boxes.add(this.mySystemNotifications);
        this.add((Component)boxes, "North");
        this.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myTable)), "Center");
        this.myTable.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), REMOVE_KEY);
        this.myTable.getActionMap().put(REMOVE_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotificationsConfigurablePanel.this.removeSelected();
            }
        });
    }

    private void removeSelected() {
        this.myTable.removeSelected();
    }

    public void dispose() {
        this.myTable = null;
    }

    public boolean isModified() {
        List<SettingsWrapper> list = this.myTable.getAllSettings();
        for (SettingsWrapper settingsWrapper : list) {
            if (!settingsWrapper.hasChanged()) continue;
            return true;
        }
        NotificationsConfigurationImpl configuration = NotificationsConfigurationImpl.getInstanceImpl();
        return configuration.SHOW_BALLOONS != this.myDisplayBalloons.isSelected() || configuration.SYSTEM_NOTIFICATIONS != this.mySystemNotifications.isSelected();
    }

    public void apply() {
        List<SettingsWrapper> list = this.myTable.getAllSettings();
        for (SettingsWrapper settingsWrapper : list) {
            settingsWrapper.apply();
        }
        NotificationsConfigurationImpl configuration = NotificationsConfigurationImpl.getInstanceImpl();
        configuration.SHOW_BALLOONS = this.myDisplayBalloons.isSelected();
        configuration.SYSTEM_NOTIFICATIONS = this.mySystemNotifications.isSelected();
    }

    public void reset() {
        List<SettingsWrapper> list = this.myTable.getAllSettings();
        for (SettingsWrapper settingsWrapper : list) {
            settingsWrapper.reset();
        }
        NotificationsConfigurationImpl configuration = NotificationsConfigurationImpl.getInstanceImpl();
        this.myDisplayBalloons.setSelected(configuration.SHOW_BALLOONS);
        this.mySystemNotifications.setSelected(configuration.SYSTEM_NOTIFICATIONS);
        this.myTable.invalidate();
        this.myTable.repaint();
    }

    public void selectGroup(String searchQuery) {
        ((SpeedSearchSupply)ObjectUtils.assertNotNull((Object)SpeedSearchSupply.getSupply((JComponent)((Object)this.myTable), (boolean)true))).findAndSelectElement(searchQuery);
    }

    private static class NotificationsTableModel
    extends AbstractTableModel {
        private final List<SettingsWrapper> mySettings;

        public NotificationsTableModel() {
            ArrayList<SettingsWrapper> list = new ArrayList<SettingsWrapper>();
            for (NotificationSettings setting : NotificationsConfigurationImpl.getInstanceImpl().getAllSettings()) {
                list.add(new SettingsWrapper(setting));
            }
            this.mySettings = list;
        }

        public List<SettingsWrapper> getSettings() {
            return this.getActiveSettings();
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            SettingsWrapper wrapper = this.getSettings(rowIndex);
            switch (columnIndex) {
                case 1: {
                    wrapper.myVersion = wrapper.myVersion.withDisplayType((NotificationDisplayType)value);
                    break;
                }
                case 2: {
                    wrapper.myVersion = wrapper.myVersion.withShouldLog((Boolean)value);
                    break;
                }
                case 3: {
                    wrapper.myVersion = wrapper.myVersion.withShouldReadAloud((Boolean)value);
                }
            }
        }

        @Override
        public int getRowCount() {
            return this.getSettings().size();
        }

        public SettingsWrapper getSettings(int row) {
            return this.getSettings().get(row);
        }

        @Override
        public int getColumnCount() {
            return SystemInfo.isMac ? 4 : 3;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (1 == columnIndex) {
                return NotificationDisplayType.class;
            }
            if (2 == columnIndex) {
                return Boolean.class;
            }
            if (3 == columnIndex) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Group";
                }
                case 2: {
                    return "Log";
                }
                case 3: {
                    return "Read aloud";
                }
            }
            return "Popup";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex > 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.getSettings().get(rowIndex).getGroupId();
                }
                case 2: {
                    return this.getSettings().get(rowIndex).myVersion.isShouldLog();
                }
                case 3: {
                    return this.getSettings().get(rowIndex).myVersion.isShouldReadAloud();
                }
            }
            return this.getSettings().get(rowIndex).myVersion.getDisplayType();
        }

        public static void remove(List<SettingsWrapper> toRemove) {
            for (SettingsWrapper settingsWrapper : toRemove) {
                settingsWrapper.remove();
            }
        }

        public List<SettingsWrapper> getAllSettings() {
            return this.mySettings;
        }

        private List<SettingsWrapper> getActiveSettings() {
            ArrayList<SettingsWrapper> result2 = new ArrayList<SettingsWrapper>(this.mySettings);
            Iterator iterator = result2.iterator();
            while (iterator.hasNext()) {
                SettingsWrapper wrapper = (SettingsWrapper)iterator.next();
                if (!wrapper.isRemoved()) continue;
                iterator.remove();
            }
            return result2;
        }
    }

    private static class SettingsWrapper {
        private boolean myRemoved = false;
        private NotificationSettings myVersion;

        private SettingsWrapper(NotificationSettings settings) {
            this.myVersion = settings;
        }

        public boolean hasChanged() {
            return this.myRemoved || !this.getOriginalSettings().equals(this.myVersion);
        }

        public void remove() {
            this.myRemoved = true;
        }

        public boolean isRemoved() {
            return this.myRemoved;
        }

        @NotNull
        private NotificationSettings getOriginalSettings() {
            NotificationSettings notificationSettings = NotificationsConfigurationImpl.getSettings(this.getGroupId());
            if (notificationSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/ui/NotificationsConfigurablePanel$SettingsWrapper", "getOriginalSettings"));
            }
            return notificationSettings;
        }

        public void apply() {
            if (this.myRemoved) {
                NotificationsConfigurationImpl.remove(this.getGroupId());
            } else {
                NotificationsConfigurationImpl.getInstanceImpl().changeSettings(this.myVersion);
            }
        }

        public void reset() {
            this.myVersion = this.getOriginalSettings();
            this.myRemoved = false;
        }

        String getGroupId() {
            return this.myVersion.getGroupId();
        }
    }

    private class NotificationsTable
    extends StripeTable {
        private static final int ID_COLUMN = 0;
        private static final int DISPLAY_TYPE_COLUMN = 1;
        private static final int LOG_COLUMN = 2;
        private static final int READ_ALOUD_COLUMN = 3;

        public NotificationsTable() {
            super((TableModel)new NotificationsTableModel());
            this.setSelectionMode(0);
            TableColumn idColumn = this.getColumnModel().getColumn(0);
            idColumn.setPreferredWidth(200);
            idColumn.setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                @NotNull
                public Component getTableCellRendererComponent(@NotNull JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    if (table == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/notification/impl/ui/NotificationsConfigurablePanel$NotificationsTable$1", "getTableCellRendererComponent"));
                    }
                    Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (component instanceof JComponent) {
                        ((JComponent)component).setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)4, (int)0, (int)4));
                    }
                    Component component2 = component;
                    if (component2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/ui/NotificationsConfigurablePanel$NotificationsTable$1", "getTableCellRendererComponent"));
                    }
                    return component2;
                }
            });
            TableColumn displayTypeColumn = this.getColumnModel().getColumn(1);
            displayTypeColumn.setMaxWidth(300);
            displayTypeColumn.setPreferredWidth(250);
            displayTypeColumn.setCellRenderer((TableCellRenderer)new ComboBoxTableRenderer<NotificationDisplayType>(NotificationDisplayType.values()){

                protected void customizeComponent(NotificationDisplayType value, JTable table, boolean isSelected) {
                    super.customizeComponent((Object)(NotificationsConfigurablePanel.this.myDisplayBalloons.isSelected() ? value : NotificationDisplayType.NONE), table, isSelected);
                    if (!NotificationsConfigurablePanel.this.myDisplayBalloons.isSelected() && !isSelected) {
                        this.setBackground(UIUtil.getComboBoxDisabledBackground());
                        this.setForeground(UIUtil.getComboBoxDisabledForeground());
                    }
                }

                protected String getTextFor(@NotNull NotificationDisplayType value) {
                    if (value == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/notification/impl/ui/NotificationsConfigurablePanel$NotificationsTable$2", "getTextFor"));
                    }
                    return value.getTitle();
                }
            });
            displayTypeColumn.setCellEditor((TableCellEditor)new ComboBoxTableRenderer<NotificationDisplayType>(NotificationDisplayType.values()){

                public boolean isCellEditable(EventObject event) {
                    if (!NotificationsConfigurablePanel.this.myDisplayBalloons.isSelected()) {
                        return false;
                    }
                    if (event instanceof MouseEvent) {
                        return ((MouseEvent)event).getClickCount() >= 1;
                    }
                    return false;
                }

                protected boolean isApplicable(NotificationDisplayType value, int row) {
                    if (value != NotificationDisplayType.TOOL_WINDOW) {
                        return true;
                    }
                    String groupId = ((NotificationsTableModel)NotificationsTable.this.getModel()).getSettings(row).getGroupId();
                    return NotificationsConfigurationImpl.getInstanceImpl().hasToolWindowCapability(groupId);
                }

                protected String getTextFor(@NotNull NotificationDisplayType value) {
                    if (value == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/notification/impl/ui/NotificationsConfigurablePanel$NotificationsTable$3", "getTextFor"));
                    }
                    return value.getTitle();
                }
            });
            TableColumn logColumn = this.getColumnModel().getColumn(2);
            logColumn.setMaxWidth(logColumn.getPreferredWidth());
            if (SystemInfo.isMac) {
                TableColumn readAloudColumn = this.getColumnModel().getColumn(3);
                readAloudColumn.setMaxWidth(readAloudColumn.getPreferredWidth());
            }
            new TableSpeedSearch((JTable)((Object)this));
            this.getEmptyText().setText("No notifications configured");
        }

        public Dimension getMinimumSize() {
            return this.calcSize(super.getMinimumSize());
        }

        public Dimension getPreferredSize() {
            return this.calcSize(super.getPreferredSize());
        }

        private Dimension calcSize(@NotNull Dimension s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/notification/impl/ui/NotificationsConfigurablePanel$NotificationsTable", "calcSize"));
            }
            Container container = this.getParent();
            if (container != null) {
                Dimension size = container.getSize();
                return new Dimension(size.width, s.height);
            }
            return s;
        }

        public List<SettingsWrapper> getSettings() {
            return ((NotificationsTableModel)this.getModel()).getSettings();
        }

        public void removeSelected() {
            ListSelectionModel selectionModel = this.getSelectionModel();
            if (!selectionModel.isSelectionEmpty()) {
                int min = selectionModel.getMinSelectionIndex();
                int max = selectionModel.getMaxSelectionIndex();
                List<SettingsWrapper> settings = this.getSettings();
                ArrayList<SettingsWrapper> toRemove = new ArrayList<SettingsWrapper>();
                for (int i = min; i <= max && i < settings.size(); ++i) {
                    toRemove.add(settings.get(i));
                }
                if (toRemove.size() > 0) {
                    NotificationsTableModel cfr_ignored_0 = (NotificationsTableModel)this.getModel();
                    NotificationsTableModel.remove(toRemove);
                    this.revalidate();
                    this.repaint();
                }
            }
        }

        public List<SettingsWrapper> getAllSettings() {
            return ((NotificationsTableModel)this.getModel()).getAllSettings();
        }
    }
}

