/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.customization;

import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomisedActionGroup
extends ActionGroup {
    private boolean myForceUpdate;
    private final ActionGroup myGroup;
    private AnAction[] myChildren;
    private final CustomActionsSchema mySchema;
    private final String myDefaultGroupName;
    private final String myRootGroupName;

    public CustomisedActionGroup(String shortName, boolean popup, ActionGroup group, CustomActionsSchema schema, String defaultGroupName, String name) {
        super(shortName, popup);
        this.myGroup = group;
        this.mySchema = schema;
        this.myDefaultGroupName = defaultGroupName;
        this.myRootGroupName = name;
        this.myForceUpdate = true;
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (this.myForceUpdate) {
            this.myChildren = CustomizationUtil.getReordableChildren(this.myGroup, this.mySchema, this.myDefaultGroupName, this.myRootGroupName, e);
            this.myForceUpdate = false;
            if (this.myChildren == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/customization/CustomisedActionGroup", "getChildren"));
            }
            return this.myChildren;
        }
        if (!(this.myGroup instanceof DefaultActionGroup) || this.myChildren == null) {
            this.myChildren = CustomizationUtil.getReordableChildren(this.myGroup, this.mySchema, this.myDefaultGroupName, this.myRootGroupName, e);
        }
        if (this.myChildren == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/customization/CustomisedActionGroup", "getChildren"));
        }
        return this.myChildren;
    }

    public void update(AnActionEvent e) {
        this.myGroup.update(e);
    }

    public boolean isDumbAware() {
        return this.myGroup.isDumbAware();
    }

    public boolean canBePerformed(DataContext context) {
        return this.myGroup.canBePerformed(context);
    }

    public void actionPerformed(AnActionEvent e) {
        this.myGroup.actionPerformed(e);
    }

    @Nullable
    public AnAction getFirstAction() {
        AnAction[] children2 = this.getChildren(null);
        return children2.length > 0 ? children2[0] : null;
    }
}

