/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.nodes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.todo.CurrentFileTodosTreeBuilder;
import com.intellij.ide.todo.ToDoSummary;
import com.intellij.ide.todo.TodoFileDirAndModuleComparator;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.nodes.BaseToDoNode;
import com.intellij.ide.todo.nodes.ModuleToDoNode;
import com.intellij.ide.todo.nodes.TodoFileNode;
import com.intellij.ide.todo.nodes.TodoTreeHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class SummaryNode
extends BaseToDoNode<ToDoSummary> {
    public SummaryNode(Project project, ToDoSummary value, TodoTreeBuilder builder) {
        super(project, value, builder);
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        ArrayList<AbstractTreeNode> children2 = new ArrayList<AbstractTreeNode>();
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex();
        if (this.myToDoSettings.isModulesShown()) {
            Iterator<PsiFile> i = this.myBuilder.getAllFiles();
            while (i.hasNext()) {
                ModuleToDoNode moduleToDoNode;
                VirtualFile virtualFile;
                Module module;
                PsiFile psiFile = i.next();
                if (psiFile == null || (module = projectFileIndex.getModuleForFile(virtualFile = psiFile.getVirtualFile())) == null || children2.contains(moduleToDoNode = new ModuleToDoNode(this.getProject(), module, this.myBuilder))) continue;
                children2.add(moduleToDoNode);
            }
        } else if (this.myToDoSettings.getIsPackagesShown()) {
            if (this.myBuilder instanceof CurrentFileTodosTreeBuilder) {
                Iterator<PsiFile> allFiles = this.myBuilder.getAllFiles();
                if (allFiles.hasNext()) {
                    children2.add((AbstractTreeNode)new TodoFileNode(this.myProject, allFiles.next(), this.myBuilder, false));
                }
            } else {
                TodoTreeHelper.getInstance(this.getProject()).addPackagesToChildren(children2, null, this.myBuilder);
            }
        } else {
            Iterator<PsiFile> i = this.myBuilder.getAllFiles();
            while (i.hasNext()) {
                PsiFile psiFile = i.next();
                if (psiFile == null) continue;
                TodoFileNode fileNode = new TodoFileNode(this.getProject(), psiFile, this.myBuilder, false);
                if (!this.getTreeStructure().accept(psiFile) || children2.contains(fileNode)) continue;
                children2.add((AbstractTreeNode)fileNode);
            }
        }
        Collections.sort(children2, TodoFileDirAndModuleComparator.INSTANCE);
        ArrayList<AbstractTreeNode> arrayList = children2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/todo/nodes/SummaryNode", "getChildren"));
        }
        return arrayList;
    }

    public void update(PresentationData presentation) {
        int todoItemCount = this.getTodoItemCount((ToDoSummary)this.getValue());
        int fileCount = this.getFileCount((ToDoSummary)this.getValue());
        presentation.setPresentableText(IdeBundle.message((String)"node.todo.summary", (Object[])new Object[]{todoItemCount, fileCount}));
    }

    public String getTestPresentation() {
        return "Summary";
    }

    @Override
    public int getFileCount(ToDoSummary summary) {
        int count = 0;
        Iterator<PsiFile> i = this.myBuilder.getAllFiles();
        while (i.hasNext()) {
            PsiFile psiFile = i.next();
            if (psiFile == null || !this.getTreeStructure().accept(psiFile)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getTodoItemCount(ToDoSummary val) {
        int count = 0;
        final Iterator<PsiFile> i = this.myBuilder.getAllFiles();
        while (i.hasNext()) {
            count += ((Integer)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Integer>(){

                public Integer compute() {
                    return SummaryNode.this.getTreeStructure().getTodoItemCount((PsiFile)i.next());
                }
            })).intValue();
        }
        return count;
    }

    public int getWeight() {
        return 0;
    }
}

