/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MarkRootActionBase
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e) {
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        final Module module = MarkRootActionBase.getModule(e, files);
        if (module == null) {
            return;
        }
        final ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        for (VirtualFile file2 : files) {
            SourceFolder[] sourceFolders;
            ContentEntry entry = MarkRootActionBase.findContentEntry((ModuleRootModel)model, file2);
            if (entry == null) continue;
            for (SourceFolder sourceFolder : sourceFolders = entry.getSourceFolders()) {
                if (!Comparing.equal((Object)sourceFolder.getFile(), (Object)file2)) continue;
                entry.removeSourceFolder(sourceFolder);
                break;
            }
            this.modifyRoots(file2, entry);
        }
        DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_BACKGROUND, (Runnable)new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        model.commit();
                        module.getProject().save();
                    }
                });
            }
        });
    }

    protected abstract void modifyRoots(VirtualFile var1, ContentEntry var2);

    @Nullable
    public static ContentEntry findContentEntry(@NotNull ModuleRootModel model, @NotNull VirtualFile vFile) {
        ContentEntry[] contentEntries;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ide/projectView/actions/MarkRootActionBase", "findContentEntry"));
        }
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/ide/projectView/actions/MarkRootActionBase", "findContentEntry"));
        }
        for (ContentEntry contentEntry : contentEntries = model.getContentEntries()) {
            VirtualFile contentEntryFile = contentEntry.getFile();
            if (contentEntryFile == null || !VfsUtilCore.isAncestor((VirtualFile)contentEntryFile, (VirtualFile)vFile, (boolean)false)) continue;
            return contentEntry;
        }
        return null;
    }

    public void update(AnActionEvent e) {
        RootsSelection selection = MarkRootActionBase.getSelection(e);
        this.doUpdate(e, (Module)e.getData(LangDataKeys.MODULE), selection);
    }

    protected void doUpdate(@NotNull AnActionEvent e, @Nullable Module module, @NotNull RootsSelection selection) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/projectView/actions/MarkRootActionBase", "doUpdate"));
        }
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/intellij/ide/projectView/actions/MarkRootActionBase", "doUpdate"));
        }
        boolean enabled = module != null && (!selection.mySelectedRoots.isEmpty() || !selection.mySelectedDirectories.isEmpty()) && selection.mySelectedExcludeRoots.isEmpty() && this.isEnabled(selection, module);
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    protected abstract boolean isEnabled(@NotNull RootsSelection var1, @NotNull Module var2);

    protected static RootsSelection getSelection(AnActionEvent e) {
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        Module module = MarkRootActionBase.getModule(e, files);
        if (module == null) {
            return RootsSelection.EMPTY;
        }
        RootsSelection selection = new RootsSelection();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex();
        for (VirtualFile file2 : files) {
            SourceFolder folder;
            if (!file2.isDirectory()) {
                return RootsSelection.EMPTY;
            }
            if (!fileIndex.isInContent(file2)) {
                ExcludeFolder excludeFolder = ProjectRootsUtil.findExcludeFolder(module, file2);
                if (excludeFolder != null) {
                    selection.mySelectedExcludeRoots.add(excludeFolder);
                    continue;
                }
                return RootsSelection.EMPTY;
            }
            if (Comparing.equal((Object)fileIndex.getSourceRootForFile(file2), (Object)file2) && (folder = ProjectRootsUtil.findSourceFolder(module, file2)) != null) {
                selection.mySelectedRoots.add(folder);
                continue;
            }
            selection.mySelectedDirectories.add(file2);
            if (!fileIndex.isInSourceContent(file2)) continue;
            selection.myHaveSelectedFilesUnderSourceRoots = true;
        }
        return selection;
    }

    @Nullable
    private static Module getModule(@NotNull AnActionEvent e, @Nullable VirtualFile[] files) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/projectView/actions/MarkRootActionBase", "getModule"));
        }
        if (files == null) {
            return null;
        }
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        if (module == null) {
            module = MarkRootActionBase.findParentModule(e.getProject(), files);
        }
        return module;
    }

    @Nullable
    private static Module findParentModule(@Nullable Project project, @NotNull VirtualFile[] files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/ide/projectView/actions/MarkRootActionBase", "findParentModule"));
        }
        if (project == null) {
            return null;
        }
        Module result2 = null;
        DirectoryIndex index = DirectoryIndex.getInstance(project);
        for (VirtualFile file2 : files) {
            Module module = index.getInfoForFile(file2).getModule();
            if (module == null) {
                return null;
            }
            if (result2 == null) {
                result2 = module;
                continue;
            }
            if (result2.equals(module)) continue;
            return null;
        }
        return result2;
    }

    protected static class RootsSelection {
        public static final RootsSelection EMPTY = new RootsSelection();
        public List<SourceFolder> mySelectedRoots = new ArrayList<SourceFolder>();
        public List<ExcludeFolder> mySelectedExcludeRoots = new ArrayList<ExcludeFolder>();
        public List<VirtualFile> mySelectedDirectories = new ArrayList<VirtualFile>();
        public boolean myHaveSelectedFilesUnderSourceRoots;

        protected RootsSelection() {
        }
    }
}

