/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar.ui;

import com.intellij.ide.navigationToolbar.NavBarItem;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.navigationToolbar.NavBarRootPaneExtension;
import com.intellij.ide.navigationToolbar.ui.NavBarUI;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractNavBarUI
implements NavBarUI {
    private static final Map<NavBarItem, Map<ImageType, BufferedImage>> myCache = new THashMap();

    @Override
    public Insets getElementIpad(boolean isPopupElement) {
        return isPopupElement ? JBUI.insets((int)1, (int)2) : JBUI.emptyInsets();
    }

    public JBInsets getElementPadding() {
        return JBUI.insets((int)3);
    }

    @Override
    public Font getElementFont(NavBarItem navBarItem) {
        return SystemInfo.isMac ? UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL) : UIUtil.getLabelFont();
    }

    @Override
    public Color getBackground(boolean selected, boolean focused) {
        return selected && focused ? UIUtil.getListSelectionBackground() : UIUtil.getListBackground();
    }

    @Override
    @Nullable
    public Color getForeground(boolean selected, boolean focused, boolean inactive) {
        return selected && focused ? UIUtil.getListSelectionForeground() : (inactive ? UIUtil.getInactiveTextColor() : null);
    }

    @Override
    public short getSelectionAlpha() {
        return (short)(UIUtil.isUnderAlloyLookAndFeel() && !UIUtil.isUnderAlloyIDEALookAndFeel() ? 255 : 150);
    }

    @Override
    public boolean isDrawMacShadow(boolean selected, boolean focused) {
        return false;
    }

    @Override
    public void doPaintNavBarItem(Graphics2D g, NavBarItem item, NavBarPanel navbar) {
        BufferedImage image;
        ImageType type;
        boolean floating = navbar.isInFloatingMode();
        boolean toolbarVisible = UISettings.getInstance().SHOW_MAIN_TOOLBAR;
        boolean selected = item.isSelected() && item.isFocused();
        boolean nextSelected = item.isNextSelected() && navbar.hasFocus();
        HashMap cached = myCache.get((Object)item);
        if (floating) {
            type = selected ? ImageType.ACTIVE_FLOATING : (nextSelected ? ImageType.NEXT_ACTIVE_FLOATING : ImageType.INACTIVE_FLOATING);
        } else if (toolbarVisible) {
            type = selected ? ImageType.ACTIVE : (nextSelected ? ImageType.NEXT_ACTIVE : ImageType.INACTIVE);
        } else {
            ImageType imageType = selected ? ImageType.ACTIVE_NO_TOOLBAR : (type = nextSelected ? ImageType.NEXT_ACTIVE_NO_TOOLBAR : ImageType.INACTIVE_NO_TOOLBAR);
        }
        if (cached == null) {
            cached = new HashMap();
            myCache.put(item, (Map<ImageType, BufferedImage>)cached);
        }
        if ((image = cached.get((Object)type)) == null) {
            image = this.drawToBuffer(item, floating, toolbarVisible, selected, navbar);
            cached.put(type, image);
        }
        UIUtil.drawImage((Graphics)g, (Image)image, (int)0, (int)0, null);
        Icon icon = item.getIcon();
        int offset = item.isFirstElement() ? this.getFirstElementLeftOffset() : 0;
        int iconOffset = this.getElementPadding().left + offset;
        icon.paintIcon((Component)((Object)item), g, iconOffset, (item.getHeight() - icon.getIconHeight()) / 2);
        int textOffset = icon.getIconWidth() + this.getElementPadding().width() + offset;
        item.doPaintText(g, textOffset);
    }

    private BufferedImage drawToBuffer(NavBarItem item, boolean floating, boolean toolbarVisible, boolean selected, NavBarPanel navbar) {
        int w = item.getWidth();
        int h = item.getHeight();
        int offset = w - this.getDecorationOffset();
        int h2 = h / 2;
        BufferedImage result2 = UIUtil.createImage((int)w, (int)h, (int)2);
        Object defaultBg = UIUtil.isUnderDarcula() ? Gray._100 : Color.WHITE;
        Object bg = floating ? defaultBg : null;
        Color selection = UIUtil.getListSelectionBackground();
        Graphics2D g2 = result2.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Path2D.Double shape = new Path2D.Double();
        shape.moveTo(0.0, 0.0);
        shape.lineTo(offset, 0.0);
        shape.lineTo(w, h2);
        shape.lineTo(offset, h);
        shape.lineTo(0.0, h);
        shape.closePath();
        Path2D.Double endShape = new Path2D.Double();
        endShape.moveTo(offset, 0.0);
        endShape.lineTo(w, 0.0);
        endShape.lineTo(w, h);
        endShape.lineTo(offset, h);
        endShape.lineTo(w, h2);
        endShape.closePath();
        if (bg != null && toolbarVisible) {
            g2.setPaint((Paint)bg);
            g2.fill(shape);
            if (!item.isLastElement() || floating) {
                g2.fill(endShape);
            }
        }
        if (selected) {
            Path2D.Double focusShape = new Path2D.Double();
            if (toolbarVisible || floating) {
                focusShape.moveTo(offset, 0.0);
            } else {
                focusShape.moveTo(0.0, 0.0);
                focusShape.lineTo(offset, 0.0);
            }
            focusShape.lineTo(w - 1, h2);
            focusShape.lineTo(offset, h - 1);
            if (!toolbarVisible && !floating) {
                focusShape.lineTo(0.0, h - 1);
            }
            g2.setColor(selection);
            if (floating && item.isLastElement()) {
                g2.fillRect(0, 0, w, h);
            } else {
                g2.fill(shape);
                g2.setColor(new Color(0, 0, 0, 70));
                g2.draw(focusShape);
            }
        }
        if (item.isNextSelected() && navbar.hasFocus()) {
            g2.setColor(selection);
            g2.fill(endShape);
            Path2D.Double endFocusShape = new Path2D.Double();
            if (toolbarVisible || floating) {
                endFocusShape.moveTo(offset, 0.0);
            } else {
                endFocusShape.moveTo(w, 0.0);
                endFocusShape.lineTo(offset, 0.0);
            }
            endFocusShape.lineTo(w - 1, h2);
            endFocusShape.lineTo(offset, h - 1);
            if (!toolbarVisible && !floating) {
                endFocusShape.lineTo(w, h - 1);
            }
            g2.setColor(new Color(0, 0, 0, 70));
            g2.draw(endFocusShape);
        }
        g2.translate(offset, 0);
        int off = this.getDecorationOffset() - 1;
        if (!floating || !item.isLastElement()) {
            if (toolbarVisible || floating) {
                if (!selected && !navbar.hasFocus() | !item.isNextSelected()) {
                    Color hl = UIUtil.isUnderDarcula() ? Gray._128.withAlpha(100) : (UIUtil.isUnderAlloyLookAndFeel() ? new Color(255, 255, 255, 200) : Gray._205);
                    AbstractNavBarUI.drawArrow(g2, new Color(0, 0, 0, 70), hl, off, h, !selected && !floating, false);
                }
            } else if (!selected && !navbar.hasFocus() | !item.isNextSelected()) {
                Color hl = UIUtil.isUnderDarcula() ? Gray._128.withAlpha(100) : Gray._255.withAlpha(200);
                AbstractNavBarUI.drawArrow(g2, new Color(0, 0, 0, 150), hl, off, h, !selected && !floating, true);
            }
        }
        g2.dispose();
        return result2;
    }

    private static void drawArrow(Graphics2D g2d, Color c, Color light, int decorationOffset, int h, boolean highlight, boolean gradient) {
        int off = decorationOffset - 1;
        g2d.setColor(c);
        if (gradient) {
            g2d.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)ColorUtil.toAlpha((Color)c, (int)10), (float)0.0f, (float)(h / 2), (Color)c));
        }
        g2d.drawLine(0, 0, off, h / 2);
        if (gradient) {
            g2d.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)(h / 2), (Color)c, (float)0.0f, (float)h, (Color)ColorUtil.toAlpha((Color)c, (int)10)));
        }
        g2d.drawLine(off, h / 2, 0, h);
        if (highlight) {
            g2d.translate(-1, 0);
            g2d.setColor(light);
            if (gradient) {
                g2d.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)ColorUtil.toAlpha((Color)light, (int)10), (float)0.0f, (float)(h / 2), (Color)light));
            }
            g2d.drawLine(0, 0, off, h / 2);
            if (gradient) {
                g2d.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)(h / 2), (Color)light, (float)0.0f, (float)h, (Color)ColorUtil.toAlpha((Color)light, (int)10)));
            }
            g2d.drawLine(off, h / 2, 0, h);
        }
    }

    private int getDecorationOffset() {
        return JBUI.scale((int)8);
    }

    private int getFirstElementLeftOffset() {
        return JBUI.scale((int)6);
    }

    @Override
    public Dimension getOffsets(NavBarItem item) {
        Dimension size = new Dimension();
        if (!item.isPopupElement()) {
            size.width = size.width + (this.getDecorationOffset() + this.getElementPadding().width() + (item.isFirstElement() ? this.getFirstElementLeftOffset() : 0));
            size.height += this.getElementPadding().height();
        }
        return size;
    }

    @Override
    public Insets getWrapperPanelInsets(Insets insets) {
        JBInsets result2 = JBUI.insets((Insets)insets);
        if (AbstractNavBarUI.shouldPaintWrapperPanel()) {
            result2.top += JBUI.scale((int)1);
        }
        return result2;
    }

    private static boolean shouldPaintWrapperPanel() {
        return !UISettings.getInstance().SHOW_MAIN_TOOLBAR && NavBarRootPaneExtension.runToolbarExists();
    }

    protected Color getBackgroundColor() {
        return UIUtil.getSlightlyDarkerColor((Color)UIUtil.getPanelBackground());
    }

    @Override
    public void doPaintNavBarPanel(Graphics2D g, Rectangle r, boolean mainToolbarVisible, boolean undocked) {
        g.setColor(this.getBackgroundColor());
        if (!UIUtil.isUnderAquaLookAndFeel() && mainToolbarVisible) {
            g.fillRect(0, 0, r.width, r.height);
        }
    }

    @Override
    public void clearItems() {
        myCache.clear();
    }

    @Override
    public int getPopupOffset(@NotNull NavBarItem item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/ide/navigationToolbar/ui/AbstractNavBarUI", "getPopupOffset"));
        }
        return item.isFirstElement() ? 0 : JBUI.scale((int)5);
    }

    private static enum ImageType {
        INACTIVE,
        NEXT_ACTIVE,
        ACTIVE,
        INACTIVE_FLOATING,
        NEXT_ACTIVE_FLOATING,
        ACTIVE_FLOATING,
        INACTIVE_NO_TOOLBAR,
        NEXT_ACTIVE_NO_TOOLBAR,
        ACTIVE_NO_TOOLBAR;

    }
}

