/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.FileTemplatesScheme;
import com.intellij.ide.fileTemplates.impl.AllFileTemplatesConfigurable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Condition;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ChangeSchemaCombo
extends ComboBoxAction
implements DumbAware {
    private final AllFileTemplatesConfigurable myConfigurable;

    public ChangeSchemaCombo(AllFileTemplatesConfigurable configurable) {
        this.myConfigurable = configurable;
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setText(this.myConfigurable.getCurrentScheme().getName());
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup group = new DefaultActionGroup(new AnAction[]{new ChangeSchemaAction(FileTemplatesScheme.DEFAULT)});
        FileTemplatesScheme scheme = this.myConfigurable.getManager().getProjectScheme();
        if (scheme != null) {
            group.add((AnAction)new ChangeSchemaAction(scheme));
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/ChangeSchemaCombo", "createPopupActionGroup"));
        }
        return defaultActionGroup;
    }

    protected Condition<AnAction> getPreselectCondition() {
        return new Condition<AnAction>(){

            public boolean value(AnAction action) {
                return ChangeSchemaCombo.this.myConfigurable.getCurrentScheme().getName().equals(action.getTemplatePresentation().getText());
            }
        };
    }

    private class ChangeSchemaAction
    extends AnAction {
        private final FileTemplatesScheme myScheme;

        public ChangeSchemaAction(FileTemplatesScheme scheme) {
            if (scheme == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/ide/fileTemplates/impl/ChangeSchemaCombo$ChangeSchemaAction", "<init>"));
            }
            super(scheme.getName());
            this.myScheme = scheme;
        }

        public void actionPerformed(AnActionEvent e) {
            ChangeSchemaCombo.this.myConfigurable.changeScheme(this.myScheme);
            ChangeSchemaCombo.this.getTemplatePresentation().setText(this.myScheme.getName());
        }
    }
}

