/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl.ui;

import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.framework.detection.FrameworkDetectionContext;
import com.intellij.framework.detection.impl.ui.DetectedFrameworkTreeNodeBase;
import com.intellij.framework.detection.impl.ui.DetectedFrameworksTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class DetectedFrameworksComponent {
    private JPanel myMainPanel;
    private final DetectedFrameworksTree myTree;
    private JPanel myTreePanel;
    private JComboBox myGroupByComboBox;
    private JLabel myDescriptionLabel;
    private JPanel myOptionsPanel;

    public DetectedFrameworksComponent(FrameworkDetectionContext context) {
        this.$$$setupUI$$$();
        this.myTree = new DetectedFrameworksTree(context, GroupByOption.TYPE){

            @Override
            protected void onNodeStateChanged(CheckedTreeNode node) {
                super.onNodeStateChanged(node);
                DetectedFrameworksComponent.this.updateOptionsPanel();
            }
        };
        this.myTreePanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree)), "Center");
        this.myGroupByComboBox.setModel(new EnumComboBoxModel(GroupByOption.class));
        this.myGroupByComboBox.setRenderer(new GroupByListCellRenderer());
        this.myGroupByComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetectedFrameworksComponent.this.myTree.changeGroupBy((GroupByOption)((Object)DetectedFrameworksComponent.this.myGroupByComboBox.getSelectedItem()));
            }
        });
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DetectedFrameworksComponent.this.updateOptionsPanel();
            }
        });
        this.updateOptionsPanel();
    }

    public DetectedFrameworksTree getTree() {
        return this.myTree;
    }

    private void updateOptionsPanel() {
        DetectedFrameworkTreeNodeBase[] nodes = (DetectedFrameworkTreeNodeBase[])this.myTree.getSelectedNodes(DetectedFrameworkTreeNodeBase.class, null);
        if (nodes.length == 1) {
            String description;
            DetectedFrameworkTreeNodeBase node = nodes[0];
            String string = description = node.isChecked() ? node.getCheckedDescription() : node.getUncheckedDescription();
            if (description != null) {
                ((CardLayout)this.myOptionsPanel.getLayout()).show(this.myOptionsPanel, "description");
                this.myDescriptionLabel.setText(UIUtil.toHtml((String)description));
                return;
            }
        }
        ((CardLayout)this.myOptionsPanel.getLayout()).show(this.myOptionsPanel, "empty");
    }

    public List<DetectedFrameworkDescription> getSelectedFrameworks() {
        return Arrays.asList(this.myTree.getCheckedNodes(DetectedFrameworkDescription.class, null));
    }

    public JComponent getMainPanel() {
        return this.myMainPanel;
    }

    public void processUncheckedNodes(final DetectionExcludesConfiguration excludesConfiguration) {
        this.getTree().processUncheckedNodes(new Consumer<DetectedFrameworkTreeNodeBase>(){

            public void consume(DetectedFrameworkTreeNodeBase node) {
                node.disableDetection(excludesConfiguration);
            }
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel;
        JPanel jPanel2;
        JComboBox jComboBox;
        JPanel jPanel3;
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 5));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, "North");
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myGroupByComboBox = jComboBox = new JComboBox();
        jPanel4.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Group by:");
        jLabel2.setDisplayedMnemonic('G');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTreePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, "Center");
        this.myOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel3.add((Component)jPanel, "South");
        this.myDescriptionLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, "description");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, "empty");
        jLabel2.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static class GroupByListCellRenderer
    extends ListCellRendererWrapper<GroupByOption> {
        public void customize(JList list, GroupByOption value, int index, boolean selected, boolean hasFocus) {
            if (value != null) {
                this.setText(value.name().toLowerCase());
            }
        }
    }

    public static enum GroupByOption {
        TYPE,
        DIRECTORY;

    }
}

