/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl;

import com.intellij.framework.detection.FrameworkDetector;
import com.intellij.framework.detection.impl.FrameworkDetectionIndexListener;
import com.intellij.framework.detection.impl.FrameworkDetectorRegistry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FrameworkDetectionIndex
extends ScalarIndexExtension<Integer> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.framework.detection.impl.FrameworkDetectionIndex");
    public static final ID<Integer, Void> NAME = ID.create((String)"FrameworkDetectionIndex");
    private final FrameworkDetectorRegistry myRegistry;
    private final EventDispatcher<FrameworkDetectionIndexListener> myDispatcher = EventDispatcher.create(FrameworkDetectionIndexListener.class);

    public FrameworkDetectionIndex(FrameworkDetectorRegistry registry) {
        this.myRegistry = registry;
    }

    public static FrameworkDetectionIndex getInstance() {
        return (FrameworkDetectionIndex)((Object)EXTENSION_POINT_NAME.findExtension(FrameworkDetectionIndex.class));
    }

    @NotNull
    public ID<Integer, Void> getName() {
        ID<Integer, Void> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/detection/impl/FrameworkDetectionIndex", "getName"));
        }
        return iD;
    }

    public void addListener(@NotNull FrameworkDetectionIndexListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/framework/detection/impl/FrameworkDetectionIndex", "addListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/framework/detection/impl/FrameworkDetectionIndex", "addListener"));
        }
        this.myDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    @NotNull
    public DataIndexer<Integer, Void, FileContent> getIndexer() {
        final MultiMap detectors = new MultiMap();
        for (FrameworkDetector detector : (FrameworkDetector[])FrameworkDetector.EP_NAME.getExtensions()) {
            detectors.putValue((Object)detector.getFileType(), (Object)Pair.create((Object)detector.createSuitableFilePattern(), (Object)this.myRegistry.getDetectorId(detector)));
        }
        DataIndexer<Integer, Void, FileContent> dataIndexer = new DataIndexer<Integer, Void, FileContent>(){

            @NotNull
            public Map<Integer, Void> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/framework/detection/impl/FrameworkDetectionIndex$1", "map"));
                }
                FileType fileType = inputData.getFileType();
                if (!detectors.containsKey((Object)fileType)) {
                    Map<Integer, Void> map = Collections.emptyMap();
                    if (map == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/detection/impl/FrameworkDetectionIndex$1", "map"));
                    }
                    return map;
                }
                Map<Integer, Void> result2 = null;
                for (Pair pair : detectors.get((Object)fileType)) {
                    if (!((ElementPattern)pair.getFirst()).accepts((Object)inputData)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(inputData.getFile() + " accepted by detector " + pair.getSecond());
                    }
                    if (result2 == null) {
                        result2 = new HashMap<Integer, Void>();
                    }
                    ((FrameworkDetectionIndexListener)FrameworkDetectionIndex.this.myDispatcher.getMulticaster()).fileUpdated(inputData.getFile(), (Integer)pair.getSecond());
                    result2.put((Integer)pair.getSecond(), null);
                }
                Map<Integer, Void> map = result2 != null ? result2 : Collections.emptyMap();
                if (map == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/detection/impl/FrameworkDetectionIndex$1", "map"));
                }
                return map;
            }
        };
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/detection/impl/FrameworkDetectionIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<Integer> getKeyDescriptor() {
        EnumeratorIntegerDescriptor enumeratorIntegerDescriptor = EnumeratorIntegerDescriptor.INSTANCE;
        if (enumeratorIntegerDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/detection/impl/FrameworkDetectionIndex", "getKeyDescriptor"));
        }
        return enumeratorIntegerDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        HashSet<FileType> acceptedTypes = new HashSet<FileType>();
        for (FrameworkDetector detector : (FrameworkDetector[])FrameworkDetector.EP_NAME.getExtensions()) {
            acceptedTypes.add(detector.getFileType());
        }
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(acceptedTypes.toArray(new FileType[acceptedTypes.size()]));
        if (defaultFileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/detection/impl/FrameworkDetectionIndex", "getInputFilter"));
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return this.myRegistry.getDetectorsVersion();
    }
}

