/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.FindUsagesUtil;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.ObjectUtils;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonFindUsagesDialog
extends AbstractFindUsagesDialog {
    @NotNull
    protected final PsiElement myPsiElement;
    @Nullable
    private final String myHelpId;

    public CommonFindUsagesDialog(@NotNull PsiElement element, @NotNull Project project, @NotNull FindUsagesOptions findUsagesOptions, boolean toShowInNewTab, boolean mustOpenInNewTab, boolean isSingleFile, @NotNull FindUsagesHandler handler2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/findUsages/CommonFindUsagesDialog", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/findUsages/CommonFindUsagesDialog", "<init>"));
        }
        if (findUsagesOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findUsagesOptions", "com/intellij/find/findUsages/CommonFindUsagesDialog", "<init>"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/findUsages/CommonFindUsagesDialog", "<init>"));
        }
        super(project, findUsagesOptions, toShowInNewTab, mustOpenInNewTab, isSingleFile, CommonFindUsagesDialog.isTextSearch(element, isSingleFile, handler2), !isSingleFile && !element.getManager().isInProject(element));
        this.myPsiElement = element;
        this.myHelpId = (String)ObjectUtils.chooseNotNull((Object)handler2.getHelpId(), (Object)"reference.dialogs.findUsages.other");
        this.init();
    }

    private static boolean isTextSearch(@NotNull PsiElement element, boolean isSingleFile, @NotNull FindUsagesHandler handler2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/findUsages/CommonFindUsagesDialog", "isTextSearch"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/findUsages/CommonFindUsagesDialog", "isTextSearch"));
        }
        return FindUsagesUtil.isSearchForTextOccurrencesAvailable(element, isSingleFile, handler2);
    }

    @Override
    protected boolean isInFileOnly() {
        return super.isInFileOnly() || PsiSearchHelper.SERVICE.getInstance((Project)this.myPsiElement.getProject()).getUseScope(this.myPsiElement) instanceof LocalSearchScope;
    }

    @Override
    protected JPanel createFindWhatPanel() {
        return null;
    }

    @Override
    public void configureLabelComponent(@NotNull SimpleColoredComponent coloredComponent) {
        if (coloredComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coloredComponent", "com/intellij/find/findUsages/CommonFindUsagesDialog", "configureLabelComponent"));
        }
        coloredComponent.append(StringUtil.capitalize((String)UsageViewUtil.getType(this.myPsiElement)));
        coloredComponent.append(" ");
        coloredComponent.append(DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myPsiElement), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
    }

    @Nullable
    protected String getHelpId() {
        return this.myHelpId;
    }
}

