/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.execution.testDiscovery.TestDiscoveryIndex;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestDiscoverySearchHelper {
    public static Set<String> search(final Project project, final Pair<String, String> position, String changeList, final String frameworkPrefix) {
        final LinkedHashSet<String> patterns = new LinkedHashSet<String>();
        if (position != null) {
            try {
                TestDiscoverySearchHelper.collectPatterns(project, patterns, (String)position.first, (String)position.second, frameworkPrefix);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        List<VirtualFile> files = TestDiscoverySearchHelper.getAffectedFiles(changeList, project);
        final PsiManager psiManager = PsiManager.getInstance((Project)project);
        final TestDiscoveryIndex discoveryIndex = TestDiscoveryIndex.getInstance(project);
        for (final VirtualFile file2 : files) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    PsiFile psiFile = psiManager.findFile(file2);
                    if (psiFile instanceof PsiClassOwner) {
                        PsiClass[] classes;
                        if (position != null && ((classes = ((PsiClassOwner)psiFile).getClasses()).length == 0 || TestFrameworks.detectFramework((PsiClass)classes[0]) == null)) {
                            return;
                        }
                        try {
                            List<TextRange> changedTextRanges = FormatChangedTextUtil.getInstance().getChangedTextRanges(project, psiFile);
                            for (TextRange textRange : changedTextRanges) {
                                PsiElement start = psiFile.findElementAt(textRange.getStartOffset());
                                PsiElement end = psiFile.findElementAt(textRange.getEndOffset());
                                PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement[])new PsiElement[]{start, end});
                                ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>(PsiTreeUtil.findChildrenOfType((PsiElement)parent, PsiMethod.class));
                                PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiMethod.class);
                                if (containingMethod != null) {
                                    methods.add(containingMethod);
                                }
                                for (PsiMethod changedMethod : methods) {
                                    PsiClass containingClass;
                                    LinkedHashSet detectedPatterns;
                                    LinkedHashSet linkedHashSet = detectedPatterns = position == null ? TestDiscoverySearchHelper.collectPatterns(changedMethod, frameworkPrefix) : null;
                                    if (detectedPatterns != null) {
                                        patterns.addAll(detectedPatterns);
                                    }
                                    if ((containingClass = changedMethod.getContainingClass()) == null || containingClass.getParent() != psiFile) continue;
                                    String classQualifiedName = containingClass.getQualifiedName();
                                    String changedMethodName = changedMethod.getName();
                                    try {
                                        if (classQualifiedName == null || (position != null || TestFrameworks.detectFramework((PsiClass)containingClass) == null) && (position == null || discoveryIndex.hasTestTrace(frameworkPrefix + classQualifiedName + "-" + changedMethodName))) continue;
                                        patterns.add(classQualifiedName + "," + changedMethodName);
                                    }
                                    catch (IOException iOException) {}
                                }
                            }
                        }
                        catch (FilesTooBigForDiffException filesTooBigForDiffException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        return patterns;
    }

    private static void collectPatterns(Project project, Set<String> patterns, String classFQName, String methodName, final String frameworkId) throws IOException {
        TestDiscoveryIndex discoveryIndex = TestDiscoveryIndex.getInstance(project);
        Collection<String> testsByMethodName = discoveryIndex.getTestsByMethodName(classFQName, methodName);
        if (testsByMethodName != null) {
            for (String pattern : ContainerUtil.filter(testsByMethodName, (Condition)new Condition<String>(){

                public boolean value(String s) {
                    return s.startsWith(frameworkId);
                }
            })) {
                patterns.add(pattern.substring(frameworkId.length()).replace('-', ','));
            }
        }
    }

    @NotNull
    private static List<VirtualFile> getAffectedFiles(String changeListName, Project project) {
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        if (changeListName == null) {
            List list = changeListManager.getAffectedFiles();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testDiscovery/TestDiscoverySearchHelper", "getAffectedFiles"));
            }
            return list;
        }
        LocalChangeList changeList = changeListManager.findChangeList(changeListName);
        if (changeList != null) {
            ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
            for (Change change : changeList.getChanges()) {
                VirtualFile file2;
                ContentRevision afterRevision = change.getAfterRevision();
                if (afterRevision == null || (file2 = afterRevision.getFile().getVirtualFile()) == null) continue;
                files.add(file2);
            }
            ArrayList<VirtualFile> arrayList = files;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testDiscovery/TestDiscoverySearchHelper", "getAffectedFiles"));
            }
            return arrayList;
        }
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testDiscovery/TestDiscoverySearchHelper", "getAffectedFiles"));
        }
        return list;
    }

    @Nullable
    private static LinkedHashSet<String> collectPatterns(PsiMethod psiMethod, String frameworkId) {
        String qualifiedName;
        LinkedHashSet<String> patterns = new LinkedHashSet<String>();
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass != null && (qualifiedName = containingClass.getQualifiedName()) != null) {
            try {
                TestDiscoverySearchHelper.collectPatterns(psiMethod.getProject(), patterns, qualifiedName, psiMethod.getName(), frameworkId);
            }
            catch (IOException e) {
                return null;
            }
        }
        return patterns;
    }
}

