/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionAdapter;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.impl.RunConfigurationBeforeRunProviderDelegate;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.concurrency.Semaphore;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunConfigurationBeforeRunProvider
extends BeforeRunTaskProvider<RunConfigurableBeforeRunTask> {
    public static final Key<RunConfigurableBeforeRunTask> ID = Key.create((String)"RunConfigurationTask");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.impl.RunConfigurationBeforeRunProvider");
    private final Project myProject;

    public RunConfigurationBeforeRunProvider(Project project) {
        this.myProject = project;
    }

    public Key<RunConfigurableBeforeRunTask> getId() {
        return ID;
    }

    public Icon getIcon() {
        return AllIcons.Actions.Execute;
    }

    public Icon getTaskIcon(RunConfigurableBeforeRunTask task) {
        if (task.getSettings() == null) {
            return null;
        }
        return ProgramRunnerUtil.getConfigurationIcon(task.getSettings(), false);
    }

    public String getName() {
        return ExecutionBundle.message((String)"before.launch.run.another.configuration", (Object[])new Object[0]);
    }

    public String getDescription(RunConfigurableBeforeRunTask task) {
        if (task.getSettings() == null) {
            return ExecutionBundle.message((String)"before.launch.run.another.configuration", (Object[])new Object[0]);
        }
        return ExecutionBundle.message((String)"before.launch.run.certain.configuration", (Object[])new Object[]{task.getSettings().getName()});
    }

    public boolean isConfigurable() {
        return true;
    }

    @Nullable
    public RunConfigurableBeforeRunTask createTask(RunConfiguration runConfiguration) {
        Collection<RunnerAndConfigurationSettings> configurations;
        if (runConfiguration.getProject().isInitialized() && ((configurations = RunManagerImpl.getInstanceImpl(runConfiguration.getProject()).getSortedConfigurations()).isEmpty() || configurations.size() == 1 && configurations.iterator().next().getConfiguration() == runConfiguration)) {
            return null;
        }
        return new RunConfigurableBeforeRunTask();
    }

    public boolean configureTask(RunConfiguration runConfiguration, RunConfigurableBeforeRunTask task) {
        SelectionDialog dialog = new SelectionDialog(task.getSettings(), RunConfigurationBeforeRunProvider.getAvailableConfigurations(runConfiguration));
        dialog.show();
        RunnerAndConfigurationSettings settings = dialog.getSelectedSettings();
        if (settings != null) {
            task.setSettings(settings);
            return true;
        }
        return false;
    }

    @NotNull
    private static List<RunnerAndConfigurationSettings> getAvailableConfigurations(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/execution/impl/RunConfigurationBeforeRunProvider", "getAvailableConfigurations"));
        }
        Project project = runConfiguration.getProject();
        if (project == null || !project.isInitialized()) {
            List<RunnerAndConfigurationSettings> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunConfigurationBeforeRunProvider", "getAvailableConfigurations"));
            }
            return list;
        }
        ArrayList<RunnerAndConfigurationSettings> configurations = new ArrayList<RunnerAndConfigurationSettings>(RunManagerImpl.getInstanceImpl(project).getSortedConfigurations());
        String executorId = DefaultRunExecutor.getRunExecutorInstance().getId();
        Iterator iterator = configurations.iterator();
        while (iterator.hasNext()) {
            RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)iterator.next();
            ProgramRunner runner = ProgramRunnerUtil.getRunner(executorId, settings);
            if (runner != null && settings.getConfiguration() != runConfiguration) continue;
            iterator.remove();
        }
        ArrayList<RunnerAndConfigurationSettings> arrayList = configurations;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunConfigurationBeforeRunProvider", "getAvailableConfigurations"));
        }
        return arrayList;
    }

    public boolean canExecuteTask(RunConfiguration configuration, RunConfigurableBeforeRunTask task) {
        RunnerAndConfigurationSettings settings = task.getSettings();
        if (settings == null) {
            return false;
        }
        String executorId = DefaultRunExecutor.getRunExecutorInstance().getId();
        ProgramRunner runner = ProgramRunnerUtil.getRunner(executorId, settings);
        return runner != null && runner.canRun(executorId, (RunProfile)settings.getConfiguration());
    }

    public boolean executeTask(DataContext dataContext, RunConfiguration configuration, ExecutionEnvironment env, RunConfigurableBeforeRunTask task) {
        RunnerAndConfigurationSettings settings = task.getSettings();
        if (settings == null) {
            return false;
        }
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        final String executorId = executor.getId();
        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.createOrNull((Executor)executor, (RunnerAndConfigurationSettings)settings);
        if (builder == null) {
            return false;
        }
        final ExecutionEnvironment environment = builder.target(env.getExecutionTarget()).build();
        environment.setExecutionId(env.getExecutionId());
        if (!ExecutionTargetManager.canRun((RunnerAndConfigurationSettings)settings, (ExecutionTarget)environment.getExecutionTarget())) {
            return false;
        }
        if (!environment.getRunner().canRun(executorId, environment.getRunProfile())) {
            return false;
        }
        RunConfigurationBeforeRunProvider.beforeRun(environment);
        final Semaphore targetDone = new Semaphore();
        final Ref result2 = new Ref((Object)false);
        Disposable disposable = Disposer.newDisposable();
        this.myProject.getMessageBus().connect(disposable).subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionAdapter(){

            public void processStartScheduled(String executorIdLocal, ExecutionEnvironment environmentLocal) {
                if (executorId.equals(executorIdLocal) && environment.equals(environmentLocal)) {
                    targetDone.down();
                }
            }

            public void processNotStarted(String executorIdLocal, @NotNull ExecutionEnvironment environmentLocal) {
                if (environmentLocal == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environmentLocal", "com/intellij/execution/impl/RunConfigurationBeforeRunProvider$1", "processNotStarted"));
                }
                if (executorId.equals(executorIdLocal) && environment.equals(environmentLocal)) {
                    Boolean skipRun = (Boolean)environment.getUserData(ExecutionManagerImpl.EXECUTION_SKIP_RUN);
                    if (skipRun != null && skipRun.booleanValue()) {
                        result2.set((Object)true);
                    }
                    targetDone.up();
                }
            }

            public void processStarted(String executorIdLocal, @NotNull ExecutionEnvironment environmentLocal, @NotNull ProcessHandler handler2) {
                if (environmentLocal == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environmentLocal", "com/intellij/execution/impl/RunConfigurationBeforeRunProvider$1", "processStarted"));
                }
                if (handler2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/execution/impl/RunConfigurationBeforeRunProvider$1", "processStarted"));
                }
                if (executorId.equals(executorIdLocal) && environment.equals(environmentLocal)) {
                    handler2.addProcessListener((ProcessListener)new ProcessAdapter(){

                        public void processTerminated(ProcessEvent event) {
                            result2.set((Object)(event.getExitCode() == 0 ? 1 : 0));
                            targetDone.up();
                        }
                    });
                }
            }
        });
        try {
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        environment.getRunner().execute(environment);
                    }
                    catch (ExecutionException e) {
                        targetDone.up();
                        LOG.error((Throwable)e);
                    }
                }
            }, ModalityState.NON_MODAL);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            Disposer.dispose((Disposable)disposable);
            return false;
        }
        targetDone.waitFor();
        Disposer.dispose((Disposable)disposable);
        return (Boolean)result2.get();
    }

    private static void beforeRun(@NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/impl/RunConfigurationBeforeRunProvider", "beforeRun"));
        }
        for (RunConfigurationBeforeRunProviderDelegate delegate : (RunConfigurationBeforeRunProviderDelegate[])Extensions.getExtensions(RunConfigurationBeforeRunProviderDelegate.EP_NAME)) {
            delegate.beforeRun(environment);
        }
    }

    private class SelectionDialog
    extends DialogWrapper {
        private RunnerAndConfigurationSettings mySelectedSettings;
        @NotNull
        private final List<RunnerAndConfigurationSettings> mySettings;
        private JBList myJBList;

        private SelectionDialog(@NotNull RunnerAndConfigurationSettings selectedSettings, List<RunnerAndConfigurationSettings> settings) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/impl/RunConfigurationBeforeRunProvider$SelectionDialog", "<init>"));
            }
            super(RunConfigurationBeforeRunProvider.this.myProject);
            this.setTitle(ExecutionBundle.message((String)"before.launch.run.another.configuration.choose", (Object[])new Object[0]));
            this.mySelectedSettings = selectedSettings;
            this.mySettings = settings;
            this.init();
            this.myJBList.setSelectedValue((Object)this.mySelectedSettings, true);
            this.myJBList.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                        SelectionDialog.this.doOKAction();
                    }
                }
            });
            FontMetrics fontMetrics = this.myJBList.getFontMetrics(this.myJBList.getFont());
            int maxWidth = fontMetrics.stringWidth("m") * 30;
            for (RunnerAndConfigurationSettings setting : settings) {
                maxWidth = Math.max(fontMetrics.stringWidth(setting.getConfiguration().getName()), maxWidth);
            }
            this.myJBList.setMinimumSize(new Dimension(maxWidth += 24, this.myJBList.getPreferredSize().height));
        }

        @Nullable
        protected String getDimensionServiceKey() {
            return "com.intellij.execution.impl.RunConfigurationBeforeRunProvider.dimensionServiceKey;";
        }

        protected JComponent createCenterPanel() {
            this.myJBList = new JBList(this.mySettings);
            this.myJBList.setSelectionMode(0);
            this.myJBList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    Object selectedValue = SelectionDialog.this.myJBList.getSelectedValue();
                    if (selectedValue instanceof RunnerAndConfigurationSettings) {
                        SelectionDialog.this.mySelectedSettings = (RunnerAndConfigurationSettings)selectedValue;
                    } else {
                        SelectionDialog.this.mySelectedSettings = null;
                    }
                    SelectionDialog.this.setOKActionEnabled(SelectionDialog.this.mySelectedSettings != null);
                }
            });
            this.myJBList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer(){

                protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                    if (value instanceof RunnerAndConfigurationSettings) {
                        RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)value;
                        RunManagerEx runManager = RunManagerEx.getInstanceEx(RunConfigurationBeforeRunProvider.this.myProject);
                        this.setIcon(runManager.getConfigurationIcon(settings));
                        RunConfiguration configuration = settings.getConfiguration();
                        this.append(configuration.getName(), settings.isTemporary() ? SimpleTextAttributes.GRAY_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }
            });
            return new JBScrollPane((Component)this.myJBList);
        }

        @Nullable
        RunnerAndConfigurationSettings getSelectedSettings() {
            return this.isOK() ? this.mySelectedSettings : null;
        }
    }

    public class RunConfigurableBeforeRunTask
    extends BeforeRunTask<RunConfigurableBeforeRunTask> {
        private String myConfigurationName;
        private String myConfigurationType;
        private boolean myInitialized;
        private RunnerAndConfigurationSettings mySettings;

        RunConfigurableBeforeRunTask() {
            super(ID);
            this.myInitialized = false;
        }

        public void writeExternal(Element element) {
            super.writeExternal(element);
            if (this.myConfigurationName != null && this.myConfigurationType != null) {
                element.setAttribute("run_configuration_name", this.myConfigurationName);
                element.setAttribute("run_configuration_type", this.myConfigurationType);
            } else if (this.mySettings != null) {
                element.setAttribute("run_configuration_name", this.mySettings.getName());
                element.setAttribute("run_configuration_type", this.mySettings.getType().getId());
            }
        }

        public void readExternal(Element element) {
            super.readExternal(element);
            Attribute configurationNameAttr = element.getAttribute("run_configuration_name");
            Attribute configurationTypeAttr = element.getAttribute("run_configuration_type");
            this.myConfigurationName = configurationNameAttr != null ? configurationNameAttr.getValue() : null;
            this.myConfigurationType = configurationTypeAttr != null ? configurationTypeAttr.getValue() : null;
        }

        void init() {
            if (this.myInitialized) {
                return;
            }
            if (this.myConfigurationType != null && this.myConfigurationName != null) {
                this.setSettings(RunManagerImpl.getInstanceImpl(RunConfigurationBeforeRunProvider.this.myProject).findConfigurationByTypeAndName(this.myConfigurationType, this.myConfigurationName));
            }
        }

        public void setSettings(RunnerAndConfigurationSettings settings) {
            this.mySettings = settings;
            this.myInitialized = true;
        }

        public RunnerAndConfigurationSettings getSettings() {
            this.init();
            return this.mySettings;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RunConfigurableBeforeRunTask that = (RunConfigurableBeforeRunTask)((Object)o);
            if (this.myConfigurationName != null ? !this.myConfigurationName.equals(that.myConfigurationName) : that.myConfigurationName != null) {
                return false;
            }
            return !(this.myConfigurationType != null ? !this.myConfigurationType.equals(that.myConfigurationType) : that.myConfigurationType != null);
        }

        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + (this.myConfigurationName != null ? this.myConfigurationName.hashCode() : 0);
            result2 = 31 * result2 + (this.myConfigurationType != null ? this.myConfigurationType.hashCode() : 0);
            return result2;
        }
    }
}

