/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Font;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleViewUtil {
    public static final Key<Boolean> EDITOR_IS_CONSOLE_VIEW = Key.create((String)"EDITOR_IS_CONSOLE_VIEW");

    public static EditorEx setupConsoleEditor(Project project, boolean foldingOutlineShown, boolean lineMarkerAreaShown) {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document document = ((EditorFactoryImpl)editorFactory).createDocument(true);
        UndoUtil.disableUndoFor((Document)document);
        EditorEx editor = (EditorEx)editorFactory.createViewer(document, project);
        ConsoleViewUtil.setupConsoleEditor(editor, foldingOutlineShown, lineMarkerAreaShown);
        return editor;
    }

    public static void setupConsoleEditor(final @NotNull EditorEx editor, final boolean foldingOutlineShown, final boolean lineMarkerAreaShown) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/impl/ConsoleViewUtil", "setupConsoleEditor"));
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                editor.setSoftWrapAppliancePlace(SoftWrapAppliancePlaces.CONSOLE);
                EditorSettings editorSettings = editor.getSettings();
                editorSettings.setLineMarkerAreaShown(lineMarkerAreaShown);
                editorSettings.setIndentGuidesShown(false);
                editorSettings.setLineNumbersShown(false);
                editorSettings.setFoldingOutlineShown(foldingOutlineShown);
                editorSettings.setAdditionalPageAtBottom(false);
                editorSettings.setAdditionalColumnsCount(0);
                editorSettings.setAdditionalLinesCount(0);
                editorSettings.setRightMarginShown(false);
                editorSettings.setCaretRowShown(false);
                editor.getGutterComponentEx().setPaintBackground(false);
                editor.putUserData(EDITOR_IS_CONSOLE_VIEW, true);
                DelegateColorScheme scheme = ConsoleViewUtil.updateConsoleColorScheme(editor.getColorsScheme());
                if (UISettings.getInstance().PRESENTATION_MODE) {
                    scheme.setEditorFontSize(UISettings.getInstance().PRESENTATION_MODE_FONT_SIZE);
                }
                editor.setColorsScheme(scheme);
            }
        });
    }

    @NotNull
    public static DelegateColorScheme updateConsoleColorScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/execution/impl/ConsoleViewUtil", "updateConsoleColorScheme"));
        }
        DelegateColorScheme delegateColorScheme = new DelegateColorScheme(scheme){

            @Override
            @NotNull
            public Color getDefaultBackground() {
                Color color = this.getColor(ConsoleViewContentType.CONSOLE_BACKGROUND_KEY);
                Color color2 = color == null ? super.getDefaultBackground() : color;
                if (color2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/ConsoleViewUtil$2", "getDefaultBackground"));
                }
                return color2;
            }

            @Override
            @NotNull
            public FontPreferences getFontPreferences() {
                FontPreferences fontPreferences = this.getConsoleFontPreferences();
                if (fontPreferences == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/ConsoleViewUtil$2", "getFontPreferences"));
                }
                return fontPreferences;
            }

            @Override
            public int getEditorFontSize() {
                return this.getConsoleFontSize();
            }

            @Override
            public String getEditorFontName() {
                return this.getConsoleFontName();
            }

            @Override
            public float getLineSpacing() {
                return this.getConsoleLineSpacing();
            }

            @Override
            public Font getFont(EditorFontType key) {
                return super.getFont(EditorFontType.getConsoleType((EditorFontType)key));
            }

            @Override
            public void setEditorFontSize(int fontSize) {
                this.setConsoleFontSize(fontSize);
            }
        };
        if (delegateColorScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/ConsoleViewUtil", "updateConsoleColorScheme"));
        }
        return delegateColorScheme;
    }

    public static boolean isConsoleViewEditor(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/impl/ConsoleViewUtil", "isConsoleViewEditor"));
        }
        return editor.getUserData(EDITOR_IS_CONSOLE_VIEW) == Boolean.TRUE;
    }

    public static void printWithHighlighting(@NotNull ConsoleView console, @NotNull String text, @NotNull SyntaxHighlighter highlighter) {
        IElementType tokenType;
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/execution/impl/ConsoleViewUtil", "printWithHighlighting"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/impl/ConsoleViewUtil", "printWithHighlighting"));
        }
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/execution/impl/ConsoleViewUtil", "printWithHighlighting"));
        }
        Lexer lexer = highlighter.getHighlightingLexer();
        lexer.start((CharSequence)text, 0, text.length(), 0);
        while ((tokenType = lexer.getTokenType()) != null) {
            console.print(lexer.getTokenText(), ConsoleViewUtil.getContentTypeForToken(tokenType, highlighter));
            lexer.advance();
        }
    }

    @NotNull
    public static ConsoleViewContentType getContentTypeForToken(@NotNull IElementType tokenType, @NotNull SyntaxHighlighter highlighter) {
        if (tokenType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenType", "com/intellij/execution/impl/ConsoleViewUtil", "getContentTypeForToken"));
        }
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/execution/impl/ConsoleViewUtil", "getContentTypeForToken"));
        }
        TextAttributesKey[] keys = highlighter.getTokenHighlights(tokenType);
        ConsoleViewContentType consoleViewContentType = keys.length == 0 ? ConsoleViewContentType.NORMAL_OUTPUT : ConsoleViewContentType.getConsoleViewType((Key)ColorCache.keys.get(Arrays.asList(keys)));
        if (consoleViewContentType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/ConsoleViewUtil", "getContentTypeForToken"));
        }
        return consoleViewContentType;
    }

    public static void printAsFileType(@NotNull ConsoleView console, @NotNull String text, @NotNull FileType fileType) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/execution/impl/ConsoleViewUtil", "printAsFileType"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/impl/ConsoleViewUtil", "printAsFileType"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/execution/impl/ConsoleViewUtil", "printAsFileType"));
        }
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)fileType, null, null);
        if (highlighter != null) {
            ConsoleViewUtil.printWithHighlighting(console, text, highlighter);
        } else {
            console.print(text, ConsoleViewContentType.NORMAL_OUTPUT);
        }
    }

    private static class ColorCache {
        static final Map<Key, List<TextAttributesKey>> textAttributeKeys;
        static final Map<Key, TextAttributes> mergedTextAttributes;
        static final Map<List<TextAttributesKey>, Key> keys;

        private ColorCache() {
        }

        static {
            LafManager.getInstance().addLafManagerListener(new LafManagerListener(){

                public void lookAndFeelChanged(LafManager source) {
                    mergedTextAttributes.clear();
                }
            });
            textAttributeKeys = ContainerUtil.newConcurrentMap();
            mergedTextAttributes = new ConcurrentFactoryMap<Key, TextAttributes>(){

                @Nullable
                protected TextAttributes create(Key contentKey) {
                    EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
                    TextAttributes result2 = scheme.getAttributes(HighlighterColors.TEXT);
                    for (TextAttributesKey key : textAttributeKeys.get(contentKey)) {
                        TextAttributes attributes = scheme.getAttributes(key);
                        if (attributes == null) continue;
                        result2 = TextAttributes.merge((TextAttributes)result2, (TextAttributes)attributes);
                    }
                    return result2;
                }
            };
            keys = new ConcurrentFactoryMap<List<TextAttributesKey>, Key>(){

                protected Key create(List<TextAttributesKey> keys) {
                    StringBuilder keyName = new StringBuilder("ConsoleViewUtil_");
                    for (TextAttributesKey key : keys) {
                        keyName.append("_").append(key.getExternalName());
                    }
                    final Key newKey = new Key(keyName.toString());
                    textAttributeKeys.put(newKey, keys);
                    ConsoleViewContentType contentType = new ConsoleViewContentType(keyName.toString(), HighlighterColors.TEXT){

                        public TextAttributes getAttributes() {
                            return mergedTextAttributes.get(newKey);
                        }
                    };
                    ConsoleViewContentType.registerNewConsoleViewType((Key)newKey, (ConsoleViewContentType)contentType);
                    return newKey;
                }
            };
        }
    }
}

