/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ThreesideDiffChangeBase {
    @NotNull
    private ConflictType myType;

    public ThreesideDiffChangeBase(@NotNull MergeLineFragment fragment, @NotNull List<? extends EditorEx> editors, @NotNull ComparisonPolicy policy) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "<init>"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "<init>"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "<init>"));
        }
        this.myType = ThreesideDiffChangeBase.calcType(fragment, editors, policy);
    }

    public abstract int getStartLine(@NotNull ThreeSide var1);

    public abstract int getEndLine(@NotNull ThreeSide var1);

    @NotNull
    public TextDiffType getDiffType() {
        TextDiffType textDiffType = this.myType.getDiffType();
        if (textDiffType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "getDiffType"));
        }
        return textDiffType;
    }

    @NotNull
    public ConflictType getType() {
        ConflictType conflictType = this.myType;
        if (conflictType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "getType"));
        }
        return conflictType;
    }

    public boolean isConflict() {
        return this.getDiffType() == TextDiffType.CONFLICT;
    }

    public boolean isChange(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "isChange"));
        }
        return this.myType.isChange(side);
    }

    public boolean isChange(@NotNull ThreeSide side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "isChange"));
        }
        switch (side) {
            case LEFT: {
                return this.isChange(Side.LEFT);
            }
            case BASE: {
                return true;
            }
            case RIGHT: {
                return this.isChange(Side.RIGHT);
            }
        }
        throw new IllegalArgumentException(side.toString());
    }

    @NotNull
    private static ConflictType calcType(@NotNull MergeLineFragment fragment, @NotNull List<? extends EditorEx> editors, @NotNull ComparisonPolicy policy) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "calcType"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "calcType"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "calcType"));
        }
        boolean isLeftEmpty = ThreesideDiffChangeBase.isIntervalEmpty(fragment, ThreeSide.LEFT);
        boolean isBaseEmpty = ThreesideDiffChangeBase.isIntervalEmpty(fragment, ThreeSide.BASE);
        boolean isRightEmpty = ThreesideDiffChangeBase.isIntervalEmpty(fragment, ThreeSide.RIGHT);
        assert (!(isLeftEmpty && isBaseEmpty && isRightEmpty));
        if (isBaseEmpty) {
            if (isLeftEmpty) {
                ConflictType conflictType = new ConflictType(TextDiffType.INSERTED, false, true);
                if (conflictType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "calcType"));
                }
                return conflictType;
            }
            if (isRightEmpty) {
                ConflictType conflictType = new ConflictType(TextDiffType.INSERTED, true, false);
                if (conflictType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "calcType"));
                }
                return conflictType;
            }
            boolean equalModifications = ThreesideDiffChangeBase.compareLeftAndRight(fragment, editors, policy);
            ConflictType conflictType = new ConflictType(equalModifications ? TextDiffType.INSERTED : TextDiffType.CONFLICT);
            if (conflictType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "calcType"));
            }
            return conflictType;
        }
        if (isLeftEmpty && isRightEmpty) {
            ConflictType conflictType = new ConflictType(TextDiffType.DELETED);
            if (conflictType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "calcType"));
            }
            return conflictType;
        }
        boolean unchangedLeft = ThreesideDiffChangeBase.compareWithBase(fragment, editors, ThreeSide.LEFT);
        boolean unchangedRight = ThreesideDiffChangeBase.compareWithBase(fragment, editors, ThreeSide.RIGHT);
        assert (!unchangedLeft || !unchangedRight);
        if (unchangedLeft) {
            ConflictType conflictType = new ConflictType(isRightEmpty ? TextDiffType.DELETED : TextDiffType.MODIFIED, false, true);
            if (conflictType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "calcType"));
            }
            return conflictType;
        }
        if (unchangedRight) {
            ConflictType conflictType = new ConflictType(isLeftEmpty ? TextDiffType.DELETED : TextDiffType.MODIFIED, true, false);
            if (conflictType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "calcType"));
            }
            return conflictType;
        }
        boolean equalModifications = ThreesideDiffChangeBase.compareLeftAndRight(fragment, editors, policy);
        ConflictType conflictType = new ConflictType(equalModifications ? TextDiffType.MODIFIED : TextDiffType.CONFLICT);
        if (conflictType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "calcType"));
        }
        return conflictType;
    }

    private static boolean compareLeftAndRight(@NotNull MergeLineFragment fragment, @NotNull List<? extends EditorEx> editors, @NotNull ComparisonPolicy policy) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "compareLeftAndRight"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "compareLeftAndRight"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "compareLeftAndRight"));
        }
        CharSequence content1 = ThreesideDiffChangeBase.getRangeContent(fragment, editors, ThreeSide.LEFT);
        CharSequence content2 = ThreesideDiffChangeBase.getRangeContent(fragment, editors, ThreeSide.RIGHT);
        if (policy == ComparisonPolicy.IGNORE_WHITESPACES) {
            if (content1 == null) {
                content1 = "";
            }
            if (content2 == null) {
                content2 = "";
            }
        }
        if (content1 == null && content2 == null) {
            return true;
        }
        if (content1 == null ^ content2 == null) {
            return false;
        }
        return ComparisonManager.getInstance().isEquals(content1, content2, policy);
    }

    private static boolean compareWithBase(@NotNull MergeLineFragment fragment, @NotNull List<? extends EditorEx> editors, @NotNull ThreeSide side) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "compareWithBase"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "compareWithBase"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "compareWithBase"));
        }
        CharSequence content1 = ThreesideDiffChangeBase.getRangeContent(fragment, editors, ThreeSide.BASE);
        CharSequence content2 = ThreesideDiffChangeBase.getRangeContent(fragment, editors, side);
        return StringUtil.equals((CharSequence)content1, (CharSequence)content2);
    }

    @Nullable
    private static CharSequence getRangeContent(@NotNull MergeLineFragment fragment, @NotNull List<? extends EditorEx> editors, @NotNull ThreeSide side) {
        int line2;
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "getRangeContent"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "getRangeContent"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "getRangeContent"));
        }
        DocumentEx document = ((EditorEx)side.select(editors)).getDocument();
        int line1 = fragment.getStartLine(side);
        if (line1 == (line2 = fragment.getEndLine(side))) {
            return null;
        }
        return DiffUtil.getLinesContent(document, line1, line2);
    }

    private static boolean isIntervalEmpty(@NotNull MergeLineFragment fragment, @NotNull ThreeSide side) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "isIntervalEmpty"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "isIntervalEmpty"));
        }
        return fragment.getStartLine(side) == fragment.getEndLine(side);
    }

    public static class ConflictType {
        @NotNull
        private final TextDiffType myType;
        private final boolean myLeftChange;
        private final boolean myRightChange;

        public ConflictType(@NotNull TextDiffType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase$ConflictType", "<init>"));
            }
            this(type, true, true);
        }

        public ConflictType(@NotNull TextDiffType type, boolean leftChange, boolean rightChange) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase$ConflictType", "<init>"));
            }
            this.myType = type;
            this.myLeftChange = leftChange;
            this.myRightChange = rightChange;
        }

        @NotNull
        public TextDiffType getDiffType() {
            TextDiffType textDiffType = this.myType;
            if (textDiffType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase$ConflictType", "getDiffType"));
            }
            return textDiffType;
        }

        public boolean isLeftChange() {
            return this.myLeftChange;
        }

        public boolean isRightChange() {
            return this.myRightChange;
        }

        public boolean isChange(@NotNull Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase$ConflictType", "isChange"));
            }
            return side.isLeft() ? this.myLeftChange : this.myRightChange;
        }
    }
}

