/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.requests;

import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffContextEx;
import com.intellij.diff.requests.ComponentDiffRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.vcs.changes.issueLinks.LinkMouseListenerBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnknownFileTypeDiffRequest
extends ComponentDiffRequest {
    @Nullable
    private final String myFileName;
    @Nullable
    private final String myTitle;

    public UnknownFileTypeDiffRequest(@NotNull VirtualFile file2, @Nullable String title) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/requests/UnknownFileTypeDiffRequest", "<init>"));
        }
        this(file2.getName(), title);
    }

    public UnknownFileTypeDiffRequest(@NotNull String fileName, @Nullable String title) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/diff/requests/UnknownFileTypeDiffRequest", "<init>"));
        }
        boolean knownFileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName) != UnknownFileType.INSTANCE;
        this.myFileName = knownFileType ? null : fileName;
        this.myTitle = title;
    }

    @NotNull
    public JComponent getComponent(final @NotNull DiffContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/requests/UnknownFileTypeDiffRequest", "getComponent"));
        }
        SimpleColoredComponent label = new SimpleColoredComponent();
        label.append("Can't show diff for unknown file type. ", new SimpleTextAttributes(0, UIUtil.getInactiveTextColor()));
        if (this.myFileName != null) {
            label.append("Associate", SimpleTextAttributes.LINK_ATTRIBUTES, (Object)new Runnable(){

                @Override
                public void run() {
                    DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_BACKGROUND, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            FileType type = FileTypeChooser.associateFileType(UnknownFileTypeDiffRequest.this.myFileName);
                            if (type != null) {
                                UnknownFileTypeDiffRequest.this.onSuccess(context);
                            }
                        }
                    });
                }
            });
            LinkMouseListenerBase.installSingleTagOn(label);
        }
        JPanel jPanel = DiffUtil.createMessagePanel((JComponent)label);
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/requests/UnknownFileTypeDiffRequest", "getComponent"));
        }
        return jPanel;
    }

    @Nullable
    public String getFileName() {
        return this.myFileName;
    }

    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    protected void onSuccess(@NotNull DiffContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/requests/UnknownFileTypeDiffRequest", "onSuccess"));
        }
        if (context instanceof DiffContextEx) {
            ((DiffContextEx)context).reloadDiffRequest();
        }
    }
}

