/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.impl;

import com.intellij.diff.actions.impl.GoToChangePopupBuilder;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.LoadingDiffRequest;
import com.intellij.diff.requests.NoDiffRequest;
import com.intellij.diff.requests.OperationCanceledDiffRequest;
import com.intellij.diff.tools.util.SoftHardCacheMap;
import com.intellij.diff.util.DiffTaskQueue;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CacheDiffRequestChainProcessor
extends DiffRequestProcessor {
    private static final Logger LOG = Logger.getInstance(CacheDiffRequestChainProcessor.class);
    @NotNull
    private final DiffRequestChain myRequestChain;
    @NotNull
    private final SoftHardCacheMap<DiffRequestProducer, DiffRequest> myRequestCache;
    @NotNull
    private final DiffTaskQueue myQueue;

    public CacheDiffRequestChainProcessor(@Nullable Project project, @NotNull DiffRequestChain requestChain) {
        if (requestChain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestChain", "com/intellij/diff/impl/CacheDiffRequestChainProcessor", "<init>"));
        }
        super(project, (UserDataHolder)requestChain);
        this.myRequestCache = new SoftHardCacheMap(5, 5);
        this.myQueue = new DiffTaskQueue();
        this.myRequestChain = requestChain;
    }

    @Override
    protected void reloadRequest() {
        this.updateRequest(true, false, null);
    }

    @Override
    public void updateRequest(boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        this.updateRequest(force, true, scrollToChangePolicy);
    }

    public void updateRequest(final boolean force, boolean useCache, final @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        if (this.isDisposed()) {
            return;
        }
        List requests = this.myRequestChain.getRequests();
        int index = this.myRequestChain.getIndex();
        if (index < 0 || index >= requests.size()) {
            this.applyRequest((DiffRequest)NoDiffRequest.INSTANCE, force, scrollToChangePolicy);
            return;
        }
        final DiffRequestProducer producer = (DiffRequestProducer)requests.get(index);
        DiffRequest request = this.loadRequestFast(producer, useCache);
        if (request != null) {
            this.applyRequest(request, force, scrollToChangePolicy);
            return;
        }
        this.myQueue.executeAndTryWait(new Function<ProgressIndicator, Runnable>(){

            public Runnable fun(ProgressIndicator indicator) {
                final DiffRequest request = CacheDiffRequestChainProcessor.this.loadRequest(producer, indicator);
                return new Runnable(){

                    @Override
                    public void run() {
                        CacheDiffRequestChainProcessor.this.myRequestCache.put(producer, request);
                        CacheDiffRequestChainProcessor.this.applyRequest(request, force, scrollToChangePolicy);
                    }
                };
            }
        }, new Runnable(){

            @Override
            public void run() {
                CacheDiffRequestChainProcessor.this.applyRequest((DiffRequest)new LoadingDiffRequest(producer.getName()), force, scrollToChangePolicy);
            }
        }, 300);
    }

    @Nullable
    protected DiffRequest loadRequestFast(@NotNull DiffRequestProducer producer, boolean useCache) {
        if (producer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/diff/impl/CacheDiffRequestChainProcessor", "loadRequestFast"));
        }
        if (!useCache) {
            return null;
        }
        return this.myRequestCache.get(producer);
    }

    @NotNull
    private DiffRequest loadRequest(@NotNull DiffRequestProducer producer, @NotNull ProgressIndicator indicator) {
        DiffRequest diffRequest;
        if (producer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/diff/impl/CacheDiffRequestChainProcessor", "loadRequest"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/impl/CacheDiffRequestChainProcessor", "loadRequest"));
        }
        try {
            diffRequest = producer.process((UserDataHolder)this.getContext(), indicator);
        }
        catch (ProcessCanceledException e) {
            OperationCanceledDiffRequest request = new OperationCanceledDiffRequest(producer.getName());
            request.putUserData(DiffUserDataKeys.CONTEXT_ACTIONS, Collections.singletonList(new ReloadRequestAction(producer)));
            OperationCanceledDiffRequest operationCanceledDiffRequest = request;
            if (operationCanceledDiffRequest == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/CacheDiffRequestChainProcessor", "loadRequest"));
            }
            return operationCanceledDiffRequest;
        }
        catch (DiffRequestProducerException e) {
            ErrorDiffRequest errorDiffRequest = new ErrorDiffRequest(producer, (Throwable)e);
            if (errorDiffRequest == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/CacheDiffRequestChainProcessor", "loadRequest"));
            }
            return errorDiffRequest;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            ErrorDiffRequest errorDiffRequest = new ErrorDiffRequest(producer, (Throwable)e);
            if (errorDiffRequest == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/CacheDiffRequestChainProcessor", "loadRequest"));
            }
            return errorDiffRequest;
        }
        if (diffRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/CacheDiffRequestChainProcessor", "loadRequest"));
        }
        return diffRequest;
    }

    @Override
    protected void onDispose() {
        super.onDispose();
        this.myQueue.abort();
        this.myRequestCache.clear();
    }

    @Override
    @NotNull
    protected List<AnAction> getNavigationActions() {
        List list = ContainerUtil.list((Object[])new AnAction[]{new DiffRequestProcessor.MyPrevDifferenceAction(this), new DiffRequestProcessor.MyNextDifferenceAction(this), new DiffRequestProcessor.MyPrevChangeAction(this), new DiffRequestProcessor.MyNextChangeAction(this), this.createGoToChangeAction()});
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/CacheDiffRequestChainProcessor", "getNavigationActions"));
        }
        return list;
    }

    @NotNull
    public DiffRequestChain getRequestChain() {
        DiffRequestChain diffRequestChain = this.myRequestChain;
        if (diffRequestChain == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/CacheDiffRequestChainProcessor", "getRequestChain"));
        }
        return diffRequestChain;
    }

    @Override
    protected boolean hasNextChange() {
        return this.myRequestChain.getIndex() < this.myRequestChain.getRequests().size() - 1;
    }

    @Override
    protected boolean hasPrevChange() {
        return this.myRequestChain.getIndex() > 0;
    }

    @Override
    protected void goToNextChange(boolean fromDifferences) {
        this.myRequestChain.setIndex(this.myRequestChain.getIndex() + 1);
        this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE : null);
    }

    @Override
    protected void goToPrevChange(boolean fromDifferences) {
        this.myRequestChain.setIndex(this.myRequestChain.getIndex() - 1);
        this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.LAST_CHANGE : null);
    }

    @Override
    protected boolean isNavigationEnabled() {
        return this.myRequestChain.getRequests().size() > 1;
    }

    @NotNull
    private AnAction createGoToChangeAction() {
        AnAction anAction = GoToChangePopupBuilder.create(this.myRequestChain, new Consumer<Integer>(){

            public void consume(Integer index) {
                if (index >= 0 && index.intValue() != CacheDiffRequestChainProcessor.this.myRequestChain.getIndex()) {
                    CacheDiffRequestChainProcessor.this.myRequestChain.setIndex(index.intValue());
                    CacheDiffRequestChainProcessor.this.updateRequest();
                }
            }
        });
        if (anAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/CacheDiffRequestChainProcessor", "createGoToChangeAction"));
        }
        return anAction;
    }

    protected class ReloadRequestAction
    extends DumbAwareAction {
        @NotNull
        private final DiffRequestProducer myProducer;

        public ReloadRequestAction(DiffRequestProducer producer) {
            if (producer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/diff/impl/CacheDiffRequestChainProcessor$ReloadRequestAction", "<init>"));
            }
            super("Reload", null, AllIcons.Actions.Refresh);
            this.myProducer = producer;
        }

        public void actionPerformed(AnActionEvent e) {
            CacheDiffRequestChainProcessor.this.myRequestCache.remove(this.myProducer);
            CacheDiffRequestChainProcessor.this.updateRequest(true);
        }
    }
}

