/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison.iterables;

import com.intellij.diff.comparison.iterables.ChangeDiffIterableBase;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.util.Range;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

class SubiterableDiffIterable
extends ChangeDiffIterableBase {
    @NotNull
    private final DiffIterable myIterable;
    private final int myStart1;
    private final int myStart2;
    private final int myEnd1;
    private final int myEnd2;

    public SubiterableDiffIterable(@NotNull DiffIterable iterable, int start1, int end1, int start2, int end2) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/diff/comparison/iterables/SubiterableDiffIterable", "<init>"));
        }
        super(end1 - start1, end2 - start2);
        this.myIterable = iterable;
        this.myStart1 = start1;
        this.myStart2 = start2;
        this.myEnd1 = end1;
        this.myEnd2 = end2;
    }

    @Override
    @NotNull
    protected ChangeDiffIterableBase.ChangeIterable createChangeIterable() {
        SubiterableChangeIterable subiterableChangeIterable = new SubiterableChangeIterable();
        if (subiterableChangeIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/iterables/SubiterableDiffIterable", "createChangeIterable"));
        }
        return subiterableChangeIterable;
    }

    private class SubiterableChangeIterable
    implements ChangeDiffIterableBase.ChangeIterable {
        private final Iterator<Range> myIterator;
        private Range myLast;

        public SubiterableChangeIterable() {
            this.myIterator = SubiterableDiffIterable.this.myIterable.changes();
            this.next();
        }

        @Override
        public boolean valid() {
            return this.myLast != null;
        }

        @Override
        public void next() {
            this.myLast = null;
            while (this.myIterator.hasNext()) {
                Range range = this.myIterator.next();
                if (range.end1 < SubiterableDiffIterable.this.myStart1 || range.end2 < SubiterableDiffIterable.this.myStart2) continue;
                if (range.start1 > SubiterableDiffIterable.this.myEnd1 || range.start2 > SubiterableDiffIterable.this.myEnd2) break;
                this.myLast = new Range(Math.max(SubiterableDiffIterable.this.myStart1, range.start1) - SubiterableDiffIterable.this.myStart1, Math.min(SubiterableDiffIterable.this.myEnd1, range.end1) - SubiterableDiffIterable.this.myStart1, Math.max(SubiterableDiffIterable.this.myStart2, range.start2) - SubiterableDiffIterable.this.myStart2, Math.min(SubiterableDiffIterable.this.myEnd2, range.end2) - SubiterableDiffIterable.this.myStart2);
                if (!this.myLast.isEmpty()) break;
                this.myLast = null;
            }
        }

        @Override
        public int getStart1() {
            return this.myLast.start1;
        }

        @Override
        public int getStart2() {
            return this.myLast.start2;
        }

        @Override
        public int getEnd1() {
            return this.myLast.end1;
        }

        @Override
        public int getEnd2() {
            return this.myLast.end2;
        }
    }
}

