/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.VMOptions;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class OutOfMemoryDialog
extends DialogWrapper {
    private final MemoryKind myMemoryKind;
    private JPanel myContentPane;
    private JLabel myMessageLabel;
    private JTextField myHeapSizeField;
    private JTextField myPermGenSizeField;
    private JBLabel myHeapCurrentValueLabel;
    private JBLabel myPermGenCurrentValueLabel;
    private JLabel myHeapSizeLabel;
    private JLabel myPermGenSizeLabel;
    private JLabel myHeapUnitsLabel;
    private JLabel myPermGenUnitsLabel;
    private JBLabel mySettingsFileHintLabel;
    private JLabel myCodeCacheSizeLabel;
    private JTextField myCodeCacheSizeField;
    private JLabel myCodeCacheUnitsLabel;
    private JBLabel myCodeCacheCurrentValueLabel;
    private final Action myIgnoreAction;
    private final Action myShutdownAction;

    public OutOfMemoryDialog(MemoryKind memoryKind) {
        super(false);
        this.myMemoryKind = memoryKind;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(DiagnosticBundle.message("diagnostic.out.of.memory.title", objectArray));
        this.myMessageLabel.setIcon(Messages.getErrorIcon());
        this.myMessageLabel.setText(DiagnosticBundle.message("diagnostic.out.of.memory.error", memoryKind == MemoryKind.HEAP ? "Xmx" : (memoryKind == MemoryKind.PERM_GEN ? "XX:MaxPermSize" : "XX:ReservedCodeCacheSize"), ApplicationNamesInfo.getInstance().getProductName()));
        File file2 = VMOptions.getWriteFile();
        if (file2 != null) {
            this.mySettingsFileHintLabel.setText(DiagnosticBundle.message("diagnostic.out.of.memory.willBeSavedTo", file2.getPath()));
        } else {
            this.mySettingsFileHintLabel.setVisible(false);
        }
        this.myIgnoreAction = new AbstractAction(DiagnosticBundle.message("diagnostic.out.of.memory.ignore", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutOfMemoryDialog.this.save();
                OutOfMemoryDialog.this.close(0);
            }
        };
        this.myShutdownAction = new AbstractAction(DiagnosticBundle.message("diagnostic.out.of.memory.shutdown", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutOfMemoryDialog.this.save();
                System.exit(0);
            }
        };
        this.myShutdownAction.putValue("DefaultAction", true);
        OutOfMemoryDialog.configControls("Xmx", VMOptions.readXmx(), memoryKind == MemoryKind.HEAP, this.myHeapSizeLabel, this.myHeapSizeField, this.myHeapUnitsLabel, (JLabel)this.myHeapCurrentValueLabel);
        OutOfMemoryDialog.configControls("XX:MaxPermSize", VMOptions.readMaxPermGen(), memoryKind == MemoryKind.PERM_GEN, this.myPermGenSizeLabel, this.myPermGenSizeField, this.myPermGenUnitsLabel, (JLabel)this.myPermGenCurrentValueLabel);
        OutOfMemoryDialog.configControls("XX:ReservedCodeCacheSize", VMOptions.readCodeCache(), memoryKind == MemoryKind.CODE_CACHE, this.myCodeCacheSizeLabel, this.myCodeCacheSizeField, this.myCodeCacheUnitsLabel, (JLabel)this.myCodeCacheCurrentValueLabel);
        this.init();
    }

    private static void configControls(String optionName, int value, boolean highlight, JLabel sizeLabel, JTextField sizeField, JLabel unitsLabel, JLabel currentValueLabel) {
        sizeLabel.setText(optionName);
        String formatted = value == -1 ? DiagnosticBundle.message("diagnostic.out.of.memory.currentValue.unknown", new Object[0]) : String.valueOf(value);
        sizeField.setText(formatted);
        currentValueLabel.setText(DiagnosticBundle.message("diagnostic.out.of.memory.currentValue", formatted));
        if (highlight) {
            sizeLabel.setForeground((Color)JBColor.RED);
            sizeField.setForeground((Color)JBColor.RED);
            unitsLabel.setForeground((Color)JBColor.RED);
            currentValueLabel.setForeground((Color)JBColor.RED);
        }
    }

    private void save() {
        try {
            VMOptions.writeXmx(Integer.parseInt(this.myHeapSizeField.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            VMOptions.writeMaxPermGen(Integer.parseInt(this.myPermGenSizeField.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            VMOptions.writeCodeCache(Integer.parseInt(this.myCodeCacheSizeField.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected JComponent createCenterPanel() {
        return this.myContentPane;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.myShutdownAction, this.myIgnoreAction};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/OutOfMemoryDialog", "createActions"));
        }
        return actionArray;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myMemoryKind == MemoryKind.HEAP ? this.myHeapSizeField : (this.myMemoryKind == MemoryKind.PERM_GEN ? this.myPermGenSizeField : this.myCodeCacheSizeField);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JLabel jLabel;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JBLabel jBLabel4;
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JLabel jLabel2;
        JLabel jLabel3;
        JLabel jLabel4;
        JLabel jLabel5;
        JLabel jLabel6;
        JLabel jLabel7;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 6, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myHeapSizeLabel = jLabel7 = new JLabel();
        jLabel7.setText("Label");
        jPanel.add((Component)jLabel7, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPermGenSizeLabel = jLabel6 = new JLabel();
        jLabel6.setText("Label");
        jPanel.add((Component)jLabel6, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCodeCacheSizeLabel = jLabel5 = new JLabel();
        jLabel5.setText("Label");
        jPanel.add((Component)jLabel5, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHeapUnitsLabel = jLabel4 = new JLabel();
        jLabel4.setText("MB");
        jPanel.add((Component)jLabel4, new GridConstraints(1, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPermGenUnitsLabel = jLabel3 = new JLabel();
        jLabel3.setText("MB");
        jPanel.add((Component)jLabel3, new GridConstraints(2, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCodeCacheUnitsLabel = jLabel2 = new JLabel();
        jLabel2.setText("MB");
        jPanel.add((Component)jLabel2, new GridConstraints(3, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHeapSizeField = jTextField3 = new JTextField();
        jTextField3.setColumns(6);
        jPanel.add((Component)jTextField3, new GridConstraints(1, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myPermGenSizeField = jTextField2 = new JTextField();
        jTextField2.setColumns(6);
        jPanel.add((Component)jTextField2, new GridConstraints(2, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myCodeCacheSizeField = jTextField = new JTextField();
        jTextField.setColumns(6);
        jPanel.add((Component)jTextField, new GridConstraints(3, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 5, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myHeapCurrentValueLabel = jBLabel4 = new JBLabel();
        jBLabel4.setText("Label");
        Font font = jBLabel4.getFont();
        jBLabel4.setFont(new Font(font.getName(), 2, font.getSize()));
        jPanel.add((Component)jBLabel4, new GridConstraints(1, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPermGenCurrentValueLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Label");
        Font font2 = jBLabel3.getFont();
        jBLabel3.setFont(new Font(font2.getName(), 2, font2.getSize()));
        jPanel.add((Component)jBLabel3, new GridConstraints(2, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCodeCacheCurrentValueLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Label");
        Font font3 = jBLabel2.getFont();
        jBLabel2.setFont(new Font(font3.getName(), 2, font3.getSize()));
        jPanel.add((Component)jBLabel2, new GridConstraints(3, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 1, 6, 1, null, new Dimension(51, 11), null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, new Dimension(51, 14), null));
        this.myMessageLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 6, 8, 0, 0, 0, null, null, null));
        this.mySettingsFileHintLabel = jBLabel = new JBLabel();
        jBLabel.setText("Label");
        jPanel.add((Component)jBLabel, new GridConstraints(4, 0, 1, 6, 4, 0, 0, 0, null, null, null));
        jLabel7.setLabelFor(jTextField3);
        jLabel6.setLabelFor(jTextField2);
        jLabel5.setLabelFor(jTextField2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    public static enum MemoryKind {
        HEAP,
        PERM_GEN,
        CODE_CACHE;

    }
}

