/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.tools;

import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.tools.TargetingTool;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.utils.Cursors;
import java.awt.Dimension;
import java.awt.event.KeyEvent;

public abstract class AbstractCreationTool
extends TargetingTool {
    private boolean myCanUnload;

    protected AbstractCreationTool(boolean canUnload) {
        this.myCanUnload = canUnload;
        this.setDefaultCursor(Cursors.getCopyCursor());
        this.setDisabledCursor(Cursors.getNoCursor());
    }

    @Override
    protected void handleButtonDown(int button) {
        if (button == 1) {
            if (this.myState == 1) {
                this.myState = 2;
            }
        } else {
            this.myState = 4;
            this.handleInvalidInput();
        }
    }

    @Override
    protected void handleButtonUp(int button) {
        if (this.myState == 2 || this.myState == 3) {
            this.eraseFeedback();
            this.executeCommand();
            this.selectAddedObjects();
        }
        this.myState = 0;
        this.handleFinished();
    }

    @Override
    protected void handleMove() {
        this.updateContext();
        this.updateTargetUnderMouse();
        this.showFeedback();
        this.updateCommand();
    }

    @Override
    protected void handleDragInProgress() {
        if (this.myState == 3) {
            this.updateContext();
            this.showFeedback();
            this.updateCommand();
        }
    }

    private void selectAddedObjects() {
        if (this.myExecuteEnabled) {
            this.myArea.setSelection(this.myContext.getComponents());
        }
    }

    @Override
    protected void resetState() {
        if (this.myCanUnload || this.myArea == null) {
            super.resetState();
        }
    }

    private void handleFinished() {
        if (this.myCanUnload) {
            this.myToolProvider.loadDefaultTool();
        } else {
            this.deactivate();
            this.activate();
            if (this.myArea != null) {
                this.handleMove();
            }
        }
    }

    private void updateTargetUnderMouse() {
        TargetingTool.ContainerTargetFilter filter = new TargetingTool.ContainerTargetFilter(this);
        RadComponent target = this.myArea.findTarget(this.myCurrentScreenX, this.myCurrentScreenY, filter);
        this.setTarget(target, filter);
        if (target != null) {
            this.updateTarget();
        }
    }

    protected abstract void updateTarget();

    @Override
    protected void updateContext() {
        super.updateContext();
        if (this.myState == 3) {
            this.myContext.setSizeDelta(new Dimension(this.moveDeltaWidth(), this.moveDeltaHeight()));
        }
        this.myContext.setLocation(this.getLocation());
    }

    @Override
    public void keyPressed(KeyEvent event, EditableArea area) throws Exception {
        super.keyPressed(event, area);
        if (event.getKeyCode() == 27) {
            this.myToolProvider.loadDefaultTool();
        }
    }

    @Override
    protected void handleKeyEvent() {
    }
}

