/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.actions;

import com.intellij.designer.DesignerToolWindowManager;
import com.intellij.designer.actions.CommonEditActionsProvider;
import com.intellij.designer.actions.DeselectAllAction;
import com.intellij.designer.actions.MorphingAction;
import com.intellij.designer.actions.SelectAllAction;
import com.intellij.designer.actions.SelectSameTypeAction;
import com.intellij.designer.actions.SelectSiblingsAction;
import com.intellij.designer.actions.StartInplaceEditing;
import com.intellij.designer.actions.WrapInAction;
import com.intellij.designer.designSurface.ComponentSelectionListener;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.propertyTable.RadPropertyTable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DesignerActionPanel
implements DataProvider {
    public static final String TOOLBAR = "DesignerToolbar";
    private final DefaultActionGroup myActionGroup;
    private final DefaultActionGroup myStaticGroup = new DefaultActionGroup();
    private final DefaultActionGroup myDynamicGroup = new DefaultActionGroup();
    private final DefaultActionGroup myPopupGroup = new DefaultActionGroup();
    private final DefaultActionGroup myDynamicPopupGroup = new DefaultActionGroup();
    protected final JComponent myToolbar;
    protected final DesignerEditorPanel myDesigner;
    private final CommonEditActionsProvider myCommonEditActionsProvider;
    private final JComponent myShortcuts;

    public DesignerActionPanel(DesignerEditorPanel designer, JComponent shortcuts) {
        this.myDesigner = designer;
        this.myCommonEditActionsProvider = new CommonEditActionsProvider(designer);
        this.myShortcuts = shortcuts;
        DesignerActionPanel.createInplaceEditingAction(this.myShortcuts).setDesignerPanel(designer);
        this.myActionGroup = this.createActionGroup();
        this.myToolbar = this.createToolbar();
        ActionManager actionManager = ActionManager.getInstance();
        this.myPopupGroup.add(actionManager.getAction("$Cut"));
        this.myPopupGroup.add(actionManager.getAction("$Copy"));
        this.myPopupGroup.add(actionManager.getAction("$Paste"));
        this.myPopupGroup.addSeparator();
        this.myPopupGroup.add(actionManager.getAction("$Delete"));
        this.myPopupGroup.addSeparator();
        this.myPopupGroup.add((AnAction)this.createSelectActionGroup(designer));
        this.myPopupGroup.addSeparator();
        this.myPopupGroup.add((AnAction)this.myDynamicPopupGroup);
        designer.getSurfaceArea().addSelectionListener(new ComponentSelectionListener(){

            @Override
            public void selectionChanged(EditableArea area) {
                DesignerActionPanel.this.updateSelectionActions(area.getSelection());
            }
        });
    }

    protected DefaultActionGroup createActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)this.myStaticGroup);
        group.add((AnAction)this.myDynamicGroup);
        return group;
    }

    protected JComponent createToolbar() {
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar actionToolbar = actionManager.createActionToolbar(TOOLBAR, (ActionGroup)this.myActionGroup, true);
        actionToolbar.setLayoutPolicy(1);
        JComponent toolbar = actionToolbar.getComponent();
        toolbar.setBorder(IdeBorderFactory.createBorder((int)8));
        toolbar.setVisible(false);
        return toolbar;
    }

    @NotNull
    private ActionGroup createSelectActionGroup(DesignerEditorPanel designer) {
        DefaultActionGroup group = new DefaultActionGroup("_Select", true);
        AnAction selectParent = new AnAction("Select Parent", "Select Parent", null){

            public void actionPerformed(AnActionEvent e) {
                DesignerActionPanel.this.myDesigner.getToolProvider().processKeyEvent(new KeyEvent(DesignerActionPanel.this.myDesigner.getSurfaceArea().getNativeComponent(), 401, 0L, 0, 27, '\u001b'), DesignerActionPanel.this.myDesigner.getSurfaceArea());
            }
        };
        selectParent.registerCustomShortcutSet(27, 0, null);
        EditableArea area = designer.getSurfaceArea();
        SelectSiblingsAction selectSiblings = new SelectSiblingsAction(area);
        SelectSameTypeAction selectSameType = new SelectSameTypeAction(area);
        DeselectAllAction deselectAllAction = new DeselectAllAction(area);
        AnAction selectAllAction = this.createSelectAllAction(area);
        this.registerAction(selectAllAction, "$SelectAll");
        group.add(selectParent);
        group.add((AnAction)selectSiblings);
        group.add((AnAction)selectSameType);
        group.addSeparator();
        group.add(selectAllAction);
        group.add((AnAction)deselectAllAction);
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/actions/DesignerActionPanel", "createSelectActionGroup"));
        }
        return defaultActionGroup;
    }

    public AnAction createSelectAllAction(EditableArea area) {
        return new SelectAllAction(area);
    }

    public static StartInplaceEditing createInplaceEditingAction(JComponent shortcuts) {
        StartInplaceEditing action = new StartInplaceEditing();
        action.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(113, 0)), shortcuts);
        return action;
    }

    public void registerAction(AnAction action, @NonNls String actionId) {
        action.registerCustomShortcutSet(ActionManager.getInstance().getAction(actionId).getShortcutSet(), this.myShortcuts);
    }

    public JComponent getToolbarComponent() {
        return this.myToolbar;
    }

    public DefaultActionGroup getActionGroup() {
        return this.myStaticGroup;
    }

    public DefaultActionGroup getPopupGroup() {
        return this.myPopupGroup;
    }

    protected DefaultActionGroup getDynamicActionGroup() {
        return this.myDynamicGroup;
    }

    protected JComponent getShortcuts() {
        return this.myShortcuts;
    }

    public void update() {
        boolean oldVisible = this.myToolbar.isVisible();
        boolean newVisible = DesignerActionPanel.isVisible(this.myActionGroup);
        this.myToolbar.setVisible(newVisible);
        if (oldVisible && newVisible) {
            ((JComponent)this.myToolbar.getParent()).revalidate();
        }
    }

    private static boolean isVisible(DefaultActionGroup group) {
        if (group.getChildrenCount() == 0) {
            return false;
        }
        for (AnAction action : group.getChildren(null)) {
            if (action instanceof DefaultActionGroup) {
                if (!DesignerActionPanel.isVisible((DefaultActionGroup)action)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private void updateSelectionActions(List<RadComponent> selection) {
        boolean oldVisible = DesignerActionPanel.isVisible(this.myDynamicGroup);
        if (this.myDynamicGroup.getChildrenCount() > 0) {
            for (AnAction action : this.myDynamicGroup.getChildActionsOrStubs()) {
                action.unregisterCustomShortcutSet(this.myShortcuts);
            }
            this.myDynamicGroup.removeAll();
        }
        this.addSelectionActions(selection, this.myDynamicGroup);
        if (oldVisible || DesignerActionPanel.isVisible(this.myDynamicGroup)) {
            this.update();
        }
    }

    protected void addSelectionActions(List<RadComponent> selection, DefaultActionGroup group) {
        for (RadComponent parent : RadComponent.getParents(selection)) {
            parent.getLayout().addSelectionActions(this.myDesigner, group, this.myShortcuts, selection);
        }
        for (RadComponent component : selection) {
            component.addSelectionActions(this.myDesigner, group, this.myShortcuts, selection);
        }
    }

    public ActionGroup getPopupActions(EditableArea area) {
        if (this.myDynamicPopupGroup.getChildrenCount() > 0) {
            this.myDynamicPopupGroup.removeAll();
        }
        WrapInAction.fill(this.myDesigner, this.myDynamicPopupGroup, area);
        MorphingAction.fill(this.myDesigner, this.myDynamicPopupGroup, area);
        return this.myPopupGroup;
    }

    public Object getData(@NonNls String dataId) {
        Component focusOwner;
        RadPropertyTable table;
        if ((PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) || PlatformDataKeys.CUT_PROVIDER.is(dataId) || PlatformDataKeys.COPY_PROVIDER.is(dataId) || PlatformDataKeys.PASTE_PROVIDER.is(dataId)) && !UIUtil.isAncestor((Component)((Object)(table = DesignerToolWindowManager.getInstance(this.myDesigner).getPropertyTable())), (Component)(focusOwner = IdeFocusManager.getInstance((Project)this.myDesigner.getProject()).getFocusOwner()))) {
            return this.myCommonEditActionsProvider;
        }
        return null;
    }
}

