/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactoryContextWrapper;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.reference.SoftReference;

public abstract class CachedEvaluator {
    private final CodeFragmentFactory myDefaultFragmentFactory;
    SoftReference<Cache> myCache = new SoftReference(null);
    private TextWithImports myReferenceExpression;

    public CachedEvaluator() {
        this.myDefaultFragmentFactory = new CodeFragmentFactoryContextWrapper(DefaultCodeFragmentFactory.getInstance());
    }

    protected abstract String getClassName();

    public TextWithImports getReferenceExpression() {
        return this.myReferenceExpression != null ? this.myReferenceExpression : DebuggerUtils.getInstance().createExpressionWithImports("");
    }

    public void setReferenceExpression(TextWithImports referenceExpression) {
        this.myReferenceExpression = referenceExpression;
        this.clear();
    }

    public void clear() {
        this.myCache.clear();
    }

    protected Cache initEvaluatorAndChildrenExpression(Project project) {
        Cache cache = new Cache();
        try {
            PsiClass contextClass = DebuggerUtils.findClass((String)this.getClassName(), (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
            if (contextClass == null) {
                throw EvaluateExceptionUtil.CANNOT_FIND_SOURCE_CLASS;
            }
            PsiType contextType = DebuggerUtils.getType((String)this.getClassName(), (Project)project);
            cache.myPsiChildrenExpression = null;
            JavaCodeFragment codeFragment = this.myDefaultFragmentFactory.createCodeFragment(this.myReferenceExpression, (PsiElement)contextClass, project);
            codeFragment.forceResolveScope(GlobalSearchScope.allScope((Project)project));
            codeFragment.setThisType(contextType);
            DebuggerUtils.checkSyntax((PsiCodeFragment)codeFragment);
            cache.myPsiChildrenExpression = ((PsiExpressionCodeFragment)codeFragment).getExpression();
            cache.myEvaluator = this.myDefaultFragmentFactory.getEvaluatorBuilder().build((PsiElement)cache.myPsiChildrenExpression, null);
        }
        catch (EvaluateException e) {
            cache.myException = e;
        }
        this.myCache = new SoftReference((Object)cache);
        return cache;
    }

    protected ExpressionEvaluator getEvaluator(final Project project) throws EvaluateException {
        Cache cache = (Cache)this.myCache.get();
        if (cache == null) {
            cache = (Cache)PsiDocumentManager.getInstance((Project)project).commitAndRunReadAction((Computable)new Computable<Cache>(){

                public Cache compute() {
                    return CachedEvaluator.this.initEvaluatorAndChildrenExpression(project);
                }
            });
        }
        if (cache.myException != null) {
            throw cache.myException;
        }
        return cache.myEvaluator;
    }

    protected PsiExpression getPsiExpression(Project project) {
        Cache cache = (Cache)this.myCache.get();
        if (cache == null) {
            cache = this.initEvaluatorAndChildrenExpression(project);
        }
        return cache.myPsiChildrenExpression;
    }

    private static class Cache {
        protected ExpressionEvaluator myEvaluator;
        protected EvaluateException myException;
        protected PsiExpression myPsiChildrenExpression;

        private Cache() {
        }
    }
}

