/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationListener;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.JvmSteppingCommandProvider;
import com.intellij.debugger.impl.SimpleStackFrameContext;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteState;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.idea.ActionsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.unscramble.ThreadState;
import com.intellij.util.Alarm;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.AbstractDebuggerSession;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueLookupManager;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ThreadReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerSession
implements AbstractDebuggerSession {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.impl.DebuggerSession");
    private final MyDebuggerStateManager myContextManager;
    private volatile boolean myIsEvaluating;
    private volatile int myIgnoreFiltersFrameCountThreshold;
    private DebuggerSessionState myState;
    private final String mySessionName;
    private final DebugProcessImpl myDebugProcess;
    private final GlobalSearchScope mySearchScope;
    private final DebuggerContextImpl SESSION_EMPTY_CONTEXT;
    private final AtomicReference<ThreadReferenceProxyImpl> mySteppingThroughThread;
    protected final Alarm myUpdateAlarm;
    private boolean myModifiedClassesScanRequired;

    public boolean isSteppingThrough(ThreadReferenceProxyImpl threadProxy) {
        return Comparing.equal((Object)this.mySteppingThroughThread.get(), (Object)threadProxy);
    }

    public void setSteppingThrough(ThreadReferenceProxyImpl threadProxy) {
        this.mySteppingThroughThread.set(threadProxy);
    }

    public void clearSteppingThrough() {
        this.mySteppingThroughThread.set(null);
    }

    @NotNull
    public GlobalSearchScope getSearchScope() {
        GlobalSearchScope globalSearchScope = this.mySearchScope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/DebuggerSession", "getSearchScope"));
        }
        return globalSearchScope;
    }

    public boolean isModifiedClassesScanRequired() {
        return this.myModifiedClassesScanRequired;
    }

    public void setModifiedClassesScanRequired(boolean modifiedClassesScanRequired) {
        this.myModifiedClassesScanRequired = modifiedClassesScanRequired;
    }

    static DebuggerSession create(String sessionName, @NotNull DebugProcessImpl debugProcess, DebugEnvironment environment) throws ExecutionException {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/impl/DebuggerSession", "create"));
        }
        DebuggerSession session = new DebuggerSession(sessionName, debugProcess, environment);
        try {
            session.attach(environment);
        }
        catch (ExecutionException e) {
            session.dispose();
            throw e;
        }
        return session;
    }

    private DebuggerSession(String sessionName, @NotNull DebugProcessImpl debugProcess, DebugEnvironment environment) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/impl/DebuggerSession", "<init>"));
        }
        this.myIgnoreFiltersFrameCountThreshold = 0;
        this.myState = null;
        this.mySteppingThroughThread = new AtomicReference();
        this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myModifiedClassesScanRequired = false;
        this.mySessionName = sessionName;
        this.myDebugProcess = debugProcess;
        this.SESSION_EMPTY_CONTEXT = DebuggerContextImpl.createDebuggerContext(this, null, null, null);
        this.myContextManager = new MyDebuggerStateManager();
        this.myState = new DebuggerSessionState(State.STOPPED, null);
        this.myDebugProcess.addDebugProcessListener(new MyDebugProcessListener(debugProcess));
        this.myDebugProcess.addEvaluationListener(new MyEvaluationListener());
        ValueLookupManager.getInstance(this.getProject()).startListening();
        this.mySearchScope = environment.getSearchScope();
    }

    @NotNull
    public DebuggerStateManager getContextManager() {
        MyDebuggerStateManager myDebuggerStateManager = this.myContextManager;
        if (myDebuggerStateManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/DebuggerSession", "getContextManager"));
        }
        return myDebuggerStateManager;
    }

    public Project getProject() {
        return this.getProcess().getProject();
    }

    public String getSessionName() {
        return this.mySessionName;
    }

    @NotNull
    public DebugProcessImpl getProcess() {
        DebugProcessImpl debugProcessImpl = this.myDebugProcess;
        if (debugProcessImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/DebuggerSession", "getProcess"));
        }
        return debugProcessImpl;
    }

    public State getState() {
        return this.myState.myState;
    }

    public String getStateDescription() {
        if (this.myState.myDescription != null) {
            return this.myState.myDescription;
        }
        switch (this.myState.myState) {
            case STOPPED: {
                return DebuggerBundle.message((String)"status.debug.stopped", (Object[])new Object[0]);
            }
            case RUNNING: {
                return DebuggerBundle.message((String)"status.app.running", (Object[])new Object[0]);
            }
            case WAITING_ATTACH: {
                RemoteConnection connection = this.getProcess().getConnection();
                String addressDisplayName = DebuggerBundle.getAddressDisplayName((RemoteConnection)connection);
                String transportName = DebuggerBundle.getTransportName((RemoteConnection)connection);
                return connection.isServerMode() ? DebuggerBundle.message((String)"status.listening", (Object[])new Object[]{addressDisplayName, transportName}) : DebuggerBundle.message((String)"status.connecting", (Object[])new Object[]{addressDisplayName, transportName});
            }
            case PAUSED: {
                return DebuggerBundle.message((String)"status.paused", (Object[])new Object[0]);
            }
            case WAIT_EVALUATION: {
                return DebuggerBundle.message((String)"status.waiting.evaluation.result", (Object[])new Object[0]);
            }
            case DISPOSED: {
                return DebuggerBundle.message((String)"status.debug.stopped", (Object[])new Object[0]);
            }
        }
        return null;
    }

    private void resumeAction(DebugProcessImpl.ResumeCommand command, Event event) {
        this.getContextManager().setState(this.SESSION_EMPTY_CONTEXT, State.WAIT_EVALUATION, event, null);
        this.myDebugProcess.getManagerThread().schedule(command);
    }

    public void stepOut(int stepSize) {
        JvmSteppingCommandProvider handler2;
        SuspendContextImpl suspendContext = this.getSuspendContext();
        DebugProcessImpl.ResumeCommand cmd = null;
        JvmSteppingCommandProvider[] jvmSteppingCommandProviderArray = (JvmSteppingCommandProvider[])JvmSteppingCommandProvider.EP_NAME.getExtensions();
        int n = jvmSteppingCommandProviderArray.length;
        for (int i = 0; i < n && (cmd = (handler2 = jvmSteppingCommandProviderArray[i]).getStepOutCommand(suspendContext, stepSize)) == null; ++i) {
        }
        if (cmd == null) {
            cmd = this.myDebugProcess.createStepOutCommand(suspendContext, stepSize);
        }
        this.setSteppingThrough(cmd.getContextThread());
        this.resumeAction(cmd, Event.STEP);
    }

    public void stepOut() {
        this.stepOut(-2);
    }

    public void stepOver(boolean ignoreBreakpoints, int stepSize) {
        JvmSteppingCommandProvider handler2;
        SuspendContextImpl suspendContext = this.getSuspendContext();
        DebugProcessImpl.ResumeCommand cmd = null;
        JvmSteppingCommandProvider[] jvmSteppingCommandProviderArray = (JvmSteppingCommandProvider[])JvmSteppingCommandProvider.EP_NAME.getExtensions();
        int n = jvmSteppingCommandProviderArray.length;
        for (int i = 0; i < n && (cmd = (handler2 = jvmSteppingCommandProviderArray[i]).getStepOverCommand(suspendContext, ignoreBreakpoints, stepSize)) == null; ++i) {
        }
        if (cmd == null) {
            cmd = this.myDebugProcess.createStepOverCommand(suspendContext, ignoreBreakpoints, stepSize);
        }
        this.setSteppingThrough(cmd.getContextThread());
        this.resumeAction(cmd, Event.STEP);
    }

    public void stepOver(boolean ignoreBreakpoints) {
        this.stepOver(ignoreBreakpoints, -2);
    }

    public void stepInto(boolean ignoreFilters, @Nullable MethodFilter smartStepFilter, int stepSize) {
        JvmSteppingCommandProvider handler2;
        SuspendContextImpl suspendContext = this.getSuspendContext();
        DebugProcessImpl.ResumeCommand cmd = null;
        JvmSteppingCommandProvider[] jvmSteppingCommandProviderArray = (JvmSteppingCommandProvider[])JvmSteppingCommandProvider.EP_NAME.getExtensions();
        int n = jvmSteppingCommandProviderArray.length;
        for (int i = 0; i < n && (cmd = (handler2 = jvmSteppingCommandProviderArray[i]).getStepIntoCommand(suspendContext, ignoreFilters, smartStepFilter, stepSize)) == null; ++i) {
        }
        if (cmd == null) {
            cmd = this.myDebugProcess.createStepIntoCommand(suspendContext, ignoreFilters, smartStepFilter, stepSize);
        }
        this.setSteppingThrough(cmd.getContextThread());
        this.resumeAction(cmd, Event.STEP);
    }

    public void stepInto(boolean ignoreFilters, @Nullable MethodFilter smartStepFilter) {
        this.stepInto(ignoreFilters, smartStepFilter, -2);
    }

    public void runToCursor(@NotNull XSourcePosition position, boolean ignoreBreakpoints) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/impl/DebuggerSession", "runToCursor"));
        }
        try {
            DebugProcessImpl.ResumeCommand runToCursorCommand = this.myDebugProcess.createRunToCursorCommand(this.getSuspendContext(), position, ignoreBreakpoints);
            this.setSteppingThrough(runToCursorCommand.getContextThread());
            this.resumeAction(runToCursorCommand, Event.STEP);
        }
        catch (EvaluateException e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"RunToCursor")));
        }
    }

    public void resume() {
        SuspendContextImpl suspendContext = this.getSuspendContext();
        if (suspendContext != null) {
            this.clearSteppingThrough();
            this.resetIgnoreStepFiltersFlag();
            this.resumeAction(this.myDebugProcess.createResumeCommand(suspendContext), Event.RESUME);
        }
    }

    public void resetIgnoreStepFiltersFlag() {
        this.myIgnoreFiltersFrameCountThreshold = 0;
    }

    public void setIgnoreStepFiltersFlag(int currentStackFrameCount) {
        this.myIgnoreFiltersFrameCountThreshold = this.myIgnoreFiltersFrameCountThreshold <= 0 ? currentStackFrameCount : Math.min(this.myIgnoreFiltersFrameCountThreshold, currentStackFrameCount);
    }

    public boolean shouldIgnoreSteppingFilters() {
        return this.myIgnoreFiltersFrameCountThreshold > 0;
    }

    public void pause() {
        this.myDebugProcess.getManagerThread().schedule(this.myDebugProcess.createPauseCommand());
    }

    public void showExecutionPoint() {
        this.getContextManager().setState(DebuggerContextUtil.createDebuggerContext(this, this.getSuspendContext()), State.PAUSED, Event.REFRESH, null);
    }

    public void refresh(boolean refreshViewsOnly) {
        State state = this.getState();
        DebuggerContextImpl context = this.myContextManager.getContext();
        DebuggerContextImpl newContext = DebuggerContextImpl.createDebuggerContext(this, context.getSuspendContext(), context.getThreadProxy(), context.getFrameProxy());
        this.myContextManager.setState(newContext, state, refreshViewsOnly ? Event.REFRESH_VIEWS_ONLY : Event.REFRESH, null);
    }

    public void dispose() {
        this.getProcess().dispose();
        Disposer.dispose((Disposable)this.myUpdateAlarm);
        DebuggerInvocationUtil.invokeLater(this.getProject(), new Runnable(){

            @Override
            public void run() {
                DebuggerSession.this.getContextManager().setState(DebuggerSession.this.SESSION_EMPTY_CONTEXT, State.DISPOSED, Event.DISPOSE, null);
            }
        });
    }

    public boolean isStopped() {
        return this.getState() == State.STOPPED;
    }

    public boolean isAttached() {
        return !this.isStopped() && this.getState() != State.WAITING_ATTACH;
    }

    public boolean isPaused() {
        return this.getState() == State.PAUSED;
    }

    public boolean isConnecting() {
        return this.getState() == State.WAITING_ATTACH;
    }

    public boolean isEvaluating() {
        return this.myIsEvaluating;
    }

    public boolean isRunning() {
        return this.getState() == State.RUNNING && !this.getProcess().getProcessHandler().isProcessTerminated();
    }

    private SuspendContextImpl getSuspendContext() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.getContextManager().getContext().getSuspendContext();
    }

    @Nullable
    private ExecutionResult attach(DebugEnvironment environment) throws ExecutionException {
        RemoteConnection remoteConnection = environment.getRemoteConnection();
        String addressDisplayName = DebuggerBundle.getAddressDisplayName((RemoteConnection)remoteConnection);
        String transportName = DebuggerBundle.getTransportName((RemoteConnection)remoteConnection);
        ExecutionResult executionResult = this.myDebugProcess.attachVirtualMachine(environment, this);
        this.getContextManager().setState(this.SESSION_EMPTY_CONTEXT, State.WAITING_ATTACH, Event.START_WAIT_ATTACH, DebuggerBundle.message((String)"status.waiting.attach", (Object[])new Object[]{addressDisplayName, transportName}));
        return executionResult;
    }

    private static String getDescription(DebuggerContextImpl debuggerContext) {
        SuspendContextImpl suspendContext = debuggerContext.getSuspendContext();
        if (suspendContext != null && debuggerContext.getThreadProxy() != suspendContext.getThread()) {
            return DebuggerBundle.message((String)"status.paused.in.another.thread", (Object[])new Object[0]);
        }
        return null;
    }

    public static boolean enableBreakpointsDuringEvaluation() {
        return Registry.is((String)"debugger.enable.breakpoints.during.evaluation");
    }

    public void sessionResumed() {
        XDebugSession session = this.getXDebugSession();
        if (session != null) {
            session.sessionResumed();
        }
    }

    @Nullable
    public XDebugSession getXDebugSession() {
        JavaDebugProcess process = this.myDebugProcess.getXdebugProcess();
        return process != null ? process.getSession() : null;
    }

    private class MyEvaluationListener
    implements EvaluationListener {
        private MyEvaluationListener() {
        }

        @Override
        public void evaluationStarted(SuspendContextImpl context) {
            DebuggerSession.this.myIsEvaluating = true;
        }

        @Override
        public void evaluationFinished(SuspendContextImpl context) {
            DebuggerSession.this.myIsEvaluating = false;
        }
    }

    private class MyDebugProcessListener
    extends DebugProcessAdapterImpl {
        private final DebugProcessImpl myDebugProcess;

        public MyDebugProcessListener(DebugProcessImpl debugProcess) {
            this.myDebugProcess = debugProcess;
        }

        @Override
        public void connectorIsReady() {
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), new Runnable(){

                @Override
                public void run() {
                    RemoteConnection connection = MyDebugProcessListener.this.myDebugProcess.getConnection();
                    String addressDisplayName = DebuggerBundle.getAddressDisplayName((RemoteConnection)connection);
                    String transportName = DebuggerBundle.getTransportName((RemoteConnection)connection);
                    String connectionStatusMessage = connection.isServerMode() ? DebuggerBundle.message((String)"status.listening", (Object[])new Object[]{addressDisplayName, transportName}) : DebuggerBundle.message((String)"status.connecting", (Object[])new Object[]{addressDisplayName, transportName});
                    DebuggerSession.this.getContextManager().setState(DebuggerSession.this.SESSION_EMPTY_CONTEXT, State.WAITING_ATTACH, Event.START_WAIT_ATTACH, connectionStatusMessage);
                }
            });
        }

        @Override
        public void paused(final SuspendContextImpl suspendContext) {
            SourcePosition position;
            Object positionContext;
            if (LOG.isDebugEnabled()) {
                LOG.debug("paused");
            }
            ThreadReferenceProxyImpl currentThread = suspendContext.getThread();
            if (!this.shouldSetAsActiveContext(suspendContext)) {
                List<Pair<Breakpoint, com.sun.jdi.event.Event>> descriptors;
                DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), new Runnable(){

                    @Override
                    public void run() {
                        DebuggerSession.this.getContextManager().fireStateChanged(DebuggerSession.this.getContextManager().getContext(), Event.THREADS_REFRESH);
                    }
                });
                ThreadReferenceProxyImpl thread = suspendContext.getThread();
                if (thread != null && !(descriptors = DebuggerUtilsEx.getEventDescriptors(suspendContext)).isEmpty()) {
                    XDebugSessionImpl.NOTIFICATION_GROUP.createNotification(DebuggerBundle.message((String)"status.breakpoint.reached.in.thread", (Object[])new Object[]{thread.name()}), DebuggerBundle.message((String)"status.breakpoint.reached.in.thread.switch", (Object[])new Object[0]), NotificationType.INFORMATION, new NotificationListener(){

                        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                            if (notification == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/debugger/impl/DebuggerSession$MyDebugProcessListener$3", "hyperlinkUpdate"));
                            }
                            if (event == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/impl/DebuggerSession$MyDebugProcessListener$3", "hyperlinkUpdate"));
                            }
                            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                                notification.expire();
                                DebuggerSession.this.getProcess().getManagerThread().schedule(new SuspendContextCommandImpl(suspendContext){

                                    @Override
                                    public void contextAction() throws Exception {
                                        final DebuggerContextImpl debuggerContext = DebuggerContextUtil.createDebuggerContext(DebuggerSession.this, suspendContext);
                                        DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), new Runnable(){

                                            @Override
                                            public void run() {
                                                DebuggerSession.this.getContextManager().setState(debuggerContext, State.PAUSED, Event.PAUSE, null);
                                            }
                                        });
                                    }
                                });
                            }
                        }
                    }).notify(DebuggerSession.this.getProject());
                }
                if (((SuspendManagerImpl)this.myDebugProcess.getSuspendManager()).getPausedContexts().size() > 1) {
                    return;
                }
                currentThread = (ThreadReferenceProxyImpl)DebuggerSession.this.mySteppingThroughThread.get();
            } else {
                DebuggerSession.this.setSteppingThrough(currentThread);
            }
            if (currentThread == null) {
                LOG.assertTrue(suspendContext.getSuspendPolicy() == 2);
                SuspendContextImpl oldContext = DebuggerSession.this.getProcess().getSuspendManager().getPausedContext();
                if (oldContext != null) {
                    currentThread = oldContext.getThread();
                }
                if (currentThread == null) {
                    Collection<ThreadReferenceProxyImpl> allThreads = DebuggerSession.this.getProcess().getVirtualMachineProxy().allThreads();
                    for (ThreadReferenceProxyImpl thread : allThreads) {
                        if (!ThreadState.isEDT(thread.name())) continue;
                        currentThread = thread;
                        break;
                    }
                    if (currentThread == null) {
                        ThreadReferenceProxyImpl thread;
                        Iterator<ThreadReferenceProxyImpl> iterator = allThreads.iterator();
                        while (iterator.hasNext() && (currentThread = (thread = iterator.next())).status() != 1) {
                        }
                    }
                }
                StackFrameProxyImpl proxy = null;
                if (currentThread != null) {
                    try {
                        while (!currentThread.isSuspended()) {
                            TimeoutUtil.sleep((long)10L);
                        }
                        proxy = currentThread.frameCount() > 0 ? currentThread.frame(0) : null;
                    }
                    catch (ObjectCollectedException ignored) {
                        proxy = null;
                    }
                    catch (EvaluateException e) {
                        proxy = null;
                        LOG.error((Throwable)e);
                    }
                }
                positionContext = new SimpleStackFrameContext(proxy, this.myDebugProcess);
            } else {
                positionContext = suspendContext;
            }
            if (currentThread != null) {
                try {
                    int frameCount = currentThread.frameCount();
                    if (frameCount == 0 || frameCount <= DebuggerSession.this.myIgnoreFiltersFrameCountThreshold) {
                        DebuggerSession.this.resetIgnoreStepFiltersFlag();
                    }
                }
                catch (EvaluateException e) {
                    LOG.info((Throwable)e);
                    DebuggerSession.this.resetIgnoreStepFiltersFlag();
                }
            }
            if ((position = (SourcePosition)PsiDocumentManager.getInstance((Project)DebuggerSession.this.getProject()).commitAndRunReadAction((Computable)new Computable<SourcePosition>((StackFrameContext)positionContext){
                final /* synthetic */ StackFrameContext val$positionContext;
                {
                    this.val$positionContext = stackFrameContext;
                }

                @Nullable
                public SourcePosition compute() {
                    return ContextUtil.getSourcePosition(this.val$positionContext);
                }
            })) != null) {
                List<Pair<Breakpoint, com.sun.jdi.event.Event>> eventDescriptors = DebuggerUtilsEx.getEventDescriptors(suspendContext);
                RequestManagerImpl requestsManager = suspendContext.getDebugProcess().getRequestsManager();
                PsiFile foundFile = position.getFile();
                boolean sourceMissing = foundFile instanceof PsiCompiledElement;
                for (Pair<Breakpoint, com.sun.jdi.event.Event> eventDescriptor : eventDescriptors) {
                    String className;
                    Breakpoint breakpoint = (Breakpoint)eventDescriptor.getFirst();
                    if (!(breakpoint instanceof LineBreakpoint)) continue;
                    SourcePosition breakpointPosition = ((BreakpointWithHighlighter)breakpoint).getSourcePosition();
                    if (breakpointPosition == null || !sourceMissing && breakpointPosition.getLine() != position.getLine()) {
                        requestsManager.deleteRequest(breakpoint);
                        requestsManager.setInvalid(breakpoint, DebuggerBundle.message((String)"error.invalid.breakpoint.source.changed", (Object[])new Object[0]));
                        breakpoint.updateUI();
                        continue;
                    }
                    if (!sourceMissing) continue;
                    position = breakpointPosition;
                    StackFrameProxy frameProxy = positionContext.getFrameProxy();
                    try {
                        className = frameProxy != null ? frameProxy.location().declaringType().name() : "";
                    }
                    catch (EvaluateException ignored) {
                        className = "";
                    }
                    requestsManager.setInvalid(breakpoint, DebuggerBundle.message((String)"error.invalid.breakpoint.source.not.found", (Object[])new Object[]{className}));
                    breakpoint.updateUI();
                }
            }
            final DebuggerContextImpl debuggerContext = DebuggerContextImpl.createDebuggerContext(DebuggerSession.this, suspendContext, currentThread, null);
            debuggerContext.setPositionCache(position);
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), new Runnable(){

                @Override
                public void run() {
                    DebuggerSession.this.getContextManager().setState(debuggerContext, State.PAUSED, Event.PAUSE, DebuggerSession.getDescription(debuggerContext));
                }
            });
        }

        private boolean shouldSetAsActiveContext(SuspendContextImpl suspendContext) {
            ThreadReferenceProxyImpl newThread = suspendContext.getThread();
            if (newThread == null || suspendContext.getSuspendPolicy() == 2 || DebuggerSession.this.isSteppingThrough(newThread)) {
                return true;
            }
            SuspendContextImpl currentSuspendContext = DebuggerSession.this.getContextManager().getContext().getSuspendContext();
            if (currentSuspendContext == null) {
                return DebuggerSession.this.mySteppingThroughThread.get() == null;
            }
            if (DebuggerSession.enableBreakpointsDuringEvaluation()) {
                ThreadReferenceProxyImpl currentThread = currentSuspendContext.getThread();
                return currentThread == null || Comparing.equal((Object)currentThread.getThreadReference(), (Object)newThread.getThreadReference());
            }
            return false;
        }

        @Override
        public void resumed(SuspendContextImpl suspendContext) {
            SuspendContextImpl context = DebuggerSession.this.getProcess().getSuspendManager().getPausedContext();
            ThreadReferenceProxyImpl steppingThread = null;
            if (context != null && suspendContext != null && suspendContext.getSuspendPolicy() == 1 && DebuggerSession.this.isSteppingThrough(suspendContext.getThread())) {
                steppingThread = suspendContext.getThread();
            }
            final DebuggerContextImpl debuggerContext = context != null ? DebuggerContextImpl.createDebuggerContext(DebuggerSession.this, context, steppingThread != null ? steppingThread : context.getThread(), null) : null;
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), new Runnable(){

                @Override
                public void run() {
                    if (debuggerContext != null) {
                        DebuggerSession.this.getContextManager().setState(debuggerContext, State.PAUSED, Event.CONTEXT, DebuggerSession.getDescription(debuggerContext));
                    } else {
                        DebuggerSession.this.getContextManager().setState(DebuggerSession.this.SESSION_EMPTY_CONTEXT, State.RUNNING, Event.CONTEXT, null);
                    }
                }
            });
        }

        @Override
        public void processAttached(DebugProcessImpl process) {
            RemoteConnection connection = DebuggerSession.this.getProcess().getConnection();
            String addressDisplayName = DebuggerBundle.getAddressDisplayName((RemoteConnection)connection);
            String transportName = DebuggerBundle.getTransportName((RemoteConnection)connection);
            final String message = DebuggerBundle.message((String)"status.connected", (Object[])new Object[]{addressDisplayName, transportName});
            process.printToConsole(message + "\n");
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), new Runnable(){

                @Override
                public void run() {
                    DebuggerSession.this.getContextManager().setState(DebuggerSession.this.SESSION_EMPTY_CONTEXT, State.RUNNING, Event.ATTACHED, message);
                }
            });
        }

        @Override
        public void attachException(final RunProfileState state, final ExecutionException exception, final RemoteConnection remoteConnection) {
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), new Runnable(){

                @Override
                public void run() {
                    String message = "";
                    if (state instanceof RemoteState) {
                        message = DebuggerBundle.message((String)"status.connect.failed", (Object[])new Object[]{DebuggerBundle.getAddressDisplayName((RemoteConnection)remoteConnection), DebuggerBundle.getTransportName((RemoteConnection)remoteConnection)});
                    }
                    message = message + exception.getMessage();
                    DebuggerSession.this.getContextManager().setState(DebuggerSession.this.SESSION_EMPTY_CONTEXT, State.STOPPED, Event.DETACHED, message);
                }
            });
        }

        @Override
        public void processDetached(DebugProcessImpl debugProcess, boolean closedByUser) {
            ProcessHandler processHandler2;
            if (!closedByUser && (processHandler2 = debugProcess.getProcessHandler()) != null) {
                RemoteConnection connection = DebuggerSession.this.getProcess().getConnection();
                String addressDisplayName = DebuggerBundle.getAddressDisplayName((RemoteConnection)connection);
                String transportName = DebuggerBundle.getTransportName((RemoteConnection)connection);
                processHandler2.notifyTextAvailable(DebuggerBundle.message((String)"status.disconnected", (Object[])new Object[]{addressDisplayName, transportName}) + "\n", ProcessOutputTypes.SYSTEM);
            }
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), new Runnable(){

                @Override
                public void run() {
                    RemoteConnection connection = DebuggerSession.this.getProcess().getConnection();
                    String addressDisplayName = DebuggerBundle.getAddressDisplayName((RemoteConnection)connection);
                    String transportName = DebuggerBundle.getTransportName((RemoteConnection)connection);
                    DebuggerSession.this.getContextManager().setState(DebuggerSession.this.SESSION_EMPTY_CONTEXT, State.STOPPED, Event.DETACHED, DebuggerBundle.message((String)"status.disconnected", (Object[])new Object[]{addressDisplayName, transportName}));
                }
            });
            DebuggerSession.this.clearSteppingThrough();
        }

        @Override
        public void threadStarted(DebugProcess proc, ThreadReference thread) {
            this.notifyThreadsRefresh();
        }

        @Override
        public void threadStopped(DebugProcess proc, ThreadReference thread) {
            this.notifyThreadsRefresh();
        }

        private void notifyThreadsRefresh() {
            if (!DebuggerSession.this.myUpdateAlarm.isDisposed()) {
                DebuggerSession.this.myUpdateAlarm.cancelAllRequests();
                DebuggerSession.this.myUpdateAlarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        DebuggerStateManager contextManager = DebuggerSession.this.getContextManager();
                        contextManager.fireStateChanged(contextManager.getContext(), Event.THREADS_REFRESH);
                    }
                }, 100, ModalityState.NON_MODAL);
            }
        }
    }

    private static class DebuggerSessionState {
        final State myState;
        final String myDescription;

        public DebuggerSessionState(State state, String description) {
            this.myState = state;
            this.myDescription = description;
        }
    }

    private class MyDebuggerStateManager
    extends DebuggerStateManager {
        private DebuggerContextImpl myDebuggerContext;

        MyDebuggerStateManager() {
            this.myDebuggerContext = DebuggerSession.this.SESSION_EMPTY_CONTEXT;
        }

        @Override
        @NotNull
        public DebuggerContextImpl getContext() {
            DebuggerContextImpl debuggerContextImpl = this.myDebuggerContext;
            if (debuggerContextImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/DebuggerSession$MyDebuggerStateManager", "getContext"));
            }
            return debuggerContextImpl;
        }

        @Override
        public void setState(final @NotNull DebuggerContextImpl context, final State state, final Event event, final String description) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/debugger/impl/DebuggerSession$MyDebuggerStateManager", "setState"));
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            DebuggerSession session = context.getDebuggerSession();
            LOG.assertTrue(session == DebuggerSession.this || session == null);
            final Runnable setStateRunnable = new Runnable(){

                @Override
                public void run() {
                    LOG.assertTrue(MyDebuggerStateManager.this.myDebuggerContext.isInitialised());
                    MyDebuggerStateManager.this.myDebuggerContext = context;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("DebuggerSession state = " + (Object)((Object)state) + ", event = " + (Object)((Object)event));
                    }
                    DebuggerSession.this.myIsEvaluating = false;
                    DebuggerSession.this.myState = new DebuggerSessionState(state, description);
                    MyDebuggerStateManager.this.fireStateChanged(context, event);
                }
            };
            if (context.getSuspendContext() == null) {
                setStateRunnable.run();
            } else {
                DebuggerSession.this.getProcess().getManagerThread().schedule(new SuspendContextCommandImpl(context.getSuspendContext()){

                    @Override
                    public void contextAction() throws Exception {
                        context.initCaches();
                        DebuggerInvocationUtil.swingInvokeLater(DebuggerSession.this.getProject(), setStateRunnable);
                    }
                });
            }
        }
    }

    public static enum Event {
        ATTACHED,
        DETACHED,
        RESUME,
        STEP,
        PAUSE,
        REFRESH,
        CONTEXT,
        START_WAIT_ATTACH,
        DISPOSE,
        REFRESH_VIEWS_ONLY,
        THREADS_REFRESH;

    }

    public static enum State {
        STOPPED,
        RUNNING,
        WAITING_ATTACH,
        PAUSED,
        WAIT_EVALUATION,
        DISPOSED;

    }
}

