/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScopeBuilder;
import com.intellij.psi.search.ProjectScopeImpl;
import org.jetbrains.annotations.NotNull;

public class CoreProjectScopeBuilder
extends ProjectScopeBuilder {
    private final Project myProject;
    private final FileIndexFacade myFileIndexFacade;
    private final CoreLibrariesScope myLibrariesScope;

    public CoreProjectScopeBuilder(Project project, FileIndexFacade fileIndexFacade) {
        this.myFileIndexFacade = fileIndexFacade;
        this.myProject = project;
        this.myLibrariesScope = new CoreLibrariesScope();
    }

    @NotNull
    public GlobalSearchScope buildLibrariesScope() {
        CoreLibrariesScope coreLibrariesScope = this.myLibrariesScope;
        if (coreLibrariesScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreProjectScopeBuilder", "buildLibrariesScope"));
        }
        return coreLibrariesScope;
    }

    @NotNull
    public GlobalSearchScope buildAllScope() {
        EverythingGlobalScope everythingGlobalScope = new EverythingGlobalScope();
        if (everythingGlobalScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreProjectScopeBuilder", "buildAllScope"));
        }
        return everythingGlobalScope;
    }

    @NotNull
    public GlobalSearchScope buildProjectScope() {
        ProjectScopeImpl projectScopeImpl = new ProjectScopeImpl(this.myProject, this.myFileIndexFacade);
        if (projectScopeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreProjectScopeBuilder", "buildProjectScope"));
        }
        return projectScopeImpl;
    }

    @NotNull
    public GlobalSearchScope buildContentScope() {
        ContentSearchScope contentSearchScope = new ContentSearchScope(this.myProject, this.myFileIndexFacade);
        if (contentSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreProjectScopeBuilder", "buildContentScope"));
        }
        return contentSearchScope;
    }

    public static class ContentSearchScope
    extends GlobalSearchScope {
        private final FileIndexFacade myFileIndexFacade;

        public ContentSearchScope(Project project, FileIndexFacade fileIndexFacade) {
            super(project);
            this.myFileIndexFacade = fileIndexFacade;
        }

        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/core/CoreProjectScopeBuilder$ContentSearchScope", "contains"));
            }
            return this.myFileIndexFacade.isInContent(file2);
        }

        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/core/CoreProjectScopeBuilder$ContentSearchScope", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/core/CoreProjectScopeBuilder$ContentSearchScope", "compare"));
            }
            return 0;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/core/CoreProjectScopeBuilder$ContentSearchScope", "isSearchInModuleContent"));
            }
            return true;
        }

        public boolean isSearchInLibraries() {
            return false;
        }
    }

    private class CoreLibrariesScope
    extends GlobalSearchScope {
        private CoreLibrariesScope() {
        }

        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/core/CoreProjectScopeBuilder$CoreLibrariesScope", "contains"));
            }
            return CoreProjectScopeBuilder.this.myFileIndexFacade.isInLibraryClasses(file2) || CoreProjectScopeBuilder.this.myFileIndexFacade.isInLibrarySource(file2);
        }

        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/core/CoreProjectScopeBuilder$CoreLibrariesScope", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/core/CoreProjectScopeBuilder$CoreLibrariesScope", "compare"));
            }
            return 0;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/core/CoreProjectScopeBuilder$CoreLibrariesScope", "isSearchInModuleContent"));
            }
            return false;
        }

        public boolean isSearchInLibraries() {
            return true;
        }
    }
}

