/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.javaDoc;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.javaDoc.JavaDocLocalInspectionBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.Gray;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class JavaDocLocalInspection
extends JavaDocLocalInspectionBase {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.codeInspection.javaDoc.JavaDocLocalInspection");

    public JComponent createOptionsPanel() {
        return new OptionsPanel();
    }

    private class OptionsPanel
    extends JPanel {
        private JPanel createOptionsPanel(String[] modifiers, String[] tags, JavaDocLocalInspectionBase.Options options) {
            JPanel pane = new JPanel(new GridLayout(1, tags == null ? 1 : 2));
            pane.add(this.createScopePanel(modifiers, options));
            if (tags != null) {
                pane.add(this.createTagsPanel(tags, options));
            }
            pane.validate();
            return pane;
        }

        private JPanel createTagsPanel(String[] tags, JavaDocLocalInspectionBase.Options options) {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createCompoundBorder((Border)IdeBorderFactory.createTitledBorder((String)InspectionsBundle.message((String)"inspection.javadoc.required.tags.option.title", (Object[])new Object[0]), (boolean)true), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
            GridBagConstraints gc = new GridBagConstraints();
            gc.weightx = 1.0;
            gc.weighty = 0.0;
            gc.fill = 2;
            gc.anchor = 18;
            for (int i = 0; i < tags.length; ++i) {
                JCheckBox box = new JCheckBox(tags[i]);
                gc.gridy = i;
                if (i == tags.length - 1) {
                    gc.weighty = 1.0;
                }
                panel.add((Component)box, gc);
                box.setSelected(JavaDocLocalInspectionBase.isTagRequired(options, tags[i]));
                box.addChangeListener(new MyChangeListener(box, options, tags[i]));
            }
            return panel;
        }

        private JPanel createScopePanel(final String[] modifiers, final JavaDocLocalInspectionBase.Options options) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createCompoundBorder((Border)IdeBorderFactory.createTitledBorder((String)InspectionsBundle.message((String)"inspection.scope.for.title", (Object[])new Object[0]), (boolean)true), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
            final Hashtable<Integer, JLabel> sliderLabels = new Hashtable<Integer, JLabel>();
            for (int i = 0; i < modifiers.length; ++i) {
                sliderLabels.put(i + 1, new JLabel(modifiers[i]));
            }
            final JSlider slider = new JSlider(1, 1, modifiers.length, 1);
            slider.setLabelTable(sliderLabels);
            slider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
            slider.setPreferredSize((Dimension)JBUI.size((int)80, (int)50));
            slider.setPaintLabels(true);
            slider.setSnapToTicks(true);
            slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int value = slider.getValue();
                    options.ACCESS_JAVADOC_REQUIRED_FOR = modifiers[value - 1];
                    for (Integer key : sliderLabels.keySet()) {
                        ((JComponent)sliderLabels.get(key)).setForeground(key <= value ? Color.black : Gray._100);
                    }
                }
            });
            Color fore = Color.black;
            for (int i = 0; i < modifiers.length; ++i) {
                ((JComponent)sliderLabels.get(i + 1)).setForeground(fore);
                if (!modifiers[i].equals(options.ACCESS_JAVADOC_REQUIRED_FOR)) continue;
                slider.setValue(i + 1);
                fore = Gray._100;
            }
            panel.add((Component)slider, "West");
            return panel;
        }

        public OptionsPanel() {
            super(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0);
            this.add((Component)this.createAdditionalJavadocTagsPanel(), gc);
            JBTabbedPane tabs = new JBTabbedPane(3);
            String[] tags = new String[]{"@author", "@version", "@since"};
            tabs.add(InspectionsBundle.message((String)"inspection.javadoc.option.tab.title.package", (Object[])new Object[0]), this.createOptionsPanel(new String[]{"none", "public"}, tags, JavaDocLocalInspection.this.PACKAGE_OPTIONS));
            tags = new String[]{"@author", "@version", "@since", "@param"};
            tabs.add(InspectionsBundle.message((String)"inspection.javadoc.option.tab.title", (Object[])new Object[0]), this.createOptionsPanel(new String[]{"none", "public", "package"}, tags, JavaDocLocalInspection.this.TOP_LEVEL_CLASS_OPTIONS));
            tags = new String[]{"@return", "@param", InspectionsBundle.message((String)"inspection.javadoc.throws.or.exception.option", (Object[])new Object[0])};
            tabs.add(InspectionsBundle.message((String)"inspection.javadoc.option.tab.title.method", (Object[])new Object[0]), this.createOptionsPanel(new String[]{"none", "public", "protected", "package", "private"}, tags, JavaDocLocalInspection.this.METHOD_OPTIONS));
            tabs.add(InspectionsBundle.message((String)"inspection.javadoc.option.tab.title.field", (Object[])new Object[0]), this.createOptionsPanel(new String[]{"none", "public", "protected", "package", "private"}, null, JavaDocLocalInspection.this.FIELD_OPTIONS));
            tabs.add(InspectionsBundle.message((String)"inspection.javadoc.option.tab.title.inner.class", (Object[])new Object[0]), this.createOptionsPanel(new String[]{"none", "public", "protected", "package", "private"}, null, JavaDocLocalInspection.this.INNER_CLASS_OPTIONS));
            this.add((Component)tabs, gc);
            final JCheckBox checkBox = new JCheckBox(InspectionsBundle.message((String)"inspection.javadoc.option.ignore.deprecated", (Object[])new Object[0]), JavaDocLocalInspection.this.IGNORE_DEPRECATED);
            checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JavaDocLocalInspection.this.IGNORE_DEPRECATED = checkBox.isSelected();
                }
            });
            gc.gridwidth = 1;
            this.add((Component)checkBox, gc);
            final JCheckBox periodCheckBox = new JCheckBox(InspectionsBundle.message((String)"inspection.javadoc.option.ignore.period", (Object[])new Object[0]), JavaDocLocalInspection.this.IGNORE_JAVADOC_PERIOD);
            periodCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JavaDocLocalInspection.this.IGNORE_JAVADOC_PERIOD = periodCheckBox.isSelected();
                }
            });
            this.add((Component)periodCheckBox, gc);
            final JCheckBox ignoreDuplicateThrowsCheckBox = new JCheckBox("Ignore duplicate throws tag", JavaDocLocalInspection.this.getIgnoreDuplicatedThrows());
            ignoreDuplicateThrowsCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JavaDocLocalInspection.this.setIgnoreDuplicatedThrows(ignoreDuplicateThrowsCheckBox.isSelected());
                }
            });
            this.add((Component)ignoreDuplicateThrowsCheckBox, gc);
            final JCheckBox ignorePointToItselfCheckBox = new JCheckBox("Ignore javadoc pointing to itself", JavaDocLocalInspection.this.IGNORE_POINT_TO_ITSELF);
            ignorePointToItselfCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JavaDocLocalInspection.this.IGNORE_POINT_TO_ITSELF = ignorePointToItselfCheckBox.isSelected();
                }
            });
            this.add((Component)ignorePointToItselfCheckBox, gc);
            final JCheckBox ignoreSimpleAccessorsCheckBox = new JCheckBox("Ignore simple property accessors", JavaDocLocalInspection.this.myIgnoreSimpleAccessors);
            ignoreSimpleAccessorsCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JavaDocLocalInspection.this.myIgnoreSimpleAccessors = ignoreSimpleAccessorsCheckBox.isSelected();
                }
            });
            this.add((Component)ignoreSimpleAccessorsCheckBox, gc);
        }

        public FieldPanel createAdditionalJavadocTagsPanel() {
            FieldPanel additionalTagsPanel = new FieldPanel(InspectionsBundle.message((String)"inspection.javadoc.label.text", (Object[])new Object[0]), InspectionsBundle.message((String)"inspection.javadoc.dialog.title", (Object[])new Object[0]), null, null);
            additionalTagsPanel.setPreferredSize(new Dimension(150, additionalTagsPanel.getPreferredSize().height));
            additionalTagsPanel.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    Document document = e.getDocument();
                    try {
                        String text = document.getText(0, document.getLength());
                        if (text != null) {
                            JavaDocLocalInspection.this.myAdditionalJavadocTags = text.trim();
                        }
                    }
                    catch (BadLocationException e1) {
                        LOG.error((Throwable)e1);
                    }
                }
            });
            additionalTagsPanel.setText(JavaDocLocalInspection.this.myAdditionalJavadocTags);
            return additionalTagsPanel;
        }

        private class MyChangeListener
        implements ChangeListener {
            private final JCheckBox myCheckBox;
            private final JavaDocLocalInspectionBase.Options myOptions;
            private final String myTagName;

            public MyChangeListener(JCheckBox checkBox, JavaDocLocalInspectionBase.Options options, String tagName) {
                this.myCheckBox = checkBox;
                this.myOptions = options;
                this.myTagName = tagName;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                if (this.myCheckBox.isSelected()) {
                    if (!JavaDocLocalInspectionBase.isTagRequired(this.myOptions, this.myTagName)) {
                        this.myOptions.REQUIRED_TAGS = this.myOptions.REQUIRED_TAGS + this.myTagName;
                    }
                } else {
                    this.myOptions.REQUIRED_TAGS = this.myOptions.REQUIRED_TAGS.replaceAll(this.myTagName, "");
                }
            }
        }
    }
}

