/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18StreamApi;

import com.intellij.codeInspection.java18StreamApi.FluentIterableMethodTransformer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.hash.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GuavaOptionalConverter {
    private static final Logger LOG = Logger.getInstance(GuavaOptionalConverter.class);
    private static final Map<String, FluentIterableMethodTransformer> METHODS_CONVERSION = new HashMap();
    private static final String OR_METHOD = "or";

    public static boolean isConvertibleIfOption(PsiMethodCallExpression methodCallExpression) {
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        if (!"com.google.common.base.Optional".equals(aClass.getQualifiedName())) {
            return true;
        }
        return METHODS_CONVERSION.containsKey(method.getName());
    }

    @NotNull
    public static PsiMethodCallExpression convertGuavaOptionalToJava(PsiMethodCallExpression methodCall, PsiElementFactory elementFactory) {
        FluentIterableMethodTransformer conversion;
        String methodName = methodCall.getMethodExpression().getReferenceName();
        if (methodName == OR_METHOD) {
            String qName;
            PsiClass resolvedClass;
            PsiExpression[] arguments = methodCall.getArgumentList().getExpressions();
            if (arguments.length != 1) {
                PsiMethodCallExpression psiMethodCallExpression = methodCall;
                if (psiMethodCallExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18StreamApi/GuavaOptionalConverter", "convertGuavaOptionalToJava"));
                }
                return psiMethodCallExpression;
            }
            PsiExpression argument = arguments[0];
            PsiType type = argument.getType();
            if (type instanceof PsiClassType && (resolvedClass = ((PsiClassType)type).resolve()) != null && ("com.google.common.base.Optional".equals(qName = resolvedClass.getQualifiedName()) || "com.google.common.base.Supplier".equals(qName))) {
                PsiMethodCallExpression psiMethodCallExpression = methodCall;
                if (psiMethodCallExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18StreamApi/GuavaOptionalConverter", "convertGuavaOptionalToJava"));
                }
                return psiMethodCallExpression;
            }
        }
        if ((conversion = METHODS_CONVERSION.get(methodName)) == null) {
            PsiMethodCallExpression psiMethodCallExpression = methodCall;
            if (psiMethodCallExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18StreamApi/GuavaOptionalConverter", "convertGuavaOptionalToJava"));
            }
            return psiMethodCallExpression;
        }
        PsiMethodCallExpression transformed = conversion.transform(methodCall, elementFactory);
        LOG.assertTrue(transformed != null);
        PsiMethodCallExpression psiMethodCallExpression = transformed;
        if (psiMethodCallExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18StreamApi/GuavaOptionalConverter", "convertGuavaOptionalToJava"));
        }
        return psiMethodCallExpression;
    }

    static {
        METHODS_CONVERSION.put("isPresent", new FluentIterableMethodTransformer.ParameterlessMethodTransformer("isPresent"));
        METHODS_CONVERSION.put("get", new FluentIterableMethodTransformer.ParameterlessMethodTransformer("get"));
        METHODS_CONVERSION.put(OR_METHOD, new FluentIterableMethodTransformer.OneParameterMethodTransformer("orElse(%s)"));
        METHODS_CONVERSION.put("orNull", new FluentIterableMethodTransformer.ParameterlessMethodTransformer("orElse(null)"));
    }
}

