/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.inferNullity;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullityInferrer {
    private static final int MAX_PASSES = 10;
    public static final String NOTHING_FOUND_TO_INFER = "Nothing found to infer";
    private int numAnnotationsAdded;
    private final List<SmartPsiElementPointer<? extends PsiModifierListOwner>> myNotNullSet = new ArrayList<SmartPsiElementPointer<? extends PsiModifierListOwner>>();
    private final List<SmartPsiElementPointer<? extends PsiModifierListOwner>> myNullableSet = new ArrayList<SmartPsiElementPointer<? extends PsiModifierListOwner>>();
    private final boolean myAnnotateLocalVariables;
    private final SmartPointerManager myPointerManager;

    public NullityInferrer(boolean annotateLocalVariables, Project project) {
        this.myAnnotateLocalVariables = annotateLocalVariables;
        this.myPointerManager = SmartPointerManager.getInstance((Project)project);
    }

    private boolean expressionIsNeverNull(@Nullable PsiExpression expression) {
        if (expression == null) {
            return false;
        }
        ExpressionIsNeverNullVisitor visitor = new ExpressionIsNeverNullVisitor();
        expression.accept((PsiElementVisitor)visitor);
        return visitor.isNeverNull();
    }

    private boolean expressionIsSometimesNull(@Nullable PsiExpression expression) {
        if (expression == null) {
            return false;
        }
        ExpressionIsSometimesNullVisitor visitor = new ExpressionIsSometimesNullVisitor();
        expression.accept((PsiElementVisitor)visitor);
        return visitor.isSometimesNull();
    }

    private boolean methodNeverReturnsNull(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/inferNullity/NullityInferrer", "methodNeverReturnsNull"));
        }
        MethodNeverReturnsNullVisitor visitor = new MethodNeverReturnsNullVisitor();
        method.accept((PsiElementVisitor)visitor);
        return visitor.getNeverReturnsNull();
    }

    private boolean variableNeverAssignedNull(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInspection/inferNullity/NullityInferrer", "variableNeverAssignedNull"));
        }
        PsiExpression initializer = variable.getInitializer();
        if (initializer != null ? !this.expressionIsNeverNull(initializer) : !variable.hasModifierProperty("final")) {
            return false;
        }
        Query references = ReferencesSearch.search((PsiElement)variable);
        for (PsiReference reference : references) {
            PsiAssignmentExpression assignment;
            PsiElement parent;
            PsiElement element = reference.getElement();
            if (!(element instanceof PsiReferenceExpression) || !((parent = element.getParent()) instanceof PsiAssignmentExpression) || !(assignment = (PsiAssignmentExpression)parent).getLExpression().equals(element) || this.expressionIsNeverNull(assignment.getRExpression())) continue;
            return false;
        }
        return true;
    }

    private boolean variableSometimesAssignedNull(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInspection/inferNullity/NullityInferrer", "variableSometimesAssignedNull"));
        }
        PsiExpression initializer = variable.getInitializer();
        if (initializer != null && this.expressionIsSometimesNull(initializer)) {
            return true;
        }
        Query references = ReferencesSearch.search((PsiElement)variable);
        for (PsiReference reference : references) {
            PsiAssignmentExpression assignment;
            PsiElement parent;
            PsiElement element = reference.getElement();
            if (!(element instanceof PsiReferenceExpression) || !((parent = element.getParent()) instanceof PsiAssignmentExpression) || !(assignment = (PsiAssignmentExpression)parent).getLExpression().equals(element) || !this.expressionIsSometimesNull(assignment.getRExpression())) continue;
            return true;
        }
        return false;
    }

    public void collect(@NotNull PsiFile file2) {
        int prevNumAnnotationsAdded;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/inferNullity/NullityInferrer", "collect"));
        }
        int pass = 0;
        do {
            NullityInferrerVisitor visitor = new NullityInferrerVisitor();
            prevNumAnnotationsAdded = this.numAnnotationsAdded;
            file2.accept((PsiElementVisitor)visitor);
        } while (prevNumAnnotationsAdded < this.numAnnotationsAdded && ++pass < 10);
    }

    public void apply(Project project) {
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)project);
        for (SmartPsiElementPointer<? extends PsiModifierListOwner> pointer : this.myNullableSet) {
            NullityInferrer.annotateNullable(project, manager, (PsiModifierListOwner)pointer.getElement());
        }
        for (SmartPsiElementPointer<? extends PsiModifierListOwner> pointer : this.myNotNullSet) {
            NullityInferrer.annotateNotNull(project, manager, (PsiModifierListOwner)pointer.getElement());
        }
        if (this.myNullableSet.isEmpty() && this.myNotNullSet.isEmpty()) {
            throw new RuntimeException(NOTHING_FOUND_TO_INFER);
        }
    }

    public static void nothingFoundMessage(final Project project) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Messages.showInfoMessage((Project)project, (String)"No places found to infer @Nullable/@NotNull", (String)"Infer Nullity Results");
            }
        });
    }

    private static void annotateNotNull(Project project, NullableNotNullManager manager, PsiModifierListOwner element) {
        if (element != null) {
            if (element instanceof PsiField && ((PsiField)element).hasInitializer() && element.hasModifierProperty("final")) {
                return;
            }
            NullityInferrer.invoke(project, element, manager.getDefaultNotNull(), manager.getDefaultNullable());
        }
    }

    private static void annotateNullable(Project project, NullableNotNullManager manager, PsiModifierListOwner element) {
        if (element != null) {
            NullityInferrer.invoke(project, element, manager.getDefaultNullable(), manager.getDefaultNotNull());
        }
    }

    private static void invoke(final Project project, final PsiModifierListOwner element, final String fqn, final String toRemove) {
        WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

            @Override
            public void run() {
                new AddAnnotationFix(fqn, element, toRemove).invoke(project, null, element.getContainingFile());
            }
        });
    }

    public int getCount() {
        return this.myNotNullSet.size() + this.myNullableSet.size();
    }

    public static void apply(Project project, NullableNotNullManager manager, UsageInfo info) {
        if (info instanceof NullableUsageInfo) {
            NullityInferrer.annotateNullable(project, manager, (PsiModifierListOwner)info.getElement());
        } else if (info instanceof NotNullUsageInfo) {
            NullityInferrer.annotateNotNull(project, manager, (PsiModifierListOwner)info.getElement());
        }
    }

    private boolean shouldIgnore(PsiModifierListOwner element) {
        if (!this.myAnnotateLocalVariables) {
            if (element instanceof PsiLocalVariable) {
                return true;
            }
            if (element instanceof PsiParameter && ((PsiParameter)element).getDeclarationScope() instanceof PsiForeachStatement) {
                return true;
            }
        }
        return false;
    }

    private void registerNullableAnnotation(@NotNull PsiModifierListOwner method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/inferNullity/NullityInferrer", "registerNullableAnnotation"));
        }
        this.registerAnnotation(method, true);
    }

    private void registerNotNullAnnotation(@NotNull PsiModifierListOwner method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/inferNullity/NullityInferrer", "registerNotNullAnnotation"));
        }
        this.registerAnnotation(method, false);
    }

    private void registerAnnotation(@NotNull PsiModifierListOwner method, boolean isNullable) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/inferNullity/NullityInferrer", "registerAnnotation"));
        }
        SmartPsiElementPointer methodPointer = this.myPointerManager.createSmartPsiElementPointer((PsiElement)method);
        if (isNullable) {
            this.myNullableSet.add((SmartPsiElementPointer<? extends PsiModifierListOwner>)methodPointer);
        } else {
            this.myNotNullSet.add((SmartPsiElementPointer<? extends PsiModifierListOwner>)methodPointer);
        }
        ++this.numAnnotationsAdded;
    }

    public void collect(List<UsageInfo> usages) {
        this.collect(usages, true);
        this.collect(usages, false);
    }

    private void collect(List<UsageInfo> usages, boolean nullable) {
        List<SmartPsiElementPointer<? extends PsiModifierListOwner>> set = nullable ? this.myNullableSet : this.myNotNullSet;
        for (SmartPsiElementPointer<? extends PsiModifierListOwner> elementPointer : set) {
            PsiModifierListOwner element = (PsiModifierListOwner)elementPointer.getElement();
            if (element == null || this.shouldIgnore(element)) continue;
            usages.add(nullable ? new NullableUsageInfo((PsiElement)element) : new NotNullUsageInfo((PsiElement)element));
        }
    }

    private static boolean trunkImpossibleBrunch(PsiExpression condition, PsiExpression elseExpression, PsiExpression rOperand, PsiExpression lOperand) {
        PsiElement resolve;
        return rOperand instanceof PsiLiteralExpression && "null".equals(rOperand.getText()) && lOperand instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)lOperand).resolve()) instanceof PsiVariable && ((PsiBinaryExpression)condition).getOperationTokenType() == JavaTokenType.EQEQ && elseExpression instanceof PsiReferenceExpression && ((PsiReferenceExpression)elseExpression).resolve() == resolve;
    }

    private static boolean canTrunkImpossibleBrunch(PsiExpression condition, PsiExpression elseExpression) {
        PsiExpression lOperand;
        PsiExpression rOperand;
        return condition instanceof PsiBinaryExpression && (NullityInferrer.trunkImpossibleBrunch(condition, elseExpression, rOperand = ((PsiBinaryExpression)condition).getROperand(), lOperand = ((PsiBinaryExpression)condition).getLOperand()) || NullityInferrer.trunkImpossibleBrunch(condition, elseExpression, lOperand, rOperand));
    }

    private boolean isNotNull(PsiModifierListOwner owner) {
        if (NullableNotNullManager.isNotNull((PsiModifierListOwner)owner)) {
            return true;
        }
        SmartPsiElementPointer pointer = this.myPointerManager.createSmartPsiElementPointer((PsiElement)owner);
        return this.myNotNullSet.contains(pointer);
    }

    private boolean isNullable(PsiModifierListOwner owner) {
        if (NullableNotNullManager.isNullable((PsiModifierListOwner)owner)) {
            return true;
        }
        SmartPsiElementPointer pointer = this.myPointerManager.createSmartPsiElementPointer((PsiElement)owner);
        return this.myNullableSet.contains(pointer);
    }

    private class NullityInferrerVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private NullityInferrerVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/inferNullity/NullityInferrer$NullityInferrerVisitor", "visitMethod"));
            }
            super.visitMethod(method);
            if (method.isConstructor() || method.getReturnType() instanceof PsiPrimitiveType) {
                return;
            }
            Collection overridingMethods = OverridingMethodsSearch.search((PsiMethod)method).findAll();
            for (PsiMethod overridingMethod : overridingMethods) {
                if (!NullityInferrer.this.isNullable((PsiModifierListOwner)overridingMethod)) continue;
                NullityInferrer.this.registerNullableAnnotation((PsiModifierListOwner)method);
                return;
            }
            NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)method.getProject());
            if (!manager.isNotNull((PsiModifierListOwner)method, false) && manager.isNotNull((PsiModifierListOwner)method, true)) {
                NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)method);
                return;
            }
            if (NullityInferrer.this.isNotNull((PsiModifierListOwner)method) || NullityInferrer.this.isNullable((PsiModifierListOwner)method)) {
                return;
            }
            PsiCodeBlock body = method.getBody();
            if (body != null) {
                final boolean[] sometimesReturnsNull = new boolean[1];
                body.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitClass(PsiClass aClass) {
                    }

                    public void visitLambdaExpression(PsiLambdaExpression expression) {
                    }

                    public void visitElement(PsiElement element) {
                        if (sometimesReturnsNull[0]) {
                            return;
                        }
                        super.visitElement(element);
                    }

                    public void visitReturnStatement(PsiReturnStatement statement) {
                        super.visitReturnStatement(statement);
                        PsiExpression value = statement.getReturnValue();
                        if (NullityInferrer.this.expressionIsSometimesNull(value)) {
                            sometimesReturnsNull[0] = true;
                        }
                    }
                });
                if (sometimesReturnsNull[0]) {
                    NullityInferrer.this.registerNullableAnnotation((PsiModifierListOwner)method);
                    return;
                }
            }
            if (NullityInferrer.this.methodNeverReturnsNull(method)) {
                for (PsiMethod overridingMethod : overridingMethods) {
                    if (NullityInferrer.this.isNotNull((PsiModifierListOwner)overridingMethod)) continue;
                    return;
                }
                NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)method);
            }
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInspection/inferNullity/NullityInferrer$NullityInferrerVisitor", "visitLocalVariable"));
            }
            super.visitLocalVariable(variable);
            if (variable.getType() instanceof PsiPrimitiveType || NullityInferrer.this.isNotNull((PsiModifierListOwner)variable) || NullityInferrer.this.isNullable((PsiModifierListOwner)variable)) {
                return;
            }
            if (NullityInferrer.this.variableNeverAssignedNull((PsiVariable)variable)) {
                NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)variable);
            }
            if (NullityInferrer.this.variableSometimesAssignedNull((PsiVariable)variable)) {
                NullityInferrer.this.registerNullableAnnotation((PsiModifierListOwner)variable);
            }
        }

        public void visitParameter(@NotNull PsiParameter parameter) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInspection/inferNullity/NullityInferrer$NullityInferrerVisitor", "visitParameter"));
            }
            super.visitParameter(parameter);
            if (parameter.getType() instanceof PsiPrimitiveType || NullityInferrer.this.isNotNull((PsiModifierListOwner)parameter) || NullityInferrer.this.isNullable((PsiModifierListOwner)parameter)) {
                return;
            }
            PsiElement grandParent = parameter.getDeclarationScope();
            if (grandParent instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)grandParent;
                if (method.getBody() != null) {
                    for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter, (SearchScope)new LocalSearchScope((PsiElement)method))) {
                        PsiElement place = reference.getElement();
                        if (!(place instanceof PsiReferenceExpression)) continue;
                        PsiReferenceExpression expr = (PsiReferenceExpression)place;
                        PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)expr, (Class[])new Class[]{PsiParenthesizedExpression.class, PsiTypeCastExpression.class});
                        if (this.processParameter(parameter, expr, parent)) {
                            return;
                        }
                        if (!NullityInferrer.this.isNotNull((PsiModifierListOwner)method)) continue;
                        PsiElement toReturn = parent;
                        if (parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getCondition() != expr) {
                            toReturn = parent.getParent();
                        }
                        if (!(toReturn instanceof PsiReturnStatement)) continue;
                        NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)parameter);
                        return;
                    }
                }
            } else if (grandParent instanceof PsiForeachStatement) {
                for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter, (SearchScope)new LocalSearchScope(grandParent))) {
                    PsiElement parent;
                    PsiReferenceExpression expr;
                    PsiElement place = reference.getElement();
                    if (!(place instanceof PsiReferenceExpression) || !this.processParameter(parameter, expr = (PsiReferenceExpression)place, parent = PsiTreeUtil.skipParentsOfType((PsiElement)expr, (Class[])new Class[]{PsiParenthesizedExpression.class, PsiTypeCastExpression.class}))) continue;
                    return;
                }
            } else {
                if (NullityInferrer.this.variableNeverAssignedNull((PsiVariable)parameter)) {
                    NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)parameter);
                }
                if (NullityInferrer.this.variableSometimesAssignedNull((PsiVariable)parameter)) {
                    NullityInferrer.this.registerNullableAnnotation((PsiModifierListOwner)parameter);
                }
            }
        }

        private boolean processParameter(PsiParameter parameter, PsiReferenceExpression expr, PsiElement parent) {
            PsiParameter resolvedToParam;
            PsiParameter[] parameters;
            PsiMethod resolvedMethod;
            Object[] args;
            int idx;
            PsiExpressionList argumentList;
            PsiCall call;
            if (PsiUtil.isAccessedForWriting((PsiExpression)expr)) {
                return true;
            }
            if (parent instanceof PsiBinaryExpression) {
                PsiExpression opposite = null;
                PsiExpression lOperand = ((PsiBinaryExpression)parent).getLOperand();
                PsiExpression rOperand = ((PsiBinaryExpression)parent).getROperand();
                if (lOperand == expr) {
                    opposite = rOperand;
                } else if (rOperand == expr) {
                    opposite = lOperand;
                }
                if (opposite != null && opposite.getType() == PsiType.NULL) {
                    if (parent.getParent() instanceof PsiAssertStatement && ((PsiBinaryExpression)parent).getOperationTokenType() == JavaTokenType.NE) {
                        NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)parameter);
                        return true;
                    }
                    NullityInferrer.this.registerNullableAnnotation((PsiModifierListOwner)parameter);
                    return true;
                }
            } else {
                if (parent instanceof PsiInstanceOfExpression) {
                    return true;
                }
                if (parent instanceof PsiReferenceExpression) {
                    PsiExpression qualifierExpression = ((PsiReferenceExpression)parent).getQualifierExpression();
                    if (qualifierExpression == expr) {
                        NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)parameter);
                        return true;
                    }
                    PsiElement exprParent = expr.getParent();
                    while (exprParent instanceof PsiTypeCastExpression || exprParent instanceof PsiParenthesizedExpression) {
                        if (qualifierExpression == exprParent) {
                            NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)parameter);
                            return true;
                        }
                        exprParent = exprParent.getParent();
                    }
                } else if (parent instanceof PsiAssignmentExpression) {
                    PsiVariable localVar;
                    PsiElement resolve;
                    PsiExpression expression;
                    if (((PsiAssignmentExpression)parent).getRExpression() == expr && (expression = ((PsiAssignmentExpression)parent).getLExpression()) instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)expression).resolve()) instanceof PsiVariable && NullityInferrer.this.isNotNull((PsiModifierListOwner)(localVar = (PsiVariable)resolve))) {
                        NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)parameter);
                        return true;
                    }
                } else if (parent instanceof PsiForeachStatement) {
                    if (((PsiForeachStatement)parent).getIteratedValue() == expr) {
                        NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)parameter);
                        return true;
                    }
                } else if (parent instanceof PsiSwitchStatement && ((PsiSwitchStatement)parent).getExpression() == expr) {
                    NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)parameter);
                    return true;
                }
            }
            if ((call = (PsiCall)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiCall.class)) != null && (argumentList = call.getArgumentList()) != null && (idx = ArrayUtil.find((Object[])(args = argumentList.getExpressions()), (Object)expr)) >= 0 && (resolvedMethod = call.resolveMethod()) != null && idx < (parameters = resolvedMethod.getParameterList().getParameters()).length && NullityInferrer.this.isNotNull((PsiModifierListOwner)(resolvedToParam = parameters[idx])) && !resolvedToParam.isVarArgs()) {
                NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)parameter);
                return true;
            }
            return false;
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInspection/inferNullity/NullityInferrer$NullityInferrerVisitor", "visitField"));
            }
            super.visitField(field);
            if (field instanceof PsiEnumConstant) {
                return;
            }
            if (field.getType() instanceof PsiPrimitiveType || NullityInferrer.this.isNotNull((PsiModifierListOwner)field) || NullityInferrer.this.isNullable((PsiModifierListOwner)field)) {
                return;
            }
            if (NullityInferrer.this.variableNeverAssignedNull((PsiVariable)field)) {
                NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)field);
            }
            if (NullityInferrer.this.variableSometimesAssignedNull((PsiVariable)field)) {
                NullityInferrer.this.registerNullableAnnotation((PsiModifierListOwner)field);
            }
        }
    }

    private class MethodNeverReturnsNullVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean neverReturnsNull = true;

        private MethodNeverReturnsNullVisitor() {
        }

        public void visitClass(PsiClass aClass) {
        }

        public void visitLambdaExpression(PsiLambdaExpression expression) {
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInspection/inferNullity/NullityInferrer$MethodNeverReturnsNullVisitor", "visitReturnStatement"));
            }
            super.visitReturnStatement(statement);
            PsiExpression value = statement.getReturnValue();
            if (NullityInferrer.this.expressionIsNeverNull(value)) {
                return;
            }
            if (value instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)value;
                PsiMethod method = methodCallExpression.resolveMethod();
                PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)value, PsiMethod.class);
                if (method != null && method.equals(containingMethod)) {
                    return;
                }
            }
            this.neverReturnsNull = false;
        }

        private boolean getNeverReturnsNull() {
            return this.neverReturnsNull;
        }
    }

    private class ExpressionIsSometimesNullVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean sometimesNull;

        private ExpressionIsSometimesNullVisitor() {
        }

        public void visitElement(PsiElement element) {
            if (this.sometimesNull) {
                return;
            }
            super.visitElement(element);
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/inferNullity/NullityInferrer$ExpressionIsSometimesNullVisitor", "visitLiteralExpression"));
            }
            this.sometimesNull = "null".equals(expression.getText());
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/inferNullity/NullityInferrer$ExpressionIsSometimesNullVisitor", "visitAssignmentExpression"));
            }
            this.sometimesNull = NullityInferrer.this.expressionIsSometimesNull(expression.getRExpression());
        }

        public void visitAssertStatement(PsiAssertStatement statement) {
        }

        public void visitConditionalExpression(@NotNull PsiConditionalExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/inferNullity/NullityInferrer$ExpressionIsSometimesNullVisitor", "visitConditionalExpression"));
            }
            PsiExpression condition = expression.getCondition();
            PsiExpression thenExpression = expression.getThenExpression();
            PsiExpression elseExpression = expression.getElseExpression();
            if (NullityInferrer.canTrunkImpossibleBrunch(condition, elseExpression)) {
                this.sometimesNull = NullityInferrer.this.expressionIsSometimesNull(thenExpression);
                return;
            }
            this.sometimesNull = NullityInferrer.this.expressionIsSometimesNull(thenExpression) || NullityInferrer.this.expressionIsSometimesNull(elseExpression);
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            PsiVariable var;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/inferNullity/NullityInferrer$ExpressionIsSometimesNullVisitor", "visitReferenceExpression"));
            }
            PsiElement referent = expression.resolve();
            if (referent instanceof PsiVariable && NullityInferrer.this.isNullable((PsiModifierListOwner)(var = (PsiVariable)referent))) {
                this.sometimesNull = true;
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/inferNullity/NullityInferrer$ExpressionIsSometimesNullVisitor", "visitMethodCallExpression"));
            }
            PsiMethod method = expression.resolveMethod();
            if (method != null) {
                this.sometimesNull = NullityInferrer.this.isNullable((PsiModifierListOwner)method);
            }
        }

        private boolean isSometimesNull() {
            return this.sometimesNull;
        }
    }

    private class ExpressionIsNeverNullVisitor
    extends JavaElementVisitor {
        private boolean neverNull = true;

        private ExpressionIsNeverNullVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/inferNullity/NullityInferrer$ExpressionIsNeverNullVisitor", "visitLiteralExpression"));
            }
            this.neverNull = !"null".equals(expression.getText());
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/inferNullity/NullityInferrer$ExpressionIsNeverNullVisitor", "visitAssignmentExpression"));
            }
            this.neverNull = NullityInferrer.this.expressionIsNeverNull(expression.getRExpression());
        }

        public void visitAssertStatement(PsiAssertStatement statement) {
        }

        public void visitConditionalExpression(@NotNull PsiConditionalExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/inferNullity/NullityInferrer$ExpressionIsNeverNullVisitor", "visitConditionalExpression"));
            }
            PsiExpression condition = expression.getCondition();
            PsiExpression thenExpression = expression.getThenExpression();
            PsiExpression elseExpression = expression.getElseExpression();
            if (NullityInferrer.canTrunkImpossibleBrunch(condition, elseExpression)) {
                this.neverNull = NullityInferrer.this.expressionIsNeverNull(thenExpression);
                return;
            }
            this.neverNull = NullityInferrer.this.expressionIsNeverNull(thenExpression) || NullityInferrer.this.expressionIsNeverNull(elseExpression);
        }

        public void visitParenthesizedExpression(@NotNull PsiParenthesizedExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/inferNullity/NullityInferrer$ExpressionIsNeverNullVisitor", "visitParenthesizedExpression"));
            }
            this.neverNull = NullityInferrer.this.expressionIsNeverNull(expression.getExpression());
        }

        public void visitArrayAccessExpression(PsiArrayAccessExpression expression) {
            this.neverNull = false;
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            PsiVariable var;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/inferNullity/NullityInferrer$ExpressionIsNeverNullVisitor", "visitReferenceExpression"));
            }
            PsiElement referent = expression.resolve();
            if (referent instanceof PsiVariable && ((var = (PsiVariable)referent) instanceof PsiEnumConstant || NullityInferrer.this.isNotNull((PsiModifierListOwner)var))) {
                this.neverNull = true;
                return;
            }
            this.neverNull = false;
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/inferNullity/NullityInferrer$ExpressionIsNeverNullVisitor", "visitMethodCallExpression"));
            }
            PsiMethod method = expression.resolveMethod();
            this.neverNull = method != null && NullityInferrer.this.isNotNull((PsiModifierListOwner)method);
        }

        private boolean isNeverNull() {
            return this.neverNull;
        }
    }

    private static class NotNullUsageInfo
    extends UsageInfo {
        private NotNullUsageInfo(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/inferNullity/NullityInferrer$NotNullUsageInfo", "<init>"));
            }
            super(element);
        }
    }

    private static class NullableUsageInfo
    extends UsageInfo {
        private NullableUsageInfo(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/inferNullity/NullityInferrer$NullableUsageInfo", "<init>"));
            }
            super(element);
        }
    }
}

