/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionToolProvider;
import com.intellij.codeInspection.InspectionToolsFactory;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionEP;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolsRegistrarCore;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.ex.ComponentManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Factory;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class InspectionToolRegistrar {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.InspectionToolRegistrar");
    private final List<Factory<InspectionToolWrapper>> myInspectionToolFactories = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myInspectionComponentsLoaded = false;

    private synchronized void ensureInitialized() {
        if (!this.myInspectionComponentsLoaded) {
            this.myInspectionComponentsLoaded = true;
            THashSet providers = new THashSet();
            providers.addAll(((ComponentManagerEx)ApplicationManager.getApplication()).getComponentInstancesOfType(InspectionToolProvider.class));
            ContainerUtil.addAll((Collection)providers, (Object[])Extensions.getExtensions((ExtensionPointName)InspectionToolProvider.EXTENSION_POINT_NAME));
            ArrayList<Factory<InspectionToolWrapper>> factories = new ArrayList<Factory<InspectionToolWrapper>>();
            InspectionToolRegistrar.registerTools((Collection<InspectionToolProvider>)providers, factories);
            for (final LocalInspectionEP localInspectionEP : (LocalInspectionEP[])Extensions.getExtensions((ExtensionPointName)LocalInspectionEP.LOCAL_INSPECTION)) {
                factories.add(new Factory<InspectionToolWrapper>(){

                    public InspectionToolWrapper create() {
                        return new LocalInspectionToolWrapper(localInspectionEP);
                    }
                });
            }
            for (LocalInspectionEP localInspectionEP : (InspectionEP[])Extensions.getExtensions((ExtensionPointName)InspectionEP.GLOBAL_INSPECTION)) {
                factories.add(new Factory<InspectionToolWrapper>((InspectionEP)localInspectionEP){
                    final /* synthetic */ InspectionEP val$ep;
                    {
                        this.val$ep = inspectionEP;
                    }

                    public InspectionToolWrapper create() {
                        return new GlobalInspectionToolWrapper(this.val$ep);
                    }
                });
            }
            for (LocalInspectionEP localInspectionEP : (InspectionToolsFactory[])Extensions.getExtensions((ExtensionPointName)InspectionToolsFactory.EXTENSION_POINT_NAME)) {
                for (final InspectionProfileEntry profileEntry : localInspectionEP.createTools()) {
                    factories.add(new Factory<InspectionToolWrapper>(){

                        public InspectionToolWrapper create() {
                            return InspectionToolRegistrar.wrapTool(profileEntry);
                        }
                    });
                }
            }
            this.myInspectionToolFactories.addAll(factories);
        }
    }

    @NotNull
    public static InspectionToolWrapper wrapTool(@NotNull InspectionProfileEntry profileEntry) {
        if (profileEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileEntry", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "wrapTool"));
        }
        if (profileEntry instanceof LocalInspectionTool) {
            LocalInspectionToolWrapper localInspectionToolWrapper = new LocalInspectionToolWrapper((LocalInspectionTool)profileEntry);
            if (localInspectionToolWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "wrapTool"));
            }
            return localInspectionToolWrapper;
        }
        if (profileEntry instanceof GlobalInspectionTool) {
            GlobalInspectionToolWrapper globalInspectionToolWrapper = new GlobalInspectionToolWrapper((GlobalInspectionTool)profileEntry);
            if (globalInspectionToolWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "wrapTool"));
            }
            return globalInspectionToolWrapper;
        }
        throw new RuntimeException("unknown inspection class: " + profileEntry + "; " + profileEntry.getClass());
    }

    private static void registerTools(@NotNull Collection<InspectionToolProvider> providers, @NotNull List<Factory<InspectionToolWrapper>> factories) {
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "registerTools"));
        }
        if (factories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factories", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "registerTools"));
        }
        for (InspectionToolProvider provider : providers) {
            Class[] classes;
            for (final Class aClass : classes = provider.getInspectionClasses()) {
                Factory<InspectionToolWrapper> factory = new Factory<InspectionToolWrapper>(){

                    public InspectionToolWrapper create() {
                        return InspectionToolRegistrar.wrapTool((InspectionProfileEntry)InspectionToolsRegistrarCore.instantiateTool((Class)aClass));
                    }
                };
                factories.add(factory);
            }
        }
    }

    public static InspectionToolRegistrar getInstance() {
        return (InspectionToolRegistrar)ServiceManager.getService(InspectionToolRegistrar.class);
    }

    @NotNull
    public List<InspectionToolWrapper> createTools() {
        this.ensureInitialized();
        ArrayList<InspectionToolWrapper> tools = new ArrayList<InspectionToolWrapper>(this.myInspectionToolFactories.size());
        for (Factory<InspectionToolWrapper> factory : this.myInspectionToolFactories) {
            ProgressManager.checkCanceled();
            InspectionToolWrapper toolWrapper = (InspectionToolWrapper)factory.create();
            if (toolWrapper == null || InspectionToolRegistrar.checkTool(toolWrapper) != null) continue;
            tools.add(toolWrapper);
        }
        ArrayList<InspectionToolWrapper> arrayList = tools;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "createTools"));
        }
        return arrayList;
    }

    private static String checkTool(@NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "checkTool"));
        }
        if (!(toolWrapper instanceof LocalInspectionToolWrapper)) {
            return null;
        }
        String message = null;
        try {
            String id = toolWrapper.getID();
            if (id == null || !LocalInspectionTool.isValidID((String)id)) {
                message = InspectionsBundle.message((String)"inspection.disabled.wrong.id", (Object[])new Object[]{toolWrapper.getShortName(), id, "[a-zA-Z_0-9.-]+"});
            }
        }
        catch (Throwable t) {
            message = InspectionsBundle.message((String)"inspection.disabled.error", (Object[])new Object[]{toolWrapper.getShortName(), t.getMessage()});
        }
        if (message != null) {
            LOG.error(message);
        }
        return message;
    }
}

