/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.dataFlow.ContractInspection;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditContractIntention
extends BaseIntentionAction
implements LowPriorityAction {
    @NotNull
    public String getFamilyName() {
        if ("Edit method contract" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/EditContractIntention", "getFamilyName"));
        }
        return "Edit method contract";
    }

    @Nullable
    private static PsiMethod getTargetMethod(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/dataFlow/EditContractIntention", "getTargetMethod"));
        }
        PsiModifierListOwner owner = AddAnnotationPsiFix.getContainer(file2, editor.getCaretModel().getOffset());
        if (owner instanceof PsiMethod && (!owner.getManager().isInProject((PsiElement)owner) || CodeStyleSettingsManager.getSettings((Project)project).USE_EXTERNAL_ANNOTATIONS)) {
            PsiElement original = owner.getOriginalElement();
            return original instanceof PsiMethod ? (PsiMethod)original : (PsiMethod)owner;
        }
        return null;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/dataFlow/EditContractIntention", "isAvailable"));
        }
        PsiMethod method = EditContractIntention.getTargetMethod(project, editor, file2);
        if (method != null) {
            boolean hasContract = ControlFlowAnalyzer.findContractAnnotation(method) != null;
            this.setText(hasContract ? "Edit method contract of '" + method.getName() + "'" : "Add method contract to '" + method.getName() + "'");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/dataFlow/EditContractIntention", "invoke"));
        }
        final PsiMethod method = EditContractIntention.getTargetMethod(project, editor, file2);
        assert (method != null);
        String prompt = "<html>Please specify the contract text<p>Example: <code>_, null -> false</code><br><small>See intention action description for more details</small></html>";
        Contract existingAnno = (Contract)AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)method, Contract.class);
        String oldContract = existingAnno == null ? null : existingAnno.value();
        String newContract = Messages.showInputDialog((Project)project, (String)prompt, (String)"Edit Method Contract", null, (String)oldContract, (InputValidator)new InputValidatorEx(){

            @Nullable
            public String getErrorText(String inputString) {
                if (StringUtil.isEmpty((String)inputString)) {
                    return null;
                }
                return ContractInspection.checkContract(method, inputString);
            }

            public boolean checkInput(String inputString) {
                return this.getErrorText(inputString) == null;
            }

            public boolean canClose(String inputString) {
                return this.checkInput(inputString);
            }
        });
        if (newContract == null) {
            return;
        }
        AccessToken token = WriteAction.start();
        try {
            ExternalAnnotationsManager manager = ExternalAnnotationsManager.getInstance((Project)project);
            manager.deannotate((PsiModifierListOwner)method, ControlFlowAnalyzer.ORG_JETBRAINS_ANNOTATIONS_CONTRACT);
            if (!StringUtil.isEmpty((String)newContract)) {
                PsiAnnotation mockAnno = JavaPsiFacade.getElementFactory((Project)project).createAnnotationFromText("@Foo(\"" + newContract + "\")", null);
                manager.annotateExternally((PsiModifierListOwner)method, ControlFlowAnalyzer.ORG_JETBRAINS_ANNOTATIONS_CONTRACT, file2, mockAnno.getParameterList().getAttributes());
            }
        }
        finally {
            token.finish();
        }
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
    }

    public boolean startInWriteAction() {
        return false;
    }
}

