/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.BytecodeAnalysisConverter;
import com.intellij.codeInspection.bytecodeAnalysis.Bytes;
import com.intellij.codeInspection.bytecodeAnalysis.CombinedAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.DirectionResultPair;
import com.intellij.codeInspection.bytecodeAnalysis.Equation;
import com.intellij.codeInspection.bytecodeAnalysis.Final;
import com.intellij.codeInspection.bytecodeAnalysis.HEquations;
import com.intellij.codeInspection.bytecodeAnalysis.InOutAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.Key;
import com.intellij.codeInspection.bytecodeAnalysis.Method;
import com.intellij.codeInspection.bytecodeAnalysis.NegationAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.NegationAnalysisFailure;
import com.intellij.codeInspection.bytecodeAnalysis.NonNullInAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.NullableInAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.NullableMethodAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.PResults;
import com.intellij.codeInspection.bytecodeAnalysis.PendingAction;
import com.intellij.codeInspection.bytecodeAnalysis.ProjectBytecodeAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.PurityAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.State;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ASMUtils;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ControlFlowGraph;
import com.intellij.codeInspection.bytecodeAnalysis.asm.DFSTree;
import com.intellij.codeInspection.bytecodeAnalysis.asm.LeakingParameters;
import com.intellij.codeInspection.bytecodeAnalysis.asm.OriginsAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.asm.RichControlFlow;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileContent;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;

public class ClassDataIndexer
implements DataIndexer<Bytes, HEquations, FileContent> {
    private static final int STABLE_FLAGS = 26;
    public static final Final<Key, Value> FINAL_TOP = new Final(Value.Top);
    public static final Final<Key, Value> FINAL_BOT = new Final(Value.Bot);
    public static final Final<Key, Value> FINAL_NOT_NULL = new Final(Value.NotNull);
    public static final Final<Key, Value> FINAL_NULL = new Final(Value.Null);

    @NotNull
    public Map<Bytes, HEquations> map(@NotNull FileContent inputData) {
        if (inputData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/codeInspection/bytecodeAnalysis/ClassDataIndexer", "map"));
        }
        HashMap<Bytes, HEquations> map = new HashMap<Bytes, HEquations>();
        try {
            MessageDigest md = BytecodeAnalysisConverter.getMessageDigest();
            Map<Key, List<Equation<Key, Value>>> allEquations = ClassDataIndexer.processClass(new ClassReader(inputData.getContent()), inputData.getFile().getPresentableUrl());
            for (Map.Entry<Key, List<Equation<Key, Value>>> entry : allEquations.entrySet()) {
                Key methodKey = entry.getKey();
                List<Equation<Key, Value>> rawMethodEquations = entry.getValue();
                ArrayList<DirectionResultPair> compressedMethodEquations = new ArrayList<DirectionResultPair>(rawMethodEquations.size());
                for (Equation<Key, Value> equation : rawMethodEquations) {
                    compressedMethodEquations.add(BytecodeAnalysisConverter.convert(equation, md));
                }
                map.put(new Bytes(BytecodeAnalysisConverter.asmKey((Key)methodKey, (MessageDigest)md).key), new HEquations(compressedMethodEquations, methodKey.stable));
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            ProjectBytecodeAnalysis.LOG.debug("Unexpected Error during indexing of bytecode", e);
        }
        HashMap<Bytes, HEquations> hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ClassDataIndexer", "map"));
        }
        return hashMap;
    }

    public static Map<Key, List<Equation<Key, Value>>> processClass(ClassReader classReader, final String presentableUrl) {
        final State[] sharedPendingStates = new State[30000];
        final PendingAction[] sharedPendingActions = new PendingAction[30000];
        final PResults.PResult[] sharedResults = new PResults.PResult[30000];
        final HashMap<Key, List<Equation<Key, Value>>> equations = new HashMap<Key, List<Equation<Key, Value>>>();
        classReader.accept(new ClassVisitor(327680){
            private String className;
            private boolean stableClass;

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.className = name;
                this.stableClass = (access & 0x10) != 0;
                super.visit(version, access, name, signature, superName, interfaces);
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                final MethodNode node = new MethodNode(327680, access, name, desc, signature, exceptions);
                return new MethodVisitor(327680, (MethodVisitor)node){
                    private boolean jsr;

                    public void visitJumpInsn(int opcode, Label label) {
                        if (opcode == 168) {
                            this.jsr = true;
                        }
                        super.visitJumpInsn(opcode, label);
                    }

                    public void visitEnd() {
                        super.visitEnd();
                        Pair methodEquations = this.processMethod(node, this.jsr);
                        equations.put(methodEquations.first, methodEquations.second);
                    }
                };
            }

            private Pair<Key, List<Equation<Key, Value>>> processMethod(MethodNode methodNode, boolean jsr) {
                ProgressManager.checkCanceled();
                Type[] argumentTypes = Type.getArgumentTypes((String)methodNode.desc);
                Type resultType = Type.getReturnType((String)methodNode.desc);
                boolean isReferenceResult = ASMUtils.isReferenceType(resultType);
                boolean isBooleanResult = ASMUtils.isBooleanType(resultType);
                boolean isInterestingResult = isReferenceResult || isBooleanResult;
                Method method = new Method(this.className, methodNode.name, methodNode.desc);
                boolean stable = this.stableClass || (methodNode.access & 0x1A) != 0 || "<init>".equals(methodNode.name);
                Key primaryKey = new Key(method, Direction.Out, stable);
                ArrayList<Equation<Key, Value>> equations2 = new ArrayList<Equation<Key, Value>>(argumentTypes.length * 4 + 3);
                equations2.add(PurityAnalysis.analyze(method, methodNode, stable));
                if (argumentTypes.length == 0 && !isInterestingResult) {
                    return Pair.create((Object)primaryKey, equations2);
                }
                try {
                    ControlFlowGraph graph = ControlFlowGraph.build(this.className, methodNode, jsr);
                    if (graph.transitions.length > 0) {
                        boolean branching;
                        DFSTree dfs = DFSTree.build(graph.transitions, graph.edgeCount);
                        boolean bl = branching = !dfs.back.isEmpty();
                        if (!branching) {
                            for (int[] transition : graph.transitions) {
                                if (transition == null || transition.length <= 1) continue;
                                branching = true;
                                break;
                            }
                        }
                        if (branching) {
                            RichControlFlow richControlFlow = new RichControlFlow(graph, dfs);
                            if (richControlFlow.reducible()) {
                                NegationAnalysis negated = this.tryNegation(method, argumentTypes, graph, isBooleanResult, dfs, jsr);
                                this.processBranchingMethod(method, methodNode, richControlFlow, argumentTypes, isReferenceResult, isBooleanResult, stable, jsr, equations2, negated);
                                return Pair.create((Object)primaryKey, equations2);
                            }
                            ProjectBytecodeAnalysis.LOG.debug(method + ": CFG is not reducible");
                        } else {
                            this.processNonBranchingMethod(method, argumentTypes, graph, isReferenceResult, isBooleanResult, stable, equations2);
                            return Pair.create((Object)primaryKey, equations2);
                        }
                    }
                    return Pair.create((Object)primaryKey, this.topEquations(method, argumentTypes, isReferenceResult, isInterestingResult, stable));
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    ProjectBytecodeAnalysis.LOG.debug("Unexpected Error during processing of " + method + " in " + presentableUrl, e);
                    return Pair.create((Object)primaryKey, this.topEquations(method, argumentTypes, isReferenceResult, isInterestingResult, stable));
                }
            }

            private NegationAnalysis tryNegation(final Method method, final Type[] argumentTypes, final ControlFlowGraph graph, boolean isBooleanResult, DFSTree dfs, final boolean jsr) throws AnalyzerException {
                Util util;
                class Util {
                    Util() {
                    }

                    boolean isMethodCall(int opCode) {
                        return opCode == 184 || opCode == 183 || opCode == 182 || opCode == 185;
                    }

                    boolean singleIfBranch() {
                        int branch = 0;
                        for (int i = 0; i < graph.transitions.length; ++i) {
                            int[] transition = graph.transitions[i];
                            if (transition.length == 2) {
                                boolean isIfInsn;
                                ++branch;
                                int opCode = graph.methodNode.instructions.get(i).getOpcode();
                                boolean bl = isIfInsn = opCode == 153 || opCode == 154;
                                if (!isIfInsn) {
                                    return false;
                                }
                            }
                            if (branch <= 1) continue;
                            return false;
                        }
                        return branch == 1;
                    }

                    boolean singleMethodCall() {
                        int callCount = 0;
                        for (int i = 0; i < graph.transitions.length; ++i) {
                            if (!this.isMethodCall(graph.methodNode.instructions.get(i).getOpcode()) || ++callCount <= 1) continue;
                            return false;
                        }
                        return callCount == 1;
                    }

                    public boolean booleanConstResult() {
                        try {
                            boolean[] origins = OriginsAnalysis.resultOrigins((this).leakingParametersAndFrames((Method)method, (MethodNode)graph.methodNode, (Type[])argumentTypes, (boolean)jsr).frames, graph.methodNode.instructions, graph);
                            for (int i = 0; i < origins.length; ++i) {
                                boolean isBooleanConst;
                                if (!origins[i]) continue;
                                int opCode = graph.methodNode.instructions.get(i).getOpcode();
                                boolean bl = isBooleanConst = opCode == 3 || opCode == 4;
                                if (isBooleanConst) continue;
                                return false;
                            }
                            return true;
                        }
                        catch (AnalyzerException analyzerException) {
                            return false;
                        }
                    }
                }
                if (graph.methodNode.instructions.size() < 20 && isBooleanResult && dfs.back.isEmpty() && !jsr && (util = new Util()).singleIfBranch() && util.singleMethodCall() && util.booleanConstResult()) {
                    NegationAnalysis analyzer = new NegationAnalysis(method, graph);
                    try {
                        analyzer.analyze();
                        return analyzer;
                    }
                    catch (NegationAnalysisFailure ignore) {
                        return null;
                    }
                }
                return null;
            }

            private void processBranchingMethod(Method method, MethodNode methodNode, RichControlFlow richControlFlow, Type[] argumentTypes, boolean isReferenceResult, boolean isBooleanResult, boolean stable, boolean jsr, List<Equation<Key, Value>> result2, NegationAnalysis negatedAnalysis) throws AnalyzerException {
                boolean withCycle;
                Equation<Key, Value> outEquation;
                boolean isInterestingResult;
                boolean maybeLeakingParameter = isInterestingResult = isBooleanResult || isReferenceResult;
                for (Type argType : argumentTypes) {
                    if (!ASMUtils.isReferenceType(argType)) continue;
                    maybeLeakingParameter = true;
                    break;
                }
                LeakingParameters leakingParametersAndFrames = maybeLeakingParameter ? this.leakingParametersAndFrames(method, methodNode, argumentTypes, jsr) : null;
                boolean[] leakingParameters = leakingParametersAndFrames != null ? leakingParametersAndFrames.parameters : null;
                boolean[] leakingNullableParameters = leakingParametersAndFrames != null ? leakingParametersAndFrames.nullableParameters : null;
                boolean[] origins = isInterestingResult ? OriginsAnalysis.resultOrigins(leakingParametersAndFrames.frames, methodNode.instructions, richControlFlow.controlFlow) : null;
                Equation<Key, Value> equation = outEquation = isInterestingResult ? new InOutAnalysis(richControlFlow, Direction.Out, origins, stable, sharedPendingStates).analyze() : null;
                if (isReferenceResult) {
                    result2.add(outEquation);
                    result2.add(new Equation<Key, Value>(new Key(method, Direction.NullableOut, stable), NullableMethodAnalysis.analyze(methodNode, origins, jsr)));
                }
                boolean bl = withCycle = !richControlFlow.dfsTree.back.isEmpty();
                if (argumentTypes.length > 50 && withCycle) {
                    return;
                }
                for (int i = 0; i < argumentTypes.length; ++i) {
                    boolean notNullParam = false;
                    if (!ASMUtils.isReferenceType(argumentTypes[i])) continue;
                    boolean possibleNPE = false;
                    if (leakingParameters[i]) {
                        NonNullInAnalysis notNullInAnalysis = new NonNullInAnalysis(richControlFlow, new Direction.In(i, 0), stable, sharedPendingActions, sharedResults);
                        Equation<Key, Value> notNullParamEquation = notNullInAnalysis.analyze();
                        possibleNPE = notNullInAnalysis.possibleNPE;
                        notNullParam = notNullParamEquation.rhs.equals(FINAL_NOT_NULL);
                        result2.add(notNullParamEquation);
                    } else {
                        result2.add(new Equation<Key, Value>(new Key(method, new Direction.In(i, 0), stable), FINAL_TOP));
                    }
                    if (leakingNullableParameters[i]) {
                        if (notNullParam || possibleNPE) {
                            result2.add(new Equation<Key, Value>(new Key(method, new Direction.In(i, 1), stable), FINAL_TOP));
                        } else {
                            result2.add(new NullableInAnalysis(richControlFlow, new Direction.In(i, 1), stable, sharedPendingStates).analyze());
                        }
                    } else {
                        result2.add(new Equation<Key, Value>(new Key(method, new Direction.In(i, 1), stable), FINAL_NULL));
                    }
                    if (!isInterestingResult) continue;
                    if (leakingParameters[i]) {
                        if (notNullParam) {
                            result2.add(new Equation<Key, Value>(new Key(method, new Direction.InOut(i, Value.Null), stable), FINAL_BOT));
                        } else if (isBooleanResult && negatedAnalysis != null) {
                            result2.add(negatedAnalysis.contractEquation(i, Value.Null, stable));
                        } else {
                            result2.add(new InOutAnalysis(richControlFlow, new Direction.InOut(i, Value.Null), origins, stable, sharedPendingStates).analyze());
                        }
                        if (isBooleanResult && negatedAnalysis != null) {
                            result2.add(negatedAnalysis.contractEquation(i, Value.NotNull, stable));
                            continue;
                        }
                        result2.add(new InOutAnalysis(richControlFlow, new Direction.InOut(i, Value.NotNull), origins, stable, sharedPendingStates).analyze());
                        continue;
                    }
                    result2.add(new Equation(new Key(method, new Direction.InOut(i, Value.Null), stable), outEquation.rhs));
                    result2.add(new Equation(new Key(method, new Direction.InOut(i, Value.NotNull), stable), outEquation.rhs));
                }
            }

            private void processNonBranchingMethod(Method method, Type[] argumentTypes, ControlFlowGraph graph, boolean isReferenceResult, boolean isBooleanResult, boolean stable, List<Equation<Key, Value>> result2) throws AnalyzerException {
                CombinedAnalysis analyzer = new CombinedAnalysis(method, graph);
                analyzer.analyze();
                if (isReferenceResult) {
                    result2.add(analyzer.outContractEquation(stable));
                    result2.add(analyzer.nullableResultEquation(stable));
                }
                for (int i = 0; i < argumentTypes.length; ++i) {
                    Type argType = argumentTypes[i];
                    if (!ASMUtils.isReferenceType(argType)) continue;
                    result2.add(analyzer.notNullParamEquation(i, stable));
                    result2.add(analyzer.nullableParamEquation(i, stable));
                    if (!isReferenceResult && !isBooleanResult) continue;
                    result2.add(analyzer.contractEquation(i, Value.Null, stable));
                    result2.add(analyzer.contractEquation(i, Value.NotNull, stable));
                }
            }

            private List<Equation<Key, Value>> topEquations(Method method, Type[] argumentTypes, boolean isReferenceResult, boolean isInterestingResult, boolean stable) {
                ArrayList<Equation<Key, Value>> result2 = new ArrayList<Equation<Key, Value>>(argumentTypes.length * 4 + 2);
                if (isReferenceResult) {
                    result2.add(new Equation<Key, Value>(new Key(method, Direction.Out, stable), FINAL_TOP));
                    result2.add(new Equation<Key, Value>(new Key(method, Direction.NullableOut, stable), FINAL_BOT));
                }
                for (int i = 0; i < argumentTypes.length; ++i) {
                    if (!ASMUtils.isReferenceType(argumentTypes[i])) continue;
                    result2.add(new Equation<Key, Value>(new Key(method, new Direction.In(i, 0), stable), FINAL_TOP));
                    result2.add(new Equation<Key, Value>(new Key(method, new Direction.In(i, 1), stable), FINAL_TOP));
                    if (!isInterestingResult) continue;
                    result2.add(new Equation<Key, Value>(new Key(method, new Direction.InOut(i, Value.Null), stable), FINAL_TOP));
                    result2.add(new Equation<Key, Value>(new Key(method, new Direction.InOut(i, Value.NotNull), stable), FINAL_TOP));
                }
                return result2;
            }

            @NotNull
            private LeakingParameters leakingParametersAndFrames(Method method, MethodNode methodNode, Type[] argumentTypes, boolean jsr) throws AnalyzerException {
                LeakingParameters leakingParameters = argumentTypes.length < 32 ? LeakingParameters.buildFast(method.internalClassName, methodNode, jsr) : LeakingParameters.build(method.internalClassName, methodNode, jsr);
                if (leakingParameters == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ClassDataIndexer$1", "leakingParametersAndFrames"));
                }
                return leakingParameters;
            }
        }, 6);
        return equations;
    }
}

