/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.AbstractValues;
import com.intellij.codeInspection.bytecodeAnalysis.Conf;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.Equation;
import com.intellij.codeInspection.bytecodeAnalysis.Key;
import com.intellij.codeInspection.bytecodeAnalysis.Method;
import com.intellij.codeInspection.bytecodeAnalysis.State;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ControlFlowGraph;
import com.intellij.codeInspection.bytecodeAnalysis.asm.DFSTree;
import com.intellij.codeInspection.bytecodeAnalysis.asm.RichControlFlow;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

abstract class Analysis<Res> {
    public static final int STEPS_LIMIT = 30000;
    public static final int EQUATION_SIZE_LIMIT = 30;
    final RichControlFlow richControlFlow;
    final Direction direction;
    final ControlFlowGraph controlFlow;
    final MethodNode methodNode;
    final Method method;
    final DFSTree dfsTree;
    protected final List<State>[] computed;
    final Key aKey;
    Res earlyResult = null;

    protected Analysis(RichControlFlow richControlFlow, Direction direction, boolean stable) {
        this.richControlFlow = richControlFlow;
        this.direction = direction;
        this.controlFlow = richControlFlow.controlFlow;
        this.methodNode = this.controlFlow.methodNode;
        this.method = new Method(this.controlFlow.className, this.methodNode.name, this.methodNode.desc);
        this.dfsTree = richControlFlow.dfsTree;
        this.aKey = new Key(this.method, direction, stable);
        this.computed = new List[this.controlFlow.transitions.length];
    }

    final State createStartState() {
        return new State(0, new Conf(0, this.createStartFrame()), new ArrayList<Conf>(), false, false);
    }

    static boolean stateEquiv(State curr, State prev) {
        if (curr.taken != prev.taken) {
            return false;
        }
        if (curr.conf.fastHashCode != prev.conf.fastHashCode) {
            return false;
        }
        if (!AbstractValues.equiv(curr.conf, prev.conf)) {
            return false;
        }
        if (curr.history.size() != prev.history.size()) {
            return false;
        }
        for (int i = 0; i < curr.history.size(); ++i) {
            Conf curr1 = curr.history.get(i);
            Conf prev1 = prev.history.get(i);
            if (curr1.fastHashCode == prev1.fastHashCode && AbstractValues.equiv(curr1, prev1)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    protected abstract Equation<Key, Value> analyze() throws AnalyzerException;

    final Frame<BasicValue> createStartFrame() {
        Frame frame = new Frame(this.methodNode.maxLocals, this.methodNode.maxStack);
        Type returnType = Type.getReturnType((String)this.methodNode.desc);
        BasicValue returnValue = Type.VOID_TYPE.equals((Object)returnType) ? null : new BasicValue(returnType);
        frame.setReturn((org.jetbrains.org.objectweb.asm.tree.analysis.Value)returnValue);
        Type[] args = Type.getArgumentTypes((String)this.methodNode.desc);
        int local = 0;
        if ((this.methodNode.access & 8) == 0) {
            frame.setLocal(local++, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)new AbstractValues.NotNullValue(Type.getObjectType((String)this.controlFlow.className)));
        }
        for (int i = 0; i < args.length; ++i) {
            BasicValue value = this.direction instanceof Direction.InOut && ((Direction.InOut)this.direction).paramIndex == i || this.direction instanceof Direction.In && ((Direction.In)this.direction).paramIndex == i ? new AbstractValues.ParamValue(args[i]) : new BasicValue(args[i]);
            frame.setLocal(local++, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)value);
            if (args[i].getSize() != 2) continue;
            frame.setLocal(local++, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)BasicValue.UNINITIALIZED_VALUE);
        }
        while (local < this.methodNode.maxLocals) {
            frame.setLocal(local++, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)BasicValue.UNINITIALIZED_VALUE);
        }
        return frame;
    }

    static BasicValue popValue(Frame<BasicValue> frame) {
        return (BasicValue)frame.getStack(frame.getStackSize() - 1);
    }

    static <A> List<A> append(List<A> xs, A x) {
        ArrayList<A> result2 = new ArrayList<A>();
        if (xs != null) {
            result2.addAll(xs);
        }
        result2.add(x);
        return result2;
    }

    protected void addComputed(int i, State s) {
        List<State> states = this.computed[i];
        if (states == null) {
            this.computed[i] = states = new ArrayList<State>();
        }
        states.add(s);
    }
}

