/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnimplementInterfaceAction
implements IntentionAction {
    private String myName = "Interface";

    @NotNull
    public String getText() {
        String string = "Unimplement " + this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/actions/UnimplementInterfaceAction", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Unimplement Interface/Class" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/actions/UnimplementInterfaceAction", "getFamilyName"));
        }
        return "Unimplement Interface/Class";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/UnimplementInterfaceAction", "isAvailable"));
        }
        if (!(file2 instanceof PsiJavaFile)) {
            return false;
        }
        PsiReference psiReference = TargetElementUtil.findReference(editor);
        if (psiReference == null) {
            return false;
        }
        PsiReferenceList referenceList = (PsiReferenceList)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiReferenceList.class);
        if (referenceList == null) {
            return false;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)referenceList, PsiClass.class);
        if (psiClass == null) {
            return false;
        }
        if (psiClass.getExtendsList() != referenceList && psiClass.getImplementsList() != referenceList) {
            return false;
        }
        PsiJavaCodeReferenceElement referenceElement = UnimplementInterfaceAction.getTopLevelRef(psiReference, referenceList);
        if (referenceElement == null) {
            return false;
        }
        PsiElement target = referenceElement.resolve();
        if (target == null || !(target instanceof PsiClass)) {
            return false;
        }
        PsiClass targetClass = (PsiClass)target;
        this.myName = targetClass.isInterface() ? "Interface" : "Class";
        return true;
    }

    @Nullable
    private static PsiJavaCodeReferenceElement getTopLevelRef(PsiReference psiReference, PsiReferenceList referenceList) {
        PsiElement element = psiReference.getElement();
        while (element.getParent() != referenceList) {
            if ((element = element.getParent()) != null) continue;
            return null;
        }
        if (!(element instanceof PsiJavaCodeReferenceElement)) {
            return null;
        }
        return (PsiJavaCodeReferenceElement)element;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        PsiMethod[] psiMethods;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/UnimplementInterfaceAction", "invoke"));
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)file2)) {
            return;
        }
        PsiReference psiReference = TargetElementUtil.findReference(editor);
        if (psiReference == null) {
            return;
        }
        PsiReferenceList referenceList = (PsiReferenceList)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiReferenceList.class);
        if (referenceList == null) {
            return;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)referenceList, PsiClass.class);
        if (psiClass == null) {
            return;
        }
        if (psiClass.getExtendsList() != referenceList && psiClass.getImplementsList() != referenceList) {
            return;
        }
        PsiJavaCodeReferenceElement element = UnimplementInterfaceAction.getTopLevelRef(psiReference, referenceList);
        if (element == null) {
            return;
        }
        PsiElement target = element.resolve();
        if (target == null || !(target instanceof PsiClass)) {
            return;
        }
        PsiClass targetClass = (PsiClass)target;
        HashMap implementations = new HashMap();
        for (PsiMethod psiMethod : targetClass.getAllMethods()) {
            PsiMethod implementingMethod = MethodSignatureUtil.findMethodBySuperMethod((PsiClass)psiClass, (PsiMethod)psiMethod, (boolean)false);
            if (implementingMethod == null) continue;
            implementations.put(psiMethod, implementingMethod);
        }
        element.delete();
        if (target == psiClass) {
            return;
        }
        HashSet superMethods = new HashSet();
        for (PsiClass aClass : psiClass.getSupers()) {
            Collections.addAll(superMethods, aClass.getAllMethods());
        }
        for (PsiMethod psiMethod : psiMethods = targetClass.getAllMethods()) {
            PsiMethod impl;
            if (superMethods.contains(psiMethod) || (impl = (PsiMethod)implementations.get(psiMethod)) == null) continue;
            impl.delete();
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

