/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FlatteningIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import org.jetbrains.annotations.Nullable;

public abstract class ComparingClassifier<T>
extends Classifier<T> {
    protected final String myName;
    private final boolean myNegated;

    public ComparingClassifier(Classifier<T> next, String name) {
        this(next, name, false);
    }

    protected ComparingClassifier(Classifier<T> next, String name, boolean negated) {
        super(next);
        this.myName = name;
        this.myNegated = negated;
    }

    @Nullable
    public abstract Comparable getWeight(T var1, ProcessingContext var2);

    @Override
    public Iterable<T> classify(Iterable<T> source, final ProcessingContext context) {
        List nulls = null;
        TreeMap<Comparable, SmartList> map = new TreeMap<Comparable, SmartList>();
        for (T t : source) {
            Comparable weight = this.getWeight(t, context);
            if (weight == null) {
                if (nulls == null) {
                    nulls = new SmartList();
                }
                nulls.add(t);
                continue;
            }
            List list = (List)map.get(weight);
            if (list == null) {
                list = new SmartList();
                map.put(weight, (SmartList)list);
            }
            list.add(t);
        }
        final ArrayList values = new ArrayList();
        values.addAll(this.myNegated ? map.descendingMap().values() : map.values());
        ContainerUtil.addIfNotNull(values, (Object)nulls);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new FlatteningIterator<List<T>, T>(values.iterator()){

                    protected Iterator<T> createValueIterator(List<T> group) {
                        return ComparingClassifier.this.myNext.classify(group, context).iterator();
                    }
                };
            }
        };
    }

    @Override
    public void describeItems(LinkedHashMap<T, StringBuilder> map, ProcessingContext context) {
        IdentityHashMap<T, String> weights = new IdentityHashMap<T, String>();
        for (T t : map.keySet()) {
            weights.put(t, String.valueOf(this.getWeight(t, context)));
        }
        if (new HashSet(weights.values()).size() > 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            for (T t : map.keySet()) {
                StringBuilder builder = map.get(t);
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(this.myName).append("=").append((String)weights.get(t));
            }
        }
        super.describeItems(map, context);
    }
}

