/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.util.Comparing;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class IntentionActionWithTextCaching
implements Comparable<IntentionActionWithTextCaching>,
PossiblyDumbAware,
ShortcutProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching");
    private final List<IntentionAction> myOptionIntentions;
    private final List<IntentionAction> myOptionErrorFixes;
    private final List<IntentionAction> myOptionInspectionFixes;
    private final String myText;
    private final IntentionAction myAction;
    private final String myDisplayName;
    private final Icon myIcon;

    IntentionActionWithTextCaching(@NotNull IntentionAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "<init>"));
        }
        this(action, action.getText(), null);
    }

    IntentionActionWithTextCaching(@NotNull HighlightInfo.IntentionActionDescriptor action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "<init>"));
        }
        this(action.getAction(), action.getDisplayName(), action.getIcon());
    }

    private IntentionActionWithTextCaching(@NotNull IntentionAction action, String displayName, @Nullable Icon icon) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "<init>"));
        }
        this.myOptionIntentions = new ArrayList<IntentionAction>();
        this.myOptionErrorFixes = new ArrayList<IntentionAction>();
        this.myOptionInspectionFixes = new ArrayList<IntentionAction>();
        this.myIcon = icon;
        this.myText = action.getText();
        LOG.assertTrue(this.myText != null, (Object)("action " + action.getClass() + " text returned null"));
        this.myAction = action;
        this.myDisplayName = displayName;
    }

    @NotNull
    String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "getText"));
        }
        return string;
    }

    void addIntention(@NotNull IntentionAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "addIntention"));
        }
        this.myOptionIntentions.add(action);
    }

    void addErrorFix(@NotNull IntentionAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "addErrorFix"));
        }
        this.myOptionErrorFixes.add(action);
    }

    void addInspectionFix(@NotNull IntentionAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "addInspectionFix"));
        }
        this.myOptionInspectionFixes.add(action);
    }

    @NotNull
    IntentionAction getAction() {
        IntentionAction intentionAction = this.myAction;
        if (intentionAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "getAction"));
        }
        return intentionAction;
    }

    @NotNull
    List<IntentionAction> getOptionIntentions() {
        List<IntentionAction> list = this.myOptionIntentions;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "getOptionIntentions"));
        }
        return list;
    }

    @NotNull
    List<IntentionAction> getOptionErrorFixes() {
        List<IntentionAction> list = this.myOptionErrorFixes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "getOptionErrorFixes"));
        }
        return list;
    }

    @NotNull
    List<IntentionAction> getOptionInspectionFixes() {
        List<IntentionAction> list = this.myOptionInspectionFixes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "getOptionInspectionFixes"));
        }
        return list;
    }

    String getToolName() {
        return this.myDisplayName;
    }

    @NotNull
    public String toString() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "toString"));
        }
        return string;
    }

    @Override
    public int compareTo(@NotNull IntentionActionWithTextCaching other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "compareTo"));
        }
        if (this.myAction instanceof Comparable) {
            return ((Comparable)this.myAction).compareTo(other.getAction());
        }
        if (other.getAction() instanceof Comparable) {
            return ((Comparable)other.getAction()).compareTo(this.myAction);
        }
        return Comparing.compare((Comparable)((Object)this.getText()), (Comparable)((Object)other.getText()));
    }

    Icon getIcon() {
        return this.myIcon;
    }

    public boolean isDumbAware() {
        return DumbService.isDumbAware((Object)this.myAction);
    }

    @Nullable
    public ShortcutSet getShortcut() {
        return this.myAction instanceof ShortcutProvider ? ((ShortcutProvider)this.myAction).getShortcut() : null;
    }
}

