/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiConcatenationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConcatenationToMessageFormatAction
implements IntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.replace.concatenation.with.formatted.output.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ConcatenationToMessageFormatAction", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"intention.replace.concatenation.with.formatted.output.text", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ConcatenationToMessageFormatAction", "getText"));
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/ConcatenationToMessageFormatAction", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiElement element = ConcatenationToMessageFormatAction.findElementAtCaret(editor, file2);
        PsiPolyadicExpression concatenation = ConcatenationToMessageFormatAction.getEnclosingLiteralConcatenation(element);
        if (concatenation == null) {
            return;
        }
        StringBuilder formatString = new StringBuilder();
        ArrayList args = new ArrayList();
        PsiConcatenationUtil.buildFormatString((PsiExpression)concatenation, (StringBuilder)formatString, args, (boolean)false);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiMethodCallExpression call = (PsiMethodCallExpression)factory.createExpressionFromText("java.text.MessageFormat.format()", (PsiElement)concatenation);
        PsiExpressionList argumentList = call.getArgumentList();
        PsiExpression formatArgument = factory.createExpressionFromText("\"" + formatString.toString() + "\"", null);
        argumentList.add((PsiElement)formatArgument);
        if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)file2)) {
            for (PsiExpression arg : args) {
                argumentList.add((PsiElement)arg);
            }
        } else {
            PsiNewExpression arrayArg = (PsiNewExpression)factory.createExpressionFromText("new java.lang.Object[]{}", null);
            PsiArrayInitializerExpression arrayInitializer = arrayArg.getArrayInitializer();
            assert (arrayInitializer != null);
            for (PsiExpression arg : args) {
                arrayInitializer.add((PsiElement)arg);
            }
            argumentList.add((PsiElement)arrayArg);
        }
        call = (PsiMethodCallExpression)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)call);
        call = (PsiMethodCallExpression)CodeStyleManager.getInstance((Project)element.getManager().getProject()).reformat((PsiElement)call);
        concatenation.replace((PsiElement)call);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/ConcatenationToMessageFormatAction", "isAvailable"));
        }
        if (PsiUtil.getLanguageLevel((PsiElement)file2).compareTo((Enum)LanguageLevel.JDK_1_4) < 0) {
            return false;
        }
        PsiElement element = ConcatenationToMessageFormatAction.findElementAtCaret(editor, file2);
        PsiPolyadicExpression binaryExpression = ConcatenationToMessageFormatAction.getEnclosingLiteralConcatenation(element);
        return binaryExpression != null && !AnnotationUtil.isInsideAnnotation((PsiElement)binaryExpression);
    }

    @Nullable
    private static PsiElement findElementAtCaret(Editor editor, PsiFile file2) {
        return file2.findElementAt(editor.getCaretModel().getOffset());
    }

    @Nullable
    private static PsiPolyadicExpression getEnclosingLiteralConcatenation(PsiElement element) {
        PsiPolyadicExpression binaryExpression = (PsiPolyadicExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiPolyadicExpression.class, (boolean)false, (Class[])new Class[]{PsiMember.class});
        if (binaryExpression == null) {
            return null;
        }
        PsiClassType stringType = PsiType.getJavaLangString((PsiManager)element.getManager(), (GlobalSearchScope)element.getResolveScope());
        if (!stringType.equals((Object)binaryExpression.getType())) {
            return null;
        }
        PsiElement parent;
        while ((parent = binaryExpression.getParent()) instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression parentBinaryExpression = (PsiPolyadicExpression)parent;
            if (!stringType.equals((Object)parentBinaryExpression.getType())) {
                return binaryExpression;
            }
            binaryExpression = parentBinaryExpression;
        }
        return binaryExpression;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

