/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class AddOverrideAnnotationAction
implements IntentionAction {
    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"intention.add.override.annotation", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/AddOverrideAnnotationAction", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.add.override.annotation.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/AddOverrideAnnotationAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        PsiMethod[] superMethods;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/AddOverrideAnnotationAction", "isAvailable"));
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)file2)) {
            return false;
        }
        if (!file2.getManager().isInProject((PsiElement)file2)) {
            return false;
        }
        PsiMethod method = AddOverrideAnnotationAction.findMethod(file2, editor.getCaretModel().getOffset());
        if (method == null) {
            return false;
        }
        if (method.getModifierList().findAnnotation("java.lang.Override") != null) {
            return false;
        }
        for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
            if (superMethod.hasModifierProperty("abstract") || !new AddAnnotationFix("java.lang.Override", (PsiModifierListOwner)method, new String[0]).isAvailable(project, editor, file2)) continue;
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/AddOverrideAnnotationAction", "invoke"));
        }
        PsiMethod method = AddOverrideAnnotationAction.findMethod(file2, editor.getCaretModel().getOffset());
        if (method != null) {
            new AddAnnotationFix("java.lang.Override", (PsiModifierListOwner)method, new String[0]).invoke(project, editor, file2);
        }
    }

    private static PsiMethod findMethod(PsiFile file2, int offset) {
        PsiElement element = file2.findElementAt(offset);
        PsiMethod res = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        if (res == null) {
            return null;
        }
        PsiCodeBlock body = res.getBody();
        if (body == null) {
            return null;
        }
        TextRange textRange = body.getTextRange();
        if (textRange == null || textRange.getStartOffset() <= offset) {
            return null;
        }
        return res;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

