/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class JavaQuoteHandler
extends SimpleTokenSetQuoteHandler
implements JavaLikeQuoteHandler {
    private final TokenSet concatenatableStrings = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.STRING_LITERAL});

    public JavaQuoteHandler() {
        super(JavaTokenType.STRING_LITERAL, JavaTokenType.CHARACTER_LITERAL);
    }

    @Override
    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        boolean openingQuote = super.isOpeningQuote(iterator, offset);
        if (openingQuote && !iterator.atEnd()) {
            iterator.retreat();
            if (!iterator.atEnd() && StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(iterator.getTokenType())) {
                openingQuote = false;
            }
            iterator.advance();
        }
        return openingQuote;
    }

    @Override
    public boolean isClosingQuote(HighlighterIterator iterator, int offset) {
        boolean closingQuote = super.isClosingQuote(iterator, offset);
        if (closingQuote && !iterator.atEnd()) {
            iterator.advance();
            if (!iterator.atEnd() && StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(iterator.getTokenType())) {
                closingQuote = false;
            }
            iterator.retreat();
        }
        return closingQuote;
    }

    @Override
    public TokenSet getConcatenatableStringTokenTypes() {
        return this.concatenatableStrings;
    }

    @Override
    public String getStringConcatenationOperatorRepresentation() {
        return "+";
    }

    @Override
    public TokenSet getStringTokenTypes() {
        return this.myLiteralTokenSet;
    }

    @Override
    public boolean isAppropriateElementTypeForLiteral(@NotNull IElementType tokenType) {
        if (tokenType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenType", "com/intellij/codeInsight/editorActions/JavaQuoteHandler", "isAppropriateElementTypeForLiteral"));
        }
        return JavaQuoteHandler.isAppropriateElementTypeForLiteralStatic(tokenType);
    }

    @Override
    public boolean needParenthesesAroundConcatenation(PsiElement element) {
        return element.getParent() instanceof PsiLiteralExpression && element.getParent().getParent() instanceof PsiReferenceExpression;
    }

    public static boolean isAppropriateElementTypeForLiteralStatic(IElementType tokenType) {
        return ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(tokenType) || tokenType == JavaTokenType.SEMICOLON || tokenType == JavaTokenType.COMMA || tokenType == JavaTokenType.RPARENTH || tokenType == JavaTokenType.RBRACKET || tokenType == JavaTokenType.RBRACE || tokenType == JavaTokenType.STRING_LITERAL || tokenType == JavaTokenType.CHARACTER_LITERAL;
    }
}

