/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.file.JavaDirectoryServiceImpl;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveClassToSeparateFileFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance(MoveClassToSeparateFileFix.class);
    private final PsiClass myClass;

    public MoveClassToSeparateFileFix(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/quickfix/MoveClassToSeparateFileFix", "<init>"));
        }
        this.myClass = aClass;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("move.class.to.separate.file.text", this.myClass.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MoveClassToSeparateFileFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("move.class.to.separate.file.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MoveClassToSeparateFileFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/MoveClassToSeparateFileFix", "isAvailable"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/MoveClassToSeparateFileFix", "isAvailable"));
        }
        if (!this.myClass.isValid() || !this.myClass.getManager().isInProject((PsiElement)this.myClass)) {
            return false;
        }
        PsiDirectory dir = file2.getContainingDirectory();
        if (dir == null) {
            return false;
        }
        try {
            JavaDirectoryServiceImpl.checkCreateClassOrInterface(dir, this.myClass.getName());
        }
        catch (IncorrectOperationException e) {
            return false;
        }
        return true;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/MoveClassToSeparateFileFix", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/MoveClassToSeparateFileFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(this.myClass.getContainingFile())) {
            return;
        }
        PsiDirectory dir = file2.getContainingDirectory();
        try {
            String name = this.myClass.getName();
            JavaDirectoryService directoryService = JavaDirectoryService.getInstance();
            PsiClass placeHolder = this.myClass.isInterface() ? directoryService.createInterface(dir, name) : directoryService.createClass(dir, name);
            PsiClass newClass = (PsiClass)placeHolder.replace((PsiElement)this.myClass);
            this.myClass.delete();
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, newClass.getContainingFile().getVirtualFile(), newClass.getTextOffset());
            FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

