/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiFile;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplementMethodsFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    public ImplementMethodsFix(PsiElement aClass) {
        super(aClass);
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("implement.methods.fix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ImplementMethodsFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ImplementMethodsFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ImplementMethodsFix", "isAvailable"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/ImplementMethodsFix", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/ImplementMethodsFix", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/ImplementMethodsFix", "isAvailable"));
        }
        PsiElement myPsiElement = startElement;
        return myPsiElement.isValid() && myPsiElement.getManager().isInProject(myPsiElement);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file2, final @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ImplementMethodsFix", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/ImplementMethodsFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/ImplementMethodsFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/ImplementMethodsFix", "invoke"));
        }
        final PsiElement myPsiElement = startElement;
        if (editor == null || !FileModificationService.getInstance().prepareFileForWrite(myPsiElement.getContainingFile())) {
            return;
        }
        if (myPsiElement instanceof PsiEnumConstant) {
            boolean hasClassInitializer = ((PsiEnumConstant)myPsiElement).getInitializingClass() != null;
            final MemberChooser<PsiMethodMember> chooser = ImplementMethodsFix.chooseMethodsToImplement(editor, startElement, ((PsiEnumConstant)myPsiElement).getContainingClass(), hasClassInitializer);
            if (chooser == null) {
                return;
            }
            final List<PsiMethodMember> selectedElements = chooser.getSelectedElements();
            if (selectedElements == null || selectedElements.isEmpty()) {
                return;
            }
            new WriteCommandAction(project, new PsiFile[]{file2}){

                protected void run(@NotNull Result result2) throws Throwable {
                    if (result2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/impl/quickfix/ImplementMethodsFix$1", "run"));
                    }
                    PsiEnumConstantInitializer psiClass = ((PsiEnumConstant)myPsiElement).getOrCreateInitializingClass();
                    OverrideImplementUtil.overrideOrImplementMethodsInRightPlace(editor, (PsiClass)psiClass, selectedElements, chooser.isCopyJavadoc(), chooser.isInsertOverrideAnnotation());
                }
            }.execute();
        } else {
            OverrideImplementUtil.chooseAndImplementMethods(project, editor, (PsiClass)myPsiElement);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    protected static MemberChooser<PsiMethodMember> chooseMethodsToImplement(Editor editor, PsiElement startElement, PsiClass aClass, boolean implemented) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.overrideimplement");
        Collection<CandidateInfo> overrideImplement = OverrideImplementExploreUtil.getMapToOverrideImplement(aClass, true, implemented).values();
        return OverrideImplementUtil.showOverrideImplementChooser(editor, startElement, true, overrideImplement, ContainerUtil.newArrayList());
    }
}

