/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtendsListFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.ExtendsListFix");
    final PsiClass myClassToExtendFrom;
    private final boolean myToAdd;
    private final PsiClassType myTypeToExtendFrom;
    private final String myName;

    public ExtendsListFix(@NotNull PsiClass aClass, @NotNull PsiClassType typeToExtendFrom, boolean toAdd) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListFix", "<init>"));
        }
        if (typeToExtendFrom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeToExtendFrom", "com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListFix", "<init>"));
        }
        this(aClass, typeToExtendFrom.resolve(), typeToExtendFrom, toAdd);
    }

    public ExtendsListFix(@NotNull PsiClass aClass, @NotNull PsiClass classToExtendFrom, boolean toAdd) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListFix", "<init>"));
        }
        if (classToExtendFrom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classToExtendFrom", "com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListFix", "<init>"));
        }
        this(aClass, classToExtendFrom, JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createType(classToExtendFrom), toAdd);
    }

    private ExtendsListFix(@NotNull PsiClass aClass, PsiClass classToExtendFrom, @NotNull PsiClassType typeToExtendFrom, boolean toAdd) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListFix", "<init>"));
        }
        if (typeToExtendFrom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeToExtendFrom", "com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListFix", "<init>"));
        }
        super((PsiElement)aClass);
        this.myClassToExtendFrom = classToExtendFrom;
        this.myToAdd = toAdd;
        this.myTypeToExtendFrom = (PsiClassType)GenericsUtil.eliminateWildcards((PsiType)typeToExtendFrom);
        String messageKey = classToExtendFrom != null && aClass.isInterface() == classToExtendFrom.isInterface() ? (toAdd ? "add.class.to.extends.list" : "remove.class.from.extends.list") : (toAdd ? "add.interface.to.implements.list" : "remove.interface.from.implements.list");
        this.myName = QuickFixBundle.message(messageKey, aClass.getName(), classToExtendFrom == null ? "" : (classToExtendFrom instanceof PsiTypeParameter ? classToExtendFrom.getName() : classToExtendFrom.getQualifiedName()));
    }

    @NotNull
    public String getText() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("change.extends.list.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListFix", "isAvailable"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListFix", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListFix", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListFix", "isAvailable"));
        }
        PsiClass myClass = (PsiClass)startElement;
        return myClass.isValid() && myClass.getManager().isInProject((PsiElement)myClass) && this.myClassToExtendFrom != null && this.myClassToExtendFrom.isValid() && !this.myClassToExtendFrom.hasModifierProperty("final") && (this.myClassToExtendFrom.isInterface() || !myClass.isInterface() && myClass.getExtendsList() != null && myClass.getExtendsList().getReferencedTypes().length == 0 == this.myToAdd);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListFix", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListFix", "invoke"));
        }
        PsiClass myClass = (PsiClass)startElement;
        this.invokeImpl(myClass);
        UndoUtil.markPsiFileForUndo((PsiFile)file2);
    }

    protected void invokeImpl(PsiClass myClass) {
        if (!FileModificationService.getInstance().prepareFileForWrite(myClass.getContainingFile())) {
            return;
        }
        PsiReferenceList extendsList = !(myClass instanceof PsiTypeParameter) && myClass.isInterface() != this.myClassToExtendFrom.isInterface() ? myClass.getImplementsList() : myClass.getExtendsList();
        PsiReferenceList otherList = extendsList == myClass.getImplementsList() ? myClass.getExtendsList() : myClass.getImplementsList();
        try {
            if (extendsList != null) {
                this.modifyList(extendsList, this.myToAdd, -1);
            }
            if (otherList != null) {
                this.modifyList(otherList, false, -1);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    PsiReferenceList modifyList(@NotNull PsiReferenceList extendsList, boolean add, int position) throws IncorrectOperationException {
        if (extendsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extendsList", "com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListFix", "modifyList"));
        }
        PsiJavaCodeReferenceElement[] referenceElements = extendsList.getReferenceElements();
        boolean alreadyExtends = false;
        for (PsiJavaCodeReferenceElement referenceElement : referenceElements) {
            if (!referenceElement.getManager().areElementsEquivalent((PsiElement)this.myClassToExtendFrom, referenceElement.resolve())) continue;
            alreadyExtends = true;
            if (add) continue;
            referenceElement.delete();
        }
        PsiReferenceList list = extendsList;
        if (add && !alreadyExtends) {
            PsiJavaCodeReferenceElement anchor = position == -1 ? (referenceElements.length == 0 ? null : referenceElements[referenceElements.length - 1]) : (position == 0 ? null : referenceElements[position - 1]);
            PsiJavaCodeReferenceElement classReferenceElement = JavaPsiFacade.getInstance((Project)extendsList.getProject()).getElementFactory().createReferenceElementByType(this.myTypeToExtendFrom);
            PsiElement element = anchor == null ? (referenceElements.length == 0 ? extendsList.add((PsiElement)classReferenceElement) : extendsList.addBefore((PsiElement)classReferenceElement, (PsiElement)referenceElements[0])) : extendsList.addAfter((PsiElement)classReferenceElement, (PsiElement)anchor);
            list = (PsiReferenceList)element.getParent();
        }
        if (!add && !alreadyExtends) {
            return list;
        }
        return (PsiReferenceList)JavaCodeStyleManager.getInstance((Project)extendsList.getProject()).shortenClassReferences((PsiElement)list);
    }
}

