/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFieldFromUsageHelper;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateVarFromUsageFix;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CreateFieldFromUsageFix
extends CreateVarFromUsageFix {
    public CreateFieldFromUsageFix(@NotNull PsiReferenceExpression referenceElement) {
        if (referenceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceElement", "com/intellij/codeInsight/daemon/impl/quickfix/CreateFieldFromUsageFix", "<init>"));
        }
        super(referenceElement);
    }

    @Override
    protected String getText(String varName) {
        return QuickFixBundle.message("create.field.from.usage.text", varName);
    }

    protected boolean createConstantField() {
        return false;
    }

    @Override
    @NotNull
    protected List<PsiClass> getTargetClasses(PsiElement element) {
        ArrayList<PsiClass> targetClasses = new ArrayList<PsiClass>();
        for (PsiClass psiClass : super.getTargetClasses(element)) {
            if (!psiClass.getManager().isInProject((PsiElement)psiClass) || (psiClass.isInterface() || psiClass.isAnnotationType()) && !CreateFieldFromUsageFix.shouldCreateStaticMember(this.myReferenceExpression, psiClass)) continue;
            targetClasses.add(psiClass);
        }
        ArrayList<PsiClass> arrayList = targetClasses;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CreateFieldFromUsageFix", "getTargetClasses"));
        }
        return arrayList;
    }

    @Override
    protected boolean canBeTargetClass(PsiClass psiClass) {
        return psiClass.getManager().isInProject((PsiElement)psiClass) && !psiClass.isInterface() && !psiClass.isAnnotationType();
    }

    @Override
    protected void invokeImpl(PsiClass targetClass) {
        PsiClass parentClass;
        Project project = this.myReferenceExpression.getProject();
        JVMElementFactory factory = JVMElementFactories.getFactory((Language)targetClass.getLanguage(), (Project)project);
        if (factory == null) {
            factory = JavaPsiFacade.getElementFactory((Project)project);
        }
        PsiReferenceExpression enclosingContext = null;
        while ((parentClass = (enclosingContext = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)(enclosingContext == null ? this.myReferenceExpression : enclosingContext), (Class[])new Class[]{PsiMethod.class, PsiField.class, PsiClassInitializer.class})) == null ? null : enclosingContext.getContainingClass()) instanceof PsiAnonymousClass) {
        }
        ExpectedTypeInfo[] expectedTypes = CreateFromUsageUtils.guessExpectedTypes((PsiExpression)this.myReferenceExpression, false);
        String fieldName = this.myReferenceExpression.getReferenceName();
        assert (fieldName != null);
        PsiField field = factory.createField(fieldName, (PsiType)PsiType.INT);
        if (this.createConstantField()) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"final", (boolean)true);
        }
        if (this.createConstantField()) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"static", (boolean)true);
            PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"final", (boolean)true);
        } else {
            if (!targetClass.isInterface() && CreateFieldFromUsageFix.shouldCreateStaticMember(this.myReferenceExpression, targetClass)) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"static", (boolean)true);
            }
            if (CreateFieldFromUsageFix.shouldCreateFinalMember(this.myReferenceExpression, targetClass)) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"final", (boolean)true);
            }
        }
        field = CreateFieldFromUsageHelper.insertField(targetClass, field, (PsiElement)this.myReferenceExpression);
        this.setupVisibility(parentClass, targetClass, field.getModifierList());
        CreateFieldFromUsageFix.createFieldFromUsageTemplate(targetClass, project, expectedTypes, field, this.createConstantField(), (PsiElement)this.myReferenceExpression);
    }

    public static void createFieldFromUsageTemplate(PsiClass targetClass, final Project project, ExpectedTypeInfo[] expectedTypes, PsiField field, boolean createConstantField, PsiElement context) {
        final PsiFile targetFile = targetClass.getContainingFile();
        final Editor newEditor = CreateFieldFromUsageFix.positionCursor(project, targetFile, (PsiElement)field);
        if (newEditor == null) {
            return;
        }
        Template template = CreateFieldFromUsageHelper.setupTemplate(field, expectedTypes, targetClass, newEditor, context, createConstantField);
        CreateFieldFromUsageFix.startTemplate(newEditor, template, project, new TemplateEditingAdapter(){

            @Override
            public void templateFinished(Template template, boolean brokenOff) {
                PsiDocumentManager.getInstance((Project)project).commitDocument(newEditor.getDocument());
                int offset = newEditor.getCaretModel().getOffset();
                final PsiField psiField = (PsiField)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)targetFile, (int)offset, PsiField.class, (boolean)false);
                if (psiField != null) {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)psiField);
                        }
                    });
                    newEditor.getCaretModel().moveToOffset(psiField.getTextRange().getEndOffset() - 1);
                }
            }
        });
    }

    private static boolean shouldCreateFinalMember(@NotNull PsiReferenceExpression ref, @NotNull PsiClass targetClass) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInsight/daemon/impl/quickfix/CreateFieldFromUsageFix", "shouldCreateFinalMember"));
        }
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/codeInsight/daemon/impl/quickfix/CreateFieldFromUsageFix", "shouldCreateFinalMember"));
        }
        if (!PsiTreeUtil.isAncestor((PsiElement)targetClass, (PsiElement)ref, (boolean)true)) {
            return false;
        }
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)ref, (Class[])new Class[]{PsiClassInitializer.class, PsiMethod.class});
        if (element instanceof PsiClassInitializer) {
            return true;
        }
        return element instanceof PsiMethod && ((PsiMethod)element).isConstructor();
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.field.from.usage.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CreateFieldFromUsageFix", "getFamilyName"));
        }
        return string;
    }
}

