/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class AddMethodBodyFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.AddMethodBodyFix");
    private final PsiMethod myMethod;

    public AddMethodBodyFix(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/quickfix/AddMethodBodyFix", "<init>"));
        }
        this.myMethod = method;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("add.method.body.text", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddMethodBodyFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddMethodBodyFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddMethodBodyFix", "isAvailable"));
        }
        return this.myMethod.isValid() && this.myMethod.getBody() == null && this.myMethod.getContainingClass() != null && this.myMethod.getManager().isInProject((PsiElement)this.myMethod);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddMethodBodyFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(this.myMethod.getContainingFile())) {
            return;
        }
        try {
            PsiUtil.setModifierProperty((PsiModifierListOwner)this.myMethod, (String)"abstract", (boolean)false);
            CreateFromUsageUtils.setupMethodBody(this.myMethod);
            CreateFromUsageUtils.setupEditor(this.myMethod, editor);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

