/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionVariant;
import com.intellij.codeInsight.completion.XmlCompletionData;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.OrFilter;
import com.intellij.psi.filters.TextContainFilter;
import com.intellij.psi.filters.getters.HtmlAttributeValueGetter;
import com.intellij.psi.filters.getters.XmlAttributeValueGetter;
import com.intellij.psi.filters.position.XmlTokenTypeFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NonNls;

public class HtmlCompletionData
extends XmlCompletionData {
    private boolean myCaseInsensitive;
    @NonNls
    private static final String JAVASCRIPT_LANGUAGE_ID = "JavaScript";

    public HtmlCompletionData() {
        this(true);
    }

    protected HtmlCompletionData(boolean _caseInsensitive) {
        this.myCaseInsensitive = _caseInsensitive;
    }

    @Override
    protected ElementFilter createXmlEntityCompletionFilter() {
        if (this.isCaseInsensitive()) {
            return new AndFilter((ElementFilter)new OrFilter(new XmlTokenTypeFilter(XmlTokenType.XML_DATA_CHARACTERS), new XmlTokenTypeFilter(XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN)), (ElementFilter)new TextContainFilter("&"));
        }
        return super.createXmlEntityCompletionFilter();
    }

    private boolean equalNames(String str, String str2) {
        if (!this.myCaseInsensitive) {
            return str.equals(str2);
        }
        return str.equalsIgnoreCase(str2);
    }

    protected boolean isCaseInsensitive() {
        return true;
    }

    public final boolean isCaseSensitive() {
        return !this.isCaseInsensitive();
    }

    protected void setCaseInsensitive(boolean caseInsensitive) {
        this.myCaseInsensitive = caseInsensitive;
    }

    @Override
    protected XmlAttributeValueGetter getAttributeValueGetter() {
        return new HtmlAttributeValueGetter(!this.isCaseInsensitive());
    }

    @Override
    protected ElementFilter createTagCompletionFilter() {
        return new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                String name = ((XmlTag)context).getName();
                if (element instanceof PsiElement && ((PsiElement)element).getParent() == context) {
                    return true;
                }
                if (HtmlCompletionData.this.equalNames(name, "style") || HtmlCompletionData.this.equalNames(name, "script")) {
                    return false;
                }
                return !HtmlCompletionData.this.isStyleAttributeContext((PsiElement)element);
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        };
    }

    @Override
    protected ElementFilter createAttributeCompletionFilter() {
        return new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                return !HtmlCompletionData.this.isStyleAttributeContext(context);
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        };
    }

    @Override
    protected ElementFilter createAttributeValueCompletionFilter() {
        return new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                if (HtmlCompletionData.this.isStyleAttributeContext(context)) {
                    return false;
                }
                return !HtmlCompletionData.isScriptContext((PsiElement)element);
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        };
    }

    private static boolean isScriptContext(PsiElement element) {
        Language language = element.getLanguage();
        return language.getID().equals(JAVASCRIPT_LANGUAGE_ID);
    }

    private boolean isStyleAttributeContext(PsiElement position) {
        XmlAttribute parentOfType = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)position, XmlAttribute.class, (boolean)false);
        return parentOfType != null && Comparing.strEqual((String)parentOfType.getName(), (String)"style", (!this.myCaseInsensitive ? 1 : 0) != 0);
    }

    @Override
    public void registerVariant(CompletionVariant variant) {
        super.registerVariant(variant);
        if (this.isCaseInsensitive()) {
            variant.setCaseInsensitive(true);
        }
    }

    @Override
    public String findPrefix(PsiElement insertedElement, int offset) {
        boolean searchForEntities;
        String prefix = super.findPrefix(insertedElement, offset);
        boolean bl = searchForEntities = insertedElement instanceof XmlToken && (((XmlToken)insertedElement).getTokenType() == XmlTokenType.XML_DATA_CHARACTERS || ((XmlToken)insertedElement).getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN);
        if (searchForEntities) {
            if (prefix.startsWith("&")) {
                prefix = prefix.substring(1);
            } else if (prefix.contains("&")) {
                prefix = prefix.substring(prefix.indexOf("&") + 1);
            }
        }
        return prefix;
    }
}

